CREATE TABLE FUNCS (
  FUNC_ID BIGINT NOT NULL,
  CLASS_NAME VARCHAR(4000),
  CREATE_TIME INTEGER NOT NULL,
  DB_ID BIGINT,
  FUNC_NAME VARCHAR(128),
  FUNC_TYPE INTEGER NOT NULL,
  OWNER_NAME VARCHAR(128),
  OWNER_TYPE VARCHAR(10)
);

CREATE UNIQUE INDEX UNIQUEFUNCTION ON FUNCS (FUNC_NAME, DB_ID);
CREATE INDEX FUNCS_N49 ON FUNCS (DB_ID);

ALTER TABLE FUNCS ADD CONSTRAINT FUNCS_PK PRIMARY KEY (FUNC_ID);
ALTER TABLE FUNCS ADD CONSTRAINT FUNCS_FK1 FOREIGN KEY (DB_ID) REFERENCES DBS (DB_ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

CREATE TABLE FUNC_RU (
  FUNC_ID BIGINT NOT NULL,
  RESOURCE_TYPE INTEGER NOT NULL,
  RESOURCE_URI VARCHAR(4000),
  INTEGER_IDX INTEGER NOT NULL
);

CREATE INDEX FUNC_RU_N49 ON FUNC_RU (FUNC_ID);
ALTER TABLE FUNC_RU ADD CONSTRAINT FUNC_RU_PK PRIMARY KEY (FUNC_ID, INTEGER_IDX);
ALTER TABLE FUNC_RU ADD CONSTRAINT FUNC_RU_FK1 FOREIGN KEY (FUNC_ID) REFERENCES FUNCS (FUNC_ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

