/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CompactionStrategyConfig {
    private String className;
    private Map<String, String> options = Collections.emptyMap();

    public CompactionStrategyConfig(String className) {
        Objects.requireNonNull(className);
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public CompactionStrategyConfig setOptions(Map<String, String> opts) {
        Objects.requireNonNull(opts);
        this.options = new HashMap<String, String>(opts);
        return this;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public int hashCode() {
        return this.className.hashCode() + this.options.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CompactionStrategyConfig) {
            CompactionStrategyConfig ocsc = (CompactionStrategyConfig)o;
            return this.className.equals(ocsc.className) && this.options.equals(ocsc.options);
        }
        return false;
    }
}

