/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.streaming.AbstractRecordWriter;
import org.apache.hive.streaming.SerializationError;

public class StrictRegexWriter
extends AbstractRecordWriter {
    private String regex;
    private RegexSerDe serde;

    private StrictRegexWriter(Builder builder) {
        super(builder.lineDelimiter);
        this.regex = builder.regex;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public RegexSerDe createSerde() throws SerializationError {
        try {
            Properties tableProps = this.table.getMetadata();
            tableProps.setProperty("input.regex", this.regex);
            tableProps.setProperty("columns", Joiner.on((String)",").join((Iterable)this.inputColumns));
            tableProps.setProperty("columns.types", Joiner.on((String)":").join((Iterable)this.inputTypes));
            String columnComments = tableProps.getProperty("columns.comments");
            if (columnComments != null) {
                ArrayList comments = Lists.newArrayList((Iterable)Splitter.on((char)'\u0000').split((CharSequence)columnComments));
                int commentsSize = comments.size();
                for (int i = 0; i < this.inputColumns.size() - commentsSize; ++i) {
                    comments.add("");
                }
                tableProps.setProperty("columns.comments", Joiner.on((char)'\u0000').join((Iterable)comments));
            }
            RegexSerDe serde = new RegexSerDe();
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)tableProps, null);
            this.serde = serde;
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + RegexSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    @Override
    public Object encode(byte[] utf8StrRecord) throws SerializationError {
        try {
            Text blob = new Text(utf8StrRecord);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }

    public static class Builder {
        private String regex;
        private String lineDelimiter;

        public Builder withRegex(String regex) {
            this.regex = regex;
            return this;
        }

        public Builder withLineDelimiterPattern(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public StrictRegexWriter build() {
            return new StrictRegexWriter(this);
        }
    }
}

