/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.DefaultHCatRecord;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspector;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspectorFactory;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "timestamp.formats"})
public class JsonSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerDe.class);
    private HCatSchema schema;
    private HCatRecordObjectInspector cachedObjectInspector;
    private org.apache.hadoop.hive.serde2.JsonSerDe jsonSerde = new org.apache.hadoop.hive.serde2.JsonSerDe();

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.jsonSerde.initialize(conf, tbl, false);
        StructTypeInfo rowTypeInfo = this.jsonSerde.getTypeInfo();
        this.cachedObjectInspector = HCatRecordObjectInspectorFactory.getHCatRecordObjectInspector(rowTypeInfo);
        try {
            this.schema = HCatSchemaUtils.getHCatSchema((TypeInfo)rowTypeInfo).get(0).getStructSubSchema();
            LOG.debug("schema : {}", (Object)this.schema);
            LOG.debug("fields : {}", this.schema.getFieldNames());
        }
        catch (HCatException e) {
            throw new SerDeException((Throwable)e);
        }
    }

    public Object deserialize(Writable blob) throws SerDeException {
        try {
            List row = (List)this.jsonSerde.deserialize(blob);
            List<Object> fatRow = JsonSerDe.fatLand(row);
            return new DefaultHCatRecord(fatRow);
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }

    private static List<Object> fatLand(List<?> arr) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : arr) {
            if (o == null) {
                ret.add(null);
                continue;
            }
            if (o instanceof Map) {
                ret.add(JsonSerDe.fatMap((Map)o));
                continue;
            }
            if (o instanceof List) {
                ret.add(JsonSerDe.fatLand((List)o));
                continue;
            }
            if (o.getClass().isArray() && o.getClass().getComponentType() != Byte.TYPE) {
                Class<?> ct = o.getClass().getComponentType();
                if (ct.isPrimitive()) {
                    ret.add(JsonSerDe.primitiveArrayToList(o));
                    continue;
                }
                ret.add(JsonSerDe.fatLand(Arrays.asList((Object[])o)));
                continue;
            }
            ret.add(o);
        }
        return ret;
    }

    private static Object fatMap(Map<Object, Object> map) {
        LinkedHashMap<Object, List<Object>> ret = new LinkedHashMap<Object, List<Object>>();
        Set<Map.Entry<Object, Object>> es = map.entrySet();
        for (Map.Entry<Object, Object> e : es) {
            List<Object> oldV = e.getValue();
            List<Object> newV = oldV != null && oldV.getClass().isArray() ? JsonSerDe.fatLand(Arrays.asList((Object[])oldV)) : oldV;
            ret.put(e.getKey(), newV);
        }
        return ret;
    }

    private static Object primitiveArrayToList(Object arr) {
        Class<?> ct = arr.getClass().getComponentType();
        if (Integer.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((int[])((int[])arr)));
        }
        if (Long.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((long[])((long[])arr)));
        }
        if (Character.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((char[])((char[])arr)));
        }
        if (Byte.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((byte[])((byte[])arr)));
        }
        if (Short.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((short[])((short[])arr)));
        }
        if (Float.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((float[])((float[])arr)));
        }
        if (Double.TYPE.equals(ct)) {
            return Arrays.asList(ArrayUtils.toObject((double[])((double[])arr)));
        }
        throw new RuntimeException("Unhandled primitiveArrayToList for type: " + ct);
    }

    public String getHiveInternalColumnName(int fpos) {
        return HiveConf.getColumnInternalName((int)fpos);
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        return this.jsonSerde.serialize(obj, objInspector);
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

