/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.desc.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.database.drop.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.database.show.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.ddl.database.use.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.desc.DescTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.status.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.ddl.table.info.show.tables.ShowTablesDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.show.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.ddl.table.storage.set.location.AlterTableSetLocationDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateDatabaseHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.CreateTableHook;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;
import org.apache.hive.hcatalog.common.ErrorType;
import org.apache.hive.hcatalog.common.HCatException;

public class HCatSemanticAnalyzer
extends HCatSemanticAnalyzerBase {
    private AbstractSemanticAnalyzerHook hook;
    private ASTNode ast;

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        this.ast = ast;
        switch (ast.getToken().getType()) {
            case 838: {
                this.hook = new CreateTableHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 834: {
                this.hook = new CreateDatabaseHook();
                return this.hook.preAnalyze(context, ast);
            }
            case 764: {
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 777) {
                    return ast;
                }
                if (((ASTNode)ast.getChild(1)).getToken().getType() == 779) {
                    throw new SemanticException("Operation not supported.");
                }
                return ast;
            }
            case 755: 
            case 765: 
            case 767: 
            case 770: 
            case 771: 
            case 774: 
            case 782: 
            case 783: 
            case 784: 
            case 786: 
            case 787: 
            case 788: 
            case 791: 
            case 796: 
            case 798: 
            case 800: 
            case 801: 
            case 837: 
            case 839: 
            case 865: 
            case 866: 
            case 867: 
            case 874: 
            case 877: 
            case 878: 
            case 879: 
            case 892: 
            case 908: 
            case 910: 
            case 912: 
            case 953: 
            case 1039: 
            case 1040: 
            case 1063: 
            case 1065: 
            case 1066: 
            case 1068: 
            case 1069: 
            case 1075: 
            case 1077: 
            case 1080: 
            case 1100: 
            case 1158: {
                return ast;
            }
        }
        throw new SemanticException("Operation not supported.");
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<?>> rootTasks) throws SemanticException {
        try {
            switch (this.ast.getToken().getType()) {
                case 755: 
                case 834: 
                case 838: 
                case 865: 
                case 874: 
                case 1063: 
                case 1100: {
                    break;
                }
                case 796: {
                    switch (this.ast.getChild(1).getType()) {
                        default: 
                    }
                    break;
                }
                case 837: 
                case 839: 
                case 866: 
                case 877: 
                case 879: 
                case 892: 
                case 908: 
                case 910: 
                case 912: 
                case 953: 
                case 1039: 
                case 1040: 
                case 1065: 
                case 1066: 
                case 1075: 
                case 1077: 
                case 1158: {
                    break;
                }
                case 764: {
                    switch (this.ast.getChild(1).getType()) {
                        default: 
                    }
                    break;
                }
                case 867: 
                case 878: 
                case 1068: 
                case 1069: 
                case 1080: {
                    break;
                }
                default: {
                    throw new HCatException(ErrorType.ERROR_INTERNAL_EXCEPTION, "Unexpected token: " + this.ast.getToken());
                }
            }
            this.authorizeDDL(context, rootTasks);
        }
        catch (HCatException e) {
            throw new SemanticException((Throwable)e);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        if (this.hook != null) {
            this.hook.postAnalyze(context, rootTasks);
        }
    }

    private String extractTableName(String compoundName) {
        String[] words = compoundName.split("\\.");
        return words[0];
    }

    @Override
    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext cntxt, Hive hive, DDLWork work) throws HiveException {
        DDLDesc ddlDesc = work.getDDLDesc();
        if (ddlDesc instanceof ShowDatabasesDesc) {
            this.authorize(HiveOperation.SHOWDATABASES.getInputRequiredPrivileges(), HiveOperation.SHOWDATABASES.getOutputRequiredPrivileges());
        } else if (ddlDesc instanceof DropDatabaseDesc) {
            DropDatabaseDesc dropDb = (DropDatabaseDesc)ddlDesc;
            Database db = cntxt.getHive().getDatabase(dropDb.getDatabaseName());
            if (db != null) {
                this.authorize(db, Privilege.DROP);
            }
        } else if (ddlDesc instanceof DescDatabaseDesc) {
            DescDatabaseDesc descDb = (DescDatabaseDesc)ddlDesc;
            Database db = cntxt.getHive().getDatabase(descDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        } else if (ddlDesc instanceof SwitchDatabaseDesc) {
            SwitchDatabaseDesc switchDb = (SwitchDatabaseDesc)ddlDesc;
            Database db = cntxt.getHive().getDatabase(switchDb.getDatabaseName());
            this.authorize(db, Privilege.SELECT);
        } else if (ddlDesc instanceof ShowTablesDesc) {
            ShowTablesDesc showTables = (ShowTablesDesc)ddlDesc;
            String dbName = showTables.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTables.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        } else if (ddlDesc instanceof DescTableDesc) {
            DescTableDesc descTable = (DescTableDesc)ddlDesc;
            String tableName = this.extractTableName(descTable.getDbTableName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        } else if (ddlDesc instanceof ShowTableStatusDesc) {
            ShowTableStatusDesc showTableStatus = (ShowTableStatusDesc)ddlDesc;
            String dbName = showTableStatus.getDbName() == null ? SessionState.get().getCurrentDatabase() : showTableStatus.getDbName();
            this.authorize(cntxt.getHive().getDatabase(dbName), Privilege.SELECT);
        } else if (ddlDesc instanceof AlterTableDropPartitionDesc) {
            AlterTableDropPartitionDesc dropPartition = (AlterTableDropPartitionDesc)ddlDesc;
            for (AlterTableDropPartitionDesc.PartitionDesc partSpec : dropPartition.getPartSpecs()) {
                Table table = hive.getTable(SessionState.get().getCurrentDatabase(), dropPartition.getTableName());
                List partitions = null;
                try {
                    partitions = hive.getPartitionsByFilter(table, partSpec.getPartSpec().getExprString());
                }
                catch (Exception e) {
                    throw new HiveException((Throwable)e);
                }
                for (Partition part : partitions) {
                    this.authorize(part, Privilege.DROP);
                }
            }
        } else if (ddlDesc instanceof ShowPartitionsDesc) {
            ShowPartitionsDesc showParts = (ShowPartitionsDesc)ddlDesc;
            String tableName = this.extractTableName(showParts.getTabName());
            this.authorizeTable(cntxt.getHive(), tableName, Privilege.SELECT);
        } else if (ddlDesc instanceof AlterTableSetLocationDesc) {
            AlterTableSetLocationDesc alterTable = (AlterTableSetLocationDesc)ddlDesc;
            Table table = hive.getTable(SessionState.get().getCurrentDatabase(), Utilities.getDbTableName((String)alterTable.getDbTableName())[1], false);
            Partition part = null;
            if (alterTable.getPartitionSpec() != null) {
                part = hive.getPartition(table, alterTable.getPartitionSpec(), false);
            }
            String newLocation = alterTable.getLocation();
            if (part != null) {
                this.authorize(part, Privilege.ALTER_DATA);
                part.setLocation(newLocation);
                this.authorize(part, Privilege.ALTER_DATA);
            } else {
                this.authorize(table, Privilege.ALTER_DATA);
                table.getTTable().getSd().setLocation(newLocation);
                this.authorize(table, Privilege.ALTER_DATA);
            }
        }
    }
}

