/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

public class ReadWriteLockMetrics
implements ReadWriteLock {
    private LockWrapper readLock;
    private LockWrapper writeLock;

    public static ReadWriteLock wrap(Configuration conf, ReadWriteLock lock, MetricsSource metrics) {
        Preconditions.checkNotNull((Object)lock, (Object)"Caller has to provide valid input lock");
        boolean needsWrap = false;
        if (null != conf) {
            needsWrap = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_COLLECT_LOCK_METRICS);
        }
        if (!needsWrap) {
            return lock;
        }
        Preconditions.checkNotNull((Object)metrics, (Object)"Caller has to procide group specific metrics source");
        return new ReadWriteLockMetrics(lock, metrics);
    }

    public static MetricsSource createLockMetricsSource(String label) {
        Preconditions.checkNotNull((Object)label);
        Preconditions.checkArgument((!label.contains("\"") ? 1 : 0) != 0, (Object)"Label can't contain quote (\")");
        return new LockMetricSource(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MetricsSource> getAllMetricsSources() {
        ArrayList<MetricsSource> ret = null;
        ArrayList arrayList = LockMetricSource.allInstances;
        synchronized (arrayList) {
            ret = new ArrayList<MetricsSource>(LockMetricSource.allInstances);
        }
        return ret;
    }

    private ReadWriteLockMetrics(ReadWriteLock lock, MetricsSource metrics) {
        Preconditions.checkNotNull((Object)lock);
        Preconditions.checkArgument((boolean)(metrics instanceof LockMetricSource), (Object)"Invalid MetricsSource");
        LockMetricSource lms = (LockMetricSource)metrics;
        this.readLock = new LockWrapper(lock.readLock(), lms.readLockWaitTimeTotal, lms.readLockWaitTimeMax, lms.readLockCounts);
        this.writeLock = new LockWrapper(lock.writeLock(), lms.writeLockWaitTimeTotal, lms.writeLockWaitTimeMax, lms.writeLockCounts);
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        return this.writeLock;
    }

    private static class LockWrapper
    implements Lock {
        private final Lock wrappedLock;
        private final MutableCounterLong lockWaitTotal;
        private final MutableCounterLong lockWaitMax;
        private final MutableCounterLong lockWaitCount;

        LockWrapper(Lock original, MutableCounterLong total, MutableCounterLong max, MutableCounterLong cnt) {
            this.wrappedLock = original;
            this.lockWaitTotal = total;
            this.lockWaitMax = max;
            this.lockWaitCount = cnt;
        }

        @Override
        public void lock() {
            long start = System.nanoTime();
            this.wrappedLock.lock();
            this.incrementBy(System.nanoTime() - start);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            long start = System.nanoTime();
            this.wrappedLock.lockInterruptibly();
            this.incrementBy(System.nanoTime() - start);
        }

        @Override
        public boolean tryLock() {
            return this.wrappedLock.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            long start = System.nanoTime();
            boolean ret = this.wrappedLock.tryLock(time, unit);
            this.incrementBy(System.nanoTime() - start);
            return ret;
        }

        @Override
        public void unlock() {
            this.wrappedLock.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.wrappedLock.newCondition();
        }

        private void incrementBy(long waitTime) {
            this.lockWaitTotal.incr(waitTime);
            this.lockWaitCount.incr();
            if (waitTime > this.lockWaitMax.value()) {
                this.lockWaitMax.incr(waitTime - this.lockWaitMax.value());
            }
        }
    }

    @Metrics(about="Lock Metrics", context="locking")
    private static class LockMetricSource
    implements MetricsSource {
        private static final ArrayList<MetricsSource> allInstances = new ArrayList();
        private final String lockLabel;
        @Metric
        MutableCounterLong readLockWaitTimeTotal;
        @Metric
        MutableCounterLong readLockWaitTimeMax;
        @Metric
        MutableCounterLong readLockCounts;
        @Metric
        MutableCounterLong writeLockWaitTimeTotal;
        @Metric
        MutableCounterLong writeLockWaitTimeMax;
        @Metric
        MutableCounterLong writeLockCounts;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockMetricSource(String label) {
            this.lockLabel = label;
            this.readLockWaitTimeTotal = new MutableCounterLong((MetricsInfo)LockMetricInfo.ReadLockWaitTimeTotal, 0L);
            this.readLockWaitTimeMax = new MutableCounterLong((MetricsInfo)LockMetricInfo.ReadLockWaitTimeMax, 0L);
            this.readLockCounts = new MutableCounterLong((MetricsInfo)LockMetricInfo.ReadLockCount, 0L);
            this.writeLockWaitTimeTotal = new MutableCounterLong((MetricsInfo)LockMetricInfo.WriteLockWaitTimeTotal, 0L);
            this.writeLockWaitTimeMax = new MutableCounterLong((MetricsInfo)LockMetricInfo.WriteLockWaitTimeMax, 0L);
            this.writeLockCounts = new MutableCounterLong((MetricsInfo)LockMetricInfo.WriteLockCount, 0L);
            ArrayList<MetricsSource> arrayList = allInstances;
            synchronized (arrayList) {
                allInstances.add(this);
            }
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            collector.addRecord(this.lockLabel).setContext("Locking").addCounter((MetricsInfo)LockMetricInfo.ReadLockWaitTimeTotal, this.readLockWaitTimeTotal.value()).addCounter((MetricsInfo)LockMetricInfo.ReadLockWaitTimeMax, this.readLockWaitTimeMax.value()).addCounter((MetricsInfo)LockMetricInfo.ReadLockCount, this.readLockCounts.value()).addCounter((MetricsInfo)LockMetricInfo.WriteLockWaitTimeTotal, this.writeLockWaitTimeTotal.value()).addCounter((MetricsInfo)LockMetricInfo.WriteLockWaitTimeMax, this.writeLockWaitTimeMax.value()).addCounter((MetricsInfo)LockMetricInfo.WriteLockCount, this.writeLockCounts.value());
        }

        public String toString() {
            long avgRead = 0L;
            long avgWrite = 0L;
            long totalMillis = 0L;
            if (0L < this.readLockCounts.value()) {
                avgRead = this.readLockWaitTimeTotal.value() / this.readLockCounts.value();
            }
            if (0L < this.writeLockCounts.value()) {
                avgWrite = this.writeLockWaitTimeTotal.value() / this.writeLockCounts.value();
            }
            totalMillis = this.readLockWaitTimeTotal.value() / 1000000L + this.writeLockWaitTimeTotal.value() / 1000000L;
            StringBuffer sb = new StringBuffer();
            sb.append("{ \"type\" : \"R/W Lock Stats\", \"label\" : \"");
            sb.append(this.lockLabel);
            sb.append("\", \"totalLockWaitTimeMillis\" : ");
            sb.append(totalMillis);
            sb.append(", \"readLock\" : { \"count\" : ");
            sb.append(this.readLockCounts.value());
            sb.append(", \"avgWaitTimeNanos\" : ");
            sb.append(avgRead);
            sb.append(", \"maxWaitTimeNanos\" : ");
            sb.append(this.readLockWaitTimeMax.value());
            sb.append(" }, \"writeLock\" : { \"count\" : ");
            sb.append(this.writeLockCounts.value());
            sb.append(", \"avgWaitTimeNanos\" : ");
            sb.append(avgWrite);
            sb.append(", \"maxWaitTimeNanos\" : ");
            sb.append(this.writeLockWaitTimeMax.value());
            sb.append(" } }");
            return sb.toString();
        }
    }

    @VisibleForTesting
    public static enum LockMetricInfo implements MetricsInfo
    {
        ReadLockWaitTimeTotal("The total wait time for read locks in nanoseconds"),
        ReadLockWaitTimeMax("The maximum wait time for a read lock in nanoseconds"),
        ReadLockCount("Total amount of read lock requests"),
        WriteLockWaitTimeTotal("The total wait time for write locks in nanoseconds"),
        WriteLockWaitTimeMax("The maximum wait time for a write lock in nanoseconds"),
        WriteLockCount("Total amount of write lock requests");

        private final String description;

        private LockMetricInfo(String desc) {
            this.description = desc;
        }

        public String description() {
            return this.description;
        }
    }

    public static class MetricsComparator
    implements Comparator<MetricsSource>,
    Serializable {
        private static final long serialVersionUID = -1L;

        @Override
        public int compare(MetricsSource o1, MetricsSource o2) {
            if (o1 != null && o2 != null && o1 instanceof LockMetricSource && o2 instanceof LockMetricSource) {
                long totalMs2;
                LockMetricSource lms1 = (LockMetricSource)o1;
                LockMetricSource lms2 = (LockMetricSource)o2;
                long totalMs1 = lms1.readLockWaitTimeTotal.value() / 1000000L + lms1.writeLockWaitTimeTotal.value() / 1000000L;
                if (totalMs1 < (totalMs2 = lms2.readLockWaitTimeTotal.value() / 1000000L + lms2.writeLockWaitTimeTotal.value() / 1000000L)) {
                    return 1;
                }
                if (totalMs1 > totalMs2) {
                    return -1;
                }
                return lms1.lockLabel.compareTo(lms2.lockLabel);
            }
            return 0;
        }
    }
}

