/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.spark.HiveKryoRegistrator;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;

public class NoHashCodeKryoSerializer
extends KryoSerializer {
    private static final long serialVersionUID = 3350910170041648022L;

    public NoHashCodeKryoSerializer(SparkConf conf) {
        super(conf);
    }

    public Kryo newKryo() {
        Kryo kryo = super.newKryo();
        kryo.register(HiveKey.class, (Serializer)new HiveKeySerializer());
        kryo.register(BytesWritable.class, (Serializer)new HiveKryoRegistrator.BytesWritableSerializer());
        return kryo;
    }

    private static class HiveKeySerializer
    extends Serializer<HiveKey> {
        private HiveKeySerializer() {
        }

        public void write(Kryo kryo, Output output, HiveKey object) {
            output.writeVarInt(object.getLength(), true);
            output.write(object.getBytes(), 0, object.getLength());
        }

        public HiveKey read(Kryo kryo, Input input, Class<HiveKey> type) {
            int len = input.readVarInt(true);
            byte[] bytes = new byte[len];
            input.readBytes(bytes);
            return new HiveKey(bytes);
        }
    }
}

