/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodUtils.class);

    public static <T> Method getMethodInternal(Class<? extends T> udfClass, String methodName, boolean exact, List<TypeInfo> argumentClasses) throws UDFArgumentException {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : udfClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return MethodUtils.getMethodInternal(udfClass, mlist, exact, argumentClasses);
    }

    public static Method getMethodInternal(Class<?> udfClass, List<Method> mlist, boolean exact, List<TypeInfo> argumentsPassed) throws UDFArgumentException {
        ArrayList<Method> udfMethods = new ArrayList<Method>();
        int leastConversionCost = Integer.MAX_VALUE;
        for (Method m : mlist) {
            List argumentsAccepted = TypeInfoUtils.getParameterTypeInfos((Method)m, (int)argumentsPassed.size());
            if (argumentsAccepted == null) continue;
            boolean match = argumentsAccepted.size() == argumentsPassed.size();
            int conversionCost = 0;
            for (int i = 0; i < argumentsPassed.size() && match; ++i) {
                int cost = MethodUtils.matchCost(argumentsPassed.get(i), (TypeInfo)argumentsAccepted.get(i), exact);
                if (cost == -1) {
                    match = false;
                    continue;
                }
                conversionCost += cost;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method " + (match ? "did" : "didn't") + " match: passed = " + argumentsPassed + " accepted = " + argumentsAccepted + " method = " + m);
            }
            if (!match) continue;
            if (conversionCost < leastConversionCost) {
                udfMethods.clear();
                udfMethods.add(m);
                leastConversionCost = conversionCost;
                if (leastConversionCost != 0) continue;
                break;
            }
            if (conversionCost != leastConversionCost) continue;
            udfMethods.add(m);
        }
        if (udfMethods.size() == 0) {
            throw new NoMatchingMethodException(udfClass, argumentsPassed, mlist);
        }
        if (udfMethods.size() > 1) {
            MethodUtils.filterMethodsByTypeAffinity(udfMethods, argumentsPassed);
        }
        if (udfMethods.size() > 1) {
            int lowestNumericType = Integer.MAX_VALUE;
            boolean multiple = true;
            Method candidate = null;
            List referenceArguments = null;
            for (Method m : udfMethods) {
                int maxNumericType = 0;
                List argumentsAccepted = TypeInfoUtils.getParameterTypeInfos((Method)m, (int)argumentsPassed.size());
                if (referenceArguments == null) {
                    referenceArguments = argumentsAccepted;
                }
                Iterator referenceIterator = referenceArguments.iterator();
                for (TypeInfo accepted : argumentsAccepted) {
                    TypeInfo reference = (TypeInfo)referenceIterator.next();
                    boolean acceptedIsPrimitive = false;
                    PrimitiveObjectInspector.PrimitiveCategory acceptedPrimCat = PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN;
                    if (accepted.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                        acceptedIsPrimitive = true;
                        acceptedPrimCat = ((PrimitiveTypeInfo)accepted).getPrimitiveCategory();
                    }
                    if (acceptedIsPrimitive && TypeInfoUtils.numericTypes.containsKey(acceptedPrimCat)) {
                        int typeValue = (Integer)TypeInfoUtils.numericTypes.get(acceptedPrimCat);
                        maxNumericType = typeValue > maxNumericType ? typeValue : maxNumericType;
                        continue;
                    }
                    if (accepted.equals((Object)reference)) continue;
                    throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
                }
                if (lowestNumericType > maxNumericType) {
                    multiple = false;
                    lowestNumericType = maxNumericType;
                    candidate = m;
                    continue;
                }
                if (maxNumericType != lowestNumericType) continue;
                multiple = true;
            }
            if (!multiple) {
                return candidate;
            }
            throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
        }
        return (Method)udfMethods.get(0);
    }

    static void filterMethodsByTypeAffinity(List<Method> udfMethods, List<TypeInfo> argumentsPassed) {
        if (udfMethods.size() > 1) {
            int currentScore = 0;
            int bestMatchScore = 0;
            Method bestMatch = null;
            for (Method m : udfMethods) {
                currentScore = 0;
                List argumentsAccepted = TypeInfoUtils.getParameterTypeInfos((Method)m, (int)argumentsPassed.size());
                Iterator<TypeInfo> argsPassedIter = argumentsPassed.iterator();
                for (TypeInfo acceptedType : argumentsAccepted) {
                    PrimitiveObjectInspectorUtils.PrimitiveGrouping passedPg;
                    PrimitiveObjectInspectorUtils.PrimitiveGrouping acceptedPg;
                    TypeInfo passedType = argsPassedIter.next();
                    if (acceptedType.getCategory() != ObjectInspector.Category.PRIMITIVE || passedType.getCategory() != ObjectInspector.Category.PRIMITIVE || (acceptedPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)acceptedType).getPrimitiveCategory())) != (passedPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)passedType).getPrimitiveCategory()))) continue;
                    ++currentScore;
                }
                if (currentScore > bestMatchScore) {
                    bestMatchScore = currentScore;
                    bestMatch = m;
                    continue;
                }
                if (currentScore != bestMatchScore) continue;
                bestMatch = null;
            }
            if (bestMatch != null) {
                udfMethods.clear();
                udfMethods.add(bestMatch);
            }
        }
    }

    public static int matchCost(TypeInfo argumentPassed, TypeInfo argumentAccepted, boolean exact) {
        if (argumentAccepted.equals((Object)argumentPassed) || TypeInfoUtils.doPrimitiveCategoriesMatch((TypeInfo)argumentPassed, (TypeInfo)argumentAccepted)) {
            return 0;
        }
        if (argumentPassed.equals((Object)TypeInfoFactory.voidTypeInfo)) {
            return 0;
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.LIST) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo argumentPassedElement = ((ListTypeInfo)argumentPassed).getListElementTypeInfo();
            TypeInfo argumentAcceptedElement = ((ListTypeInfo)argumentAccepted).getListElementTypeInfo();
            return MethodUtils.matchCost(argumentPassedElement, argumentAcceptedElement, exact);
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.MAP) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo argumentPassedKey = ((MapTypeInfo)argumentPassed).getMapKeyTypeInfo();
            TypeInfo argumentAcceptedKey = ((MapTypeInfo)argumentAccepted).getMapKeyTypeInfo();
            TypeInfo argumentPassedValue = ((MapTypeInfo)argumentPassed).getMapValueTypeInfo();
            TypeInfo argumentAcceptedValue = ((MapTypeInfo)argumentAccepted).getMapValueTypeInfo();
            int cost1 = MethodUtils.matchCost(argumentPassedKey, argumentAcceptedKey, exact);
            int cost2 = MethodUtils.matchCost(argumentPassedValue, argumentAcceptedValue, exact);
            if (cost1 < 0 || cost2 < 0) {
                return -1;
            }
            return Math.max(cost1, cost2);
        }
        if (argumentAccepted.equals((Object)TypeInfoFactory.unknownTypeInfo)) {
            return 1;
        }
        if (!exact && TypeInfoUtils.implicitConvertible((TypeInfo)argumentPassed, (TypeInfo)argumentAccepted)) {
            return 1;
        }
        return -1;
    }
}

