/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.security.kerberos;

import java.lang.reflect.Method;
import org.apache.kafkaesque.common.KafkaException;
import org.apache.kafkaesque.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafkaesque.common.utils.Java;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KerberosError {
    SERVER_NOT_FOUND(7, false),
    CLIENT_NOT_YET_VALID(21, true),
    TICKET_NOT_YET_VALID(33, true),
    REPLAY(34, true);

    private static final Logger log;
    private static final Class<?> KRB_EXCEPTION_CLASS;
    private static final Method KRB_EXCEPTION_RETURN_CODE_METHOD;
    private final int errorCode;
    private final boolean retriable;

    private KerberosError(int errorCode, boolean retriable) {
        this.errorCode = errorCode;
        this.retriable = retriable;
    }

    public boolean retriable() {
        return this.retriable;
    }

    public static KerberosError fromException(Exception exception) {
        Throwable cause;
        for (cause = exception.getCause(); cause != null && !KRB_EXCEPTION_CLASS.isInstance(cause); cause = cause.getCause()) {
        }
        if (cause == null) {
            return null;
        }
        try {
            Integer errorCode = (Integer)KRB_EXCEPTION_RETURN_CODE_METHOD.invoke((Object)cause, new Object[0]);
            return KerberosError.fromErrorCode(errorCode);
        }
        catch (Exception e) {
            log.trace("Kerberos return code could not be determined from {} due to {}", (Object)exception, (Object)e);
            return null;
        }
    }

    private static KerberosError fromErrorCode(int errorCode) {
        for (KerberosError error : KerberosError.values()) {
            if (error.errorCode != errorCode) continue;
            return error;
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(SaslClientAuthenticator.class);
        try {
            KRB_EXCEPTION_CLASS = Java.isIbmJdk() ? Class.forName("com.ibm.security.krb5.internal.KrbException") : Class.forName("sun.security.krb5.KrbException");
            KRB_EXCEPTION_RETURN_CODE_METHOD = KRB_EXCEPTION_CLASS.getMethod("returnCode", new Class[0]);
        }
        catch (Exception e) {
            throw new KafkaException("Kerberos exceptions could not be initialized", e);
        }
    }
}

