/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafkaesque.common.message.SaslAuthenticateRequestData;
import org.apache.kafkaesque.common.message.SaslAuthenticateResponseData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.ApiError;
import org.apache.kafkaesque.common.requests.SaslAuthenticateResponse;

public class SaslAuthenticateRequest
extends AbstractRequest {
    private final SaslAuthenticateRequestData data;
    private final short version;

    public SaslAuthenticateRequest(SaslAuthenticateRequestData data) {
        this(data, ApiKeys.SASL_AUTHENTICATE.latestVersion());
    }

    public SaslAuthenticateRequest(SaslAuthenticateRequestData data, short version) {
        super(ApiKeys.SASL_AUTHENTICATE, version);
        this.data = data;
        this.version = version;
    }

    public SaslAuthenticateRequest(Struct struct, short version) {
        super(ApiKeys.SASL_AUTHENTICATE, version);
        this.data = new SaslAuthenticateRequestData(struct, version);
        this.version = version;
    }

    public SaslAuthenticateRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        SaslAuthenticateResponseData response = new SaslAuthenticateResponseData().setErrorCode(ApiError.fromThrowable(e).error().code()).setErrorMessage(e.getMessage());
        return new SaslAuthenticateResponse(response);
    }

    public static SaslAuthenticateRequest parse(ByteBuffer buffer, short version) {
        return new SaslAuthenticateRequest(ApiKeys.SASL_AUTHENTICATE.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslAuthenticateRequest> {
        private final SaslAuthenticateRequestData data;

        public Builder(SaslAuthenticateRequestData data) {
            super(ApiKeys.SASL_AUTHENTICATE);
            this.data = data;
        }

        @Override
        public SaslAuthenticateRequest build(short version) {
            return new SaslAuthenticateRequest(this.data, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=SaslAuthenticateRequest)");
            return bld.toString();
        }
    }
}

