/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.CommonFields;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.OffsetFetchResponse;
import org.apache.kafkaesque.common.utils.CollectionUtils;
import org.apache.kafkaesque.common.utils.Utils;

public class OffsetFetchRequest
extends AbstractRequest {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "Topics to fetch offsets. If the topic array is null fetch offsets for all topics.");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "Partitions to fetch offsets.");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID);
    private static final Field TOPICS_V0 = TOPICS.withFields("Topics to fetch offsets.", CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema OFFSET_FETCH_REQUEST_V0;
    private static final Schema OFFSET_FETCH_REQUEST_V1;
    private static final Field TOPICS_V2;
    private static final Schema OFFSET_FETCH_REQUEST_V2;
    private static final Schema OFFSET_FETCH_REQUEST_V3;
    private static final Schema OFFSET_FETCH_REQUEST_V4;
    private static final Schema OFFSET_FETCH_REQUEST_V5;
    private final String groupId;
    private final List<TopicPartition> partitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_FETCH_REQUEST_V0, OFFSET_FETCH_REQUEST_V1, OFFSET_FETCH_REQUEST_V2, OFFSET_FETCH_REQUEST_V3, OFFSET_FETCH_REQUEST_V4, OFFSET_FETCH_REQUEST_V5};
    }

    public static OffsetFetchRequest forAllPartitions(String groupId) {
        return new Builder(groupId, null).build((short)2);
    }

    private OffsetFetchRequest(String groupId, List<TopicPartition> partitions, short version) {
        super(ApiKeys.OFFSET_FETCH, version);
        this.groupId = groupId;
        this.partitions = partitions;
    }

    public OffsetFetchRequest(Struct struct, short version) {
        super(ApiKeys.OFFSET_FETCH, version);
        Object[] topicArray = struct.get(TOPICS);
        if (topicArray != null) {
            this.partitions = new ArrayList<TopicPartition>();
            for (Object topicResponseObj : topicArray) {
                Struct topicResponse = (Struct)topicResponseObj;
                String topic = topicResponse.get(CommonFields.TOPIC_NAME);
                for (Object partitionResponseObj : topicResponse.get(PARTITIONS)) {
                    Struct partitionResponse = (Struct)partitionResponseObj;
                    int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                    this.partitions.add(new TopicPartition(topic, partition));
                }
            }
        } else {
            this.partitions = null;
        }
        this.groupId = struct.get(CommonFields.GROUP_ID);
    }

    public OffsetFetchResponse getErrorResponse(Errors error) {
        return this.getErrorResponse(0, error);
    }

    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Errors error) {
        short versionId = this.version();
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responsePartitions = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        if (versionId < 2) {
            OffsetFetchResponse.PartitionData partitionError = new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", error);
            for (TopicPartition partition : this.partitions) {
                responsePartitions.put(partition, partitionError);
            }
        }
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new OffsetFetchResponse(error, responsePartitions);
            }
            case 3: 
            case 4: 
            case 5: {
                return new OffsetFetchResponse(throttleTimeMs, error, responsePartitions);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.OFFSET_FETCH.latestVersion()));
    }

    @Override
    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(throttleTimeMs, Errors.forException(e));
    }

    public String groupId() {
        return this.groupId;
    }

    public List<TopicPartition> partitions() {
        return this.partitions;
    }

    public static OffsetFetchRequest parse(ByteBuffer buffer, short version) {
        return new OffsetFetchRequest(ApiKeys.OFFSET_FETCH.parseRequest(version, buffer), version);
    }

    public boolean isAllPartitions() {
        return this.partitions == null;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.OFFSET_FETCH.requestSchema(this.version()));
        struct.set(CommonFields.GROUP_ID, this.groupId);
        if (this.partitions != null) {
            Map<String, List<Integer>> topicsData = CollectionUtils.groupPartitionsByTopic(this.partitions);
            ArrayList<Struct> topicArray = new ArrayList<Struct>();
            for (Map.Entry<String, List<Integer>> entries : topicsData.entrySet()) {
                Struct topicData = struct.instance(TOPICS);
                topicData.set(CommonFields.TOPIC_NAME, entries.getKey());
                ArrayList<Struct> partitionArray = new ArrayList<Struct>();
                for (Integer partitionId : entries.getValue()) {
                    Struct partitionData = topicData.instance(PARTITIONS);
                    partitionData.set(CommonFields.PARTITION_ID, partitionId);
                    partitionArray.add(partitionData);
                }
                topicData.set(PARTITIONS, partitionArray.toArray());
                topicArray.add(topicData);
            }
            struct.set(TOPICS, topicArray.toArray());
        } else {
            struct.set(TOPICS, null);
        }
        return struct;
    }

    static {
        OFFSET_FETCH_REQUEST_V1 = OFFSET_FETCH_REQUEST_V0 = new Schema(CommonFields.GROUP_ID, TOPICS_V0);
        TOPICS_V2 = TOPICS.nullableWithFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
        OFFSET_FETCH_REQUEST_V5 = OFFSET_FETCH_REQUEST_V4 = (OFFSET_FETCH_REQUEST_V3 = (OFFSET_FETCH_REQUEST_V2 = new Schema(CommonFields.GROUP_ID, TOPICS_V2)));
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetFetchRequest> {
        private static final List<TopicPartition> ALL_TOPIC_PARTITIONS = null;
        private final String groupId;
        private final List<TopicPartition> partitions;

        public Builder(String groupId, List<TopicPartition> partitions) {
            super(ApiKeys.OFFSET_FETCH);
            this.groupId = groupId;
            this.partitions = partitions;
        }

        public static Builder allTopicPartitions(String groupId) {
            return new Builder(groupId, ALL_TOPIC_PARTITIONS);
        }

        public boolean isAllTopicPartitions() {
            return this.partitions == ALL_TOPIC_PARTITIONS;
        }

        @Override
        public OffsetFetchRequest build(short version) {
            if (this.isAllTopicPartitions() && version < 2) {
                throw new UnsupportedVersionException("The broker only supports OffsetFetchRequest v" + version + ", but we need v2 or newer to request all topic partitions.");
            }
            return new OffsetFetchRequest(this.groupId, this.partitions, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            String partitionsString = this.partitions == null ? "<ALL>" : Utils.join(this.partitions, ",");
            bld.append("(type=OffsetFetchRequest, ").append("groupId=").append(this.groupId).append(", partitions=").append(partitionsString).append(")");
            return bld.toString();
        }
    }
}

