/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.CommonFields;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.IsolationLevel;
import org.apache.kafkaesque.common.requests.ListOffsetResponse;
import org.apache.kafkaesque.common.requests.RequestUtils;
import org.apache.kafkaesque.common.utils.CollectionUtils;

public class ListOffsetRequest
extends AbstractRequest {
    public static final long EARLIEST_TIMESTAMP = -2L;
    public static final long LATEST_TIMESTAMP = -1L;
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEBUGGING_REPLICA_ID = -2;
    private static final Field.Int32 REPLICA_ID = new Field.Int32("replica_id", "Broker id of the follower. For normal consumers, use -1.");
    private static final Field.Int8 ISOLATION_LEVEL = new Field.Int8("isolation_level", "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records");
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "Topics to list offsets.");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "Partitions to list offsets.");
    private static final Field.Int64 TIMESTAMP = new Field.Int64("timestamp", "The target timestamp for the partition.");
    private static final Field.Int32 MAX_NUM_OFFSETS = new Field.Int32("max_num_offsets", "Maximum offsets to return.");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, TIMESTAMP, MAX_NUM_OFFSETS);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema LIST_OFFSET_REQUEST_V0 = new Schema(REPLICA_ID, TOPICS_V0);
    private static final Field PARTITIONS_V1 = PARTITIONS.withFields(CommonFields.PARTITION_ID, TIMESTAMP);
    private static final Field TOPICS_V1 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V1);
    private static final Schema LIST_OFFSET_REQUEST_V1 = new Schema(REPLICA_ID, TOPICS_V1);
    private static final Schema LIST_OFFSET_REQUEST_V2;
    private static final Schema LIST_OFFSET_REQUEST_V3;
    private static final Field PARTITIONS_V4;
    private static final Field TOPICS_V4;
    private static final Schema LIST_OFFSET_REQUEST_V4;
    private static final Schema LIST_OFFSET_REQUEST_V5;
    private final int replicaId;
    private final IsolationLevel isolationLevel;
    private final Map<TopicPartition, PartitionData> partitionTimestamps;
    private final Set<TopicPartition> duplicatePartitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{LIST_OFFSET_REQUEST_V0, LIST_OFFSET_REQUEST_V1, LIST_OFFSET_REQUEST_V2, LIST_OFFSET_REQUEST_V3, LIST_OFFSET_REQUEST_V4, LIST_OFFSET_REQUEST_V5};
    }

    private ListOffsetRequest(int replicaId, Map<TopicPartition, PartitionData> targetTimes, IsolationLevel isolationLevel, short version) {
        super(ApiKeys.LIST_OFFSETS, version);
        this.replicaId = replicaId;
        this.isolationLevel = isolationLevel;
        this.partitionTimestamps = targetTimes;
        this.duplicatePartitions = Collections.emptySet();
    }

    public ListOffsetRequest(Struct struct, short version) {
        super(ApiKeys.LIST_OFFSETS, version);
        HashSet<TopicPartition> duplicatePartitions = new HashSet<TopicPartition>();
        this.replicaId = struct.get(REPLICA_ID);
        this.isolationLevel = struct.hasField(ISOLATION_LEVEL) ? IsolationLevel.forId(struct.get(ISOLATION_LEVEL)) : IsolationLevel.READ_UNCOMMITTED;
        this.partitionTimestamps = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.get(TOPICS)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.get(PARTITIONS)) {
                Optional<Integer> currentLeaderEpoch;
                int maxNumOffsets;
                long timestamp;
                PartitionData partitionData;
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                TopicPartition tp = new TopicPartition(topic, partition);
                if (this.partitionTimestamps.put(tp, partitionData = new PartitionData(timestamp = partitionResponse.get(TIMESTAMP).longValue(), maxNumOffsets = partitionResponse.getOrElse(MAX_NUM_OFFSETS, 1).intValue(), currentLeaderEpoch = RequestUtils.getLeaderEpoch(partitionResponse, CommonFields.CURRENT_LEADER_EPOCH))) == null) continue;
                duplicatePartitions.add(tp);
            }
        }
        this.duplicatePartitions = duplicatePartitions;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        short versionId = this.version();
        ListOffsetResponse.PartitionData partitionError = versionId == 0 ? new ListOffsetResponse.PartitionData(Errors.forException(e), Collections.emptyList()) : new ListOffsetResponse.PartitionData(Errors.forException(e), -1L, -1L, Optional.empty());
        for (TopicPartition partition : this.partitionTimestamps.keySet()) {
            responseData.put(partition, partitionError);
        }
        switch (this.version()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new ListOffsetResponse(throttleTimeMs, responseData);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LIST_OFFSETS.latestVersion()));
    }

    public int replicaId() {
        return this.replicaId;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel;
    }

    public Map<TopicPartition, PartitionData> partitionTimestamps() {
        return this.partitionTimestamps;
    }

    public Set<TopicPartition> duplicatePartitions() {
        return this.duplicatePartitions;
    }

    public static ListOffsetRequest parse(ByteBuffer buffer, short version) {
        return new ListOffsetRequest(ApiKeys.LIST_OFFSETS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.LIST_OFFSETS.requestSchema(version));
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupPartitionDataByTopic(this.partitionTimestamps);
        struct.set(REPLICA_ID, this.replicaId);
        struct.setIfExists(ISOLATION_LEVEL, (Object)this.isolationLevel.id());
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = struct.instance(TOPICS);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData offsetPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(TIMESTAMP, offsetPartitionData.timestamp);
                partitionData.setIfExists(MAX_NUM_OFFSETS, (Object)offsetPartitionData.maxNumOffsets);
                RequestUtils.setLeaderEpochIfExists(partitionData, CommonFields.CURRENT_LEADER_EPOCH, offsetPartitionData.currentLeaderEpoch);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS, partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS, topicArray.toArray());
        return struct;
    }

    static {
        LIST_OFFSET_REQUEST_V3 = LIST_OFFSET_REQUEST_V2 = new Schema(REPLICA_ID, ISOLATION_LEVEL, TOPICS_V1);
        PARTITIONS_V4 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.CURRENT_LEADER_EPOCH, TIMESTAMP);
        TOPICS_V4 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V4);
        LIST_OFFSET_REQUEST_V5 = LIST_OFFSET_REQUEST_V4 = new Schema(REPLICA_ID, ISOLATION_LEVEL, TOPICS_V4);
    }

    public static final class PartitionData {
        public final long timestamp;
        @Deprecated
        public final int maxNumOffsets;
        public final Optional<Integer> currentLeaderEpoch;

        private PartitionData(long timestamp, int maxNumOffsets, Optional<Integer> currentLeaderEpoch) {
            this.timestamp = timestamp;
            this.maxNumOffsets = maxNumOffsets;
            this.currentLeaderEpoch = currentLeaderEpoch;
        }

        @Deprecated
        public PartitionData(long timestamp, int maxNumOffsets) {
            this(timestamp, maxNumOffsets, Optional.empty());
        }

        public PartitionData(long timestamp, Optional<Integer> currentLeaderEpoch) {
            this(timestamp, 1, currentLeaderEpoch);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("{timestamp: ").append(this.timestamp).append(", maxNumOffsets: ").append(this.maxNumOffsets).append(", currentLeaderEpoch: ").append(this.currentLeaderEpoch).append("}");
            return bld.toString();
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<ListOffsetRequest> {
        private final int replicaId;
        private final IsolationLevel isolationLevel;
        private Map<TopicPartition, PartitionData> partitionTimestamps = new HashMap<TopicPartition, PartitionData>();

        public static Builder forReplica(short allowedVersion, int replicaId) {
            return new Builder(0, allowedVersion, replicaId, IsolationLevel.READ_UNCOMMITTED);
        }

        public static Builder forConsumer(boolean requireTimestamp, IsolationLevel isolationLevel) {
            short minVersion = 0;
            if (isolationLevel == IsolationLevel.READ_COMMITTED) {
                minVersion = 2;
            } else if (requireTimestamp) {
                minVersion = 1;
            }
            return new Builder(minVersion, ApiKeys.LIST_OFFSETS.latestVersion(), -1, isolationLevel);
        }

        private Builder(short oldestAllowedVersion, short latestAllowedVersion, int replicaId, IsolationLevel isolationLevel) {
            super(ApiKeys.LIST_OFFSETS, oldestAllowedVersion, latestAllowedVersion);
            this.replicaId = replicaId;
            this.isolationLevel = isolationLevel;
        }

        public Builder setTargetTimes(Map<TopicPartition, PartitionData> partitionTimestamps) {
            this.partitionTimestamps = partitionTimestamps;
            return this;
        }

        @Override
        public ListOffsetRequest build(short version) {
            return new ListOffsetRequest(this.replicaId, this.partitionTimestamps, this.isolationLevel, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ListOffsetRequest").append(", replicaId=").append(this.replicaId);
            if (this.partitionTimestamps != null) {
                bld.append(", partitionTimestamps=").append(this.partitionTimestamps);
            }
            bld.append(", isolationLevel=").append((Object)this.isolationLevel);
            bld.append(")");
            return bld.toString();
        }
    }
}

