/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafkaesque.common.errors.InvalidConfigurationException;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.message.JoinGroupRequestData;
import org.apache.kafkaesque.common.message.JoinGroupResponseData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.JoinGroupResponse;

public class JoinGroupRequest
extends AbstractRequest {
    private final JoinGroupRequestData data;
    private final short version;
    public static final String UNKNOWN_MEMBER_ID = "";
    private static final int MAX_GROUP_INSTANCE_ID_LENGTH = 249;

    public static void validateGroupInstanceId(String id) {
        if (id.equals(UNKNOWN_MEMBER_ID)) {
            throw new InvalidConfigurationException("Group instance id must be non-empty string");
        }
        if (id.equals(".") || id.equals("..")) {
            throw new InvalidConfigurationException("Group instance id cannot be \".\" or \"..\"");
        }
        if (id.length() > 249) {
            throw new InvalidConfigurationException("Group instance id can't be longer than 249 characters: " + id);
        }
        if (!JoinGroupRequest.containsValidPattern(id)) {
            throw new InvalidConfigurationException("Group instance id \"" + id + "\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
        }
    }

    static boolean containsValidPattern(String topic) {
        for (int i = 0; i < topic.length(); ++i) {
            boolean validChar;
            char c = topic.charAt(i);
            boolean bl = validChar = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '.' || c == '_' || c == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }

    public JoinGroupRequest(JoinGroupRequestData data, short version) {
        super(ApiKeys.JOIN_GROUP, version);
        this.data = data;
        this.version = version;
    }

    public JoinGroupRequest(Struct struct, short version) {
        super(ApiKeys.JOIN_GROUP, version);
        this.data = new JoinGroupRequestData(struct, version);
        this.version = version;
    }

    public JoinGroupRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(Errors.forException(e).code()).setGenerationId(-1).setProtocolName(UNKNOWN_MEMBER_ID).setLeader(UNKNOWN_MEMBER_ID).setMemberId(UNKNOWN_MEMBER_ID).setMembers(Collections.emptyList()));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new JoinGroupResponse(new JoinGroupResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setGenerationId(-1).setProtocolName(UNKNOWN_MEMBER_ID).setLeader(UNKNOWN_MEMBER_ID).setMemberId(UNKNOWN_MEMBER_ID).setMembers(Collections.emptyList()));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.JOIN_GROUP.latestVersion()));
    }

    public static JoinGroupRequest parse(ByteBuffer buffer, short version) {
        return new JoinGroupRequest(ApiKeys.JOIN_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public static class Builder
    extends AbstractRequest.Builder<JoinGroupRequest> {
        private final JoinGroupRequestData data;

        public Builder(JoinGroupRequestData data) {
            super(ApiKeys.JOIN_GROUP);
            this.data = data;
        }

        @Override
        public JoinGroupRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 5) {
                throw new UnsupportedVersionException("The broker join group protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new JoinGroupRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

