/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.network.ByteBufferSend;
import org.apache.kafkaesque.common.network.Send;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.CommonFields;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.record.BaseRecords;
import org.apache.kafkaesque.common.record.MemoryRecords;
import org.apache.kafkaesque.common.record.MultiRecordsSend;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.FetchRequest;
import org.apache.kafkaesque.common.requests.ResponseHeader;

public class FetchResponse<T extends BaseRecords>
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final Field.Int64 HIGH_WATERMARK = new Field.Int64("high_watermark", "Last committed offset.");
    private static final Field.Int64 LOG_START_OFFSET = new Field.Int64("log_start_offset", "Earliest available offset.");
    private static final Field.Int32 PREFERRED_READ_REPLICA = new Field.Int32("preferred_read_replica", "The ID of the replica that the consumer should prefer.");
    private static final String PARTITION_HEADER_KEY_NAME = "partition_header";
    private static final String ABORTED_TRANSACTIONS_KEY_NAME = "aborted_transactions";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V0 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, HIGH_WATERMARK);
    private static final Schema FETCH_RESPONSE_PARTITION_V0 = new Schema(new Field("partition_header", FETCH_RESPONSE_PARTITION_HEADER_V0), new Field("record_set", Type.RECORDS));
    private static final Schema FETCH_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(FETCH_RESPONSE_PARTITION_V0)));
    private static final Schema FETCH_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(FETCH_RESPONSE_TOPIC_V0)));
    private static final Schema FETCH_RESPONSE_V1;
    private static final Schema FETCH_RESPONSE_V2;
    private static final Schema FETCH_RESPONSE_V3;
    private static final Field.Int64 LAST_STABLE_OFFSET;
    private static final Field.Int64 PRODUCER_ID;
    private static final Field.Int64 FIRST_OFFSET;
    private static final Schema FETCH_RESPONSE_ABORTED_TRANSACTION_V4;
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V4;
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V5;
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V6;
    private static final Schema FETCH_RESPONSE_PARTITION_V4;
    private static final Schema FETCH_RESPONSE_PARTITION_V5;
    private static final Schema FETCH_RESPONSE_PARTITION_V6;
    private static final Schema FETCH_RESPONSE_TOPIC_V4;
    private static final Schema FETCH_RESPONSE_TOPIC_V5;
    private static final Schema FETCH_RESPONSE_TOPIC_V6;
    private static final Schema FETCH_RESPONSE_V4;
    private static final Schema FETCH_RESPONSE_V5;
    private static final Schema FETCH_RESPONSE_V6;
    private static final Field.Int32 SESSION_ID;
    private static final Schema FETCH_RESPONSE_V7;
    private static final Schema FETCH_RESPONSE_V8;
    private static final Schema FETCH_RESPONSE_V9;
    private static final Schema FETCH_RESPONSE_V10;
    private static final Schema FETCH_RESPONSE_V11;
    public static final long INVALID_HIGHWATERMARK = -1L;
    public static final long INVALID_LAST_STABLE_OFFSET = -1L;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    public static final int INVALID_PREFERRED_REPLICA_ID = -1;
    private final int throttleTimeMs;
    private final Errors error;
    private final int sessionId;
    private final LinkedHashMap<TopicPartition, PartitionData<T>> responseData;

    public static Schema[] schemaVersions() {
        return new Schema[]{FETCH_RESPONSE_V0, FETCH_RESPONSE_V1, FETCH_RESPONSE_V2, FETCH_RESPONSE_V3, FETCH_RESPONSE_V4, FETCH_RESPONSE_V5, FETCH_RESPONSE_V6, FETCH_RESPONSE_V7, FETCH_RESPONSE_V8, FETCH_RESPONSE_V9, FETCH_RESPONSE_V10, FETCH_RESPONSE_V11};
    }

    public FetchResponse(Errors error, LinkedHashMap<TopicPartition, PartitionData<T>> responseData, int throttleTimeMs, int sessionId) {
        this.error = error;
        this.responseData = responseData;
        this.throttleTimeMs = throttleTimeMs;
        this.sessionId = sessionId;
    }

    public static FetchResponse<MemoryRecords> parse(Struct struct) {
        LinkedHashMap responseData = new LinkedHashMap();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Object[] abortedTransactionsArray;
                Struct partitionResponse = (Struct)partitionResponseObj;
                Struct partitionResponseHeader = partitionResponse.getStruct(PARTITION_HEADER_KEY_NAME);
                int partition = partitionResponseHeader.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionResponseHeader.get(CommonFields.ERROR_CODE));
                long highWatermark = partitionResponseHeader.get(HIGH_WATERMARK);
                long lastStableOffset = partitionResponseHeader.getOrElse(LAST_STABLE_OFFSET, -1L);
                long logStartOffset = partitionResponseHeader.getOrElse(LOG_START_OFFSET, -1L);
                Optional<Integer> preferredReadReplica = Optional.of(partitionResponseHeader.getOrElse(PREFERRED_READ_REPLICA, -1)).filter(Predicate.isEqual(-1).negate());
                BaseRecords baseRecords = partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                if (!(baseRecords instanceof MemoryRecords)) {
                    throw new IllegalStateException("Unknown records type found: " + baseRecords.getClass());
                }
                MemoryRecords records = (MemoryRecords)baseRecords;
                ArrayList<AbortedTransaction> abortedTransactions = null;
                if (partitionResponseHeader.hasField(ABORTED_TRANSACTIONS_KEY_NAME) && (abortedTransactionsArray = partitionResponseHeader.getArray(ABORTED_TRANSACTIONS_KEY_NAME)) != null) {
                    abortedTransactions = new ArrayList<AbortedTransaction>(abortedTransactionsArray.length);
                    for (Object abortedTransactionObj : abortedTransactionsArray) {
                        Struct abortedTransactionStruct = (Struct)abortedTransactionObj;
                        long producerId = abortedTransactionStruct.get(PRODUCER_ID);
                        long firstOffset = abortedTransactionStruct.get(FIRST_OFFSET);
                        abortedTransactions.add(new AbortedTransaction(producerId, firstOffset));
                    }
                }
                PartitionData<MemoryRecords> partitionData = new PartitionData<MemoryRecords>(error, highWatermark, lastStableOffset, logStartOffset, preferredReadReplica, abortedTransactions, records);
                responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
        return new FetchResponse<MemoryRecords>(Errors.forCode(struct.getOrElse(CommonFields.ERROR_CODE, (short)0)), responseData, struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0), struct.getOrElse(SESSION_ID, 0));
    }

    @Override
    public Struct toStruct(short version) {
        return FetchResponse.toStruct(version, this.throttleTimeMs, this.error, this.responseData.entrySet().iterator(), this.sessionId);
    }

    @Override
    protected Send toSend(String dest, ResponseHeader responseHeader, short apiVersion) {
        Struct responseHeaderStruct = responseHeader.toStruct();
        Struct responseBodyStruct = this.toStruct(apiVersion);
        ByteBuffer buffer = ByteBuffer.allocate(responseHeaderStruct.sizeOf() + 4);
        buffer.putInt(responseHeaderStruct.sizeOf() + responseBodyStruct.sizeOf());
        responseHeaderStruct.writeTo(buffer);
        buffer.rewind();
        ArrayDeque<Send> sends = new ArrayDeque<Send>();
        sends.add(new ByteBufferSend(dest, buffer));
        FetchResponse.addResponseData(responseBodyStruct, this.throttleTimeMs, dest, sends);
        return new MultiRecordsSend(dest, sends);
    }

    public Errors error() {
        return this.error;
    }

    public LinkedHashMap<TopicPartition, PartitionData<T>> responseData() {
        return this.responseData;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public int sessionId() {
        return this.sessionId;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionData<T> response : this.responseData.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static FetchResponse<MemoryRecords> parse(ByteBuffer buffer, short version) {
        return FetchResponse.parse(ApiKeys.FETCH.responseSchema(version).read(buffer));
    }

    private static void addResponseData(Struct struct, int throttleTimeMs, String dest, Queue<Send> sends) {
        ByteBuffer buffer;
        Object[] allTopicData = struct.getArray(RESPONSES_KEY_NAME);
        if (struct.hasField(CommonFields.ERROR_CODE)) {
            buffer = ByteBuffer.allocate(14);
            buffer.putInt(throttleTimeMs);
            buffer.putShort(struct.get(CommonFields.ERROR_CODE));
            buffer.putInt(struct.get(SESSION_ID));
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        } else if (struct.hasField(CommonFields.THROTTLE_TIME_MS)) {
            buffer = ByteBuffer.allocate(8);
            buffer.putInt(throttleTimeMs);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        } else {
            buffer = ByteBuffer.allocate(4);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        }
        for (Object topicData : allTopicData) {
            FetchResponse.addTopicData(dest, sends, (Struct)topicData);
        }
    }

    private static void addTopicData(String dest, Queue<Send> sends, Struct topicData) {
        String topic = topicData.get(CommonFields.TOPIC_NAME);
        Object[] allPartitionData = topicData.getArray(PARTITIONS_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(Type.STRING.sizeOf(topic) + 4);
        Type.STRING.write(buffer, topic);
        buffer.putInt(allPartitionData.length);
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        for (Object partitionData : allPartitionData) {
            FetchResponse.addPartitionData(dest, sends, (Struct)partitionData);
        }
    }

    private static void addPartitionData(String dest, Queue<Send> sends, Struct partitionData) {
        Struct header = partitionData.getStruct(PARTITION_HEADER_KEY_NAME);
        BaseRecords records = partitionData.getRecords(RECORD_SET_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf() + 4);
        header.writeTo(buffer);
        buffer.putInt(records.sizeInBytes());
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        sends.add(records.toSend(dest));
    }

    private static <T extends BaseRecords> Struct toStruct(short version, int throttleTimeMs, Errors error, Iterator<Map.Entry<TopicPartition, PartitionData<T>>> partIterator, int sessionId) {
        Struct struct = new Struct(ApiKeys.FETCH.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)throttleTimeMs);
        struct.setIfExists(CommonFields.ERROR_CODE, (Object)error.code());
        struct.setIfExists(SESSION_ID, (Object)sessionId);
        List topicsData = FetchRequest.TopicAndPartitionData.batchByTopic(partIterator);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (FetchRequest.TopicAndPartitionData topicEntry : topicsData) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                short errorCode = fetchPartitionData.error.code();
                if (errorCode == Errors.KAFKA_STORAGE_ERROR.code() && version <= 5) {
                    errorCode = Errors.NOT_LEADER_FOR_PARTITION.code();
                }
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                Struct partitionDataHeader = partitionData.instance(PARTITION_HEADER_KEY_NAME);
                partitionDataHeader.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionDataHeader.set(CommonFields.ERROR_CODE, errorCode);
                partitionDataHeader.set(HIGH_WATERMARK, fetchPartitionData.highWatermark);
                if (partitionDataHeader.hasField(LAST_STABLE_OFFSET)) {
                    partitionDataHeader.set(LAST_STABLE_OFFSET, fetchPartitionData.lastStableOffset);
                    if (fetchPartitionData.abortedTransactions == null) {
                        partitionDataHeader.set(ABORTED_TRANSACTIONS_KEY_NAME, null);
                    } else {
                        ArrayList<Struct> abortedTransactionStructs = new ArrayList<Struct>(fetchPartitionData.abortedTransactions.size());
                        for (AbortedTransaction abortedTransaction : fetchPartitionData.abortedTransactions) {
                            Struct abortedTransactionStruct = partitionDataHeader.instance(ABORTED_TRANSACTIONS_KEY_NAME);
                            abortedTransactionStruct.set(PRODUCER_ID, abortedTransaction.producerId);
                            abortedTransactionStruct.set(FIRST_OFFSET, abortedTransaction.firstOffset);
                            abortedTransactionStructs.add(abortedTransactionStruct);
                        }
                        partitionDataHeader.set(ABORTED_TRANSACTIONS_KEY_NAME, (Object)abortedTransactionStructs.toArray());
                    }
                }
                partitionDataHeader.setIfExists(LOG_START_OFFSET, (Object)fetchPartitionData.logStartOffset);
                partitionDataHeader.setIfExists(PREFERRED_READ_REPLICA, (Object)fetchPartitionData.preferredReadReplica.orElse(-1));
                partitionData.set(PARTITION_HEADER_KEY_NAME, (Object)partitionDataHeader);
                partitionData.set(RECORD_SET_KEY_NAME, fetchPartitionData.records);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        return struct;
    }

    public static <T extends BaseRecords> int sizeOf(short version, Iterator<Map.Entry<TopicPartition, PartitionData<T>>> partIterator) {
        return 4 + FetchResponse.toStruct(version, 0, Errors.NONE, partIterator, 0).sizeOf();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 8;
    }

    static {
        FETCH_RESPONSE_V3 = FETCH_RESPONSE_V2 = (FETCH_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V0))));
        LAST_STABLE_OFFSET = new Field.Int64("last_stable_offset", "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)");
        PRODUCER_ID = new Field.Int64("producer_id", "The producer id associated with the aborted transactions");
        FIRST_OFFSET = new Field.Int64("first_offset", "The first offset in the aborted transaction");
        FETCH_RESPONSE_ABORTED_TRANSACTION_V4 = new Schema(PRODUCER_ID, FIRST_OFFSET);
        FETCH_RESPONSE_PARTITION_HEADER_V4 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, HIGH_WATERMARK, LAST_STABLE_OFFSET, new Field(ABORTED_TRANSACTIONS_KEY_NAME, ArrayOf.nullable(FETCH_RESPONSE_ABORTED_TRANSACTION_V4)));
        FETCH_RESPONSE_PARTITION_HEADER_V5 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, HIGH_WATERMARK, LAST_STABLE_OFFSET, LOG_START_OFFSET, new Field(ABORTED_TRANSACTIONS_KEY_NAME, ArrayOf.nullable(FETCH_RESPONSE_ABORTED_TRANSACTION_V4)));
        FETCH_RESPONSE_PARTITION_HEADER_V6 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, HIGH_WATERMARK, LAST_STABLE_OFFSET, LOG_START_OFFSET, new Field(ABORTED_TRANSACTIONS_KEY_NAME, ArrayOf.nullable(FETCH_RESPONSE_ABORTED_TRANSACTION_V4)), PREFERRED_READ_REPLICA);
        FETCH_RESPONSE_PARTITION_V4 = new Schema(new Field(PARTITION_HEADER_KEY_NAME, FETCH_RESPONSE_PARTITION_HEADER_V4), new Field(RECORD_SET_KEY_NAME, Type.RECORDS));
        FETCH_RESPONSE_PARTITION_V5 = new Schema(new Field(PARTITION_HEADER_KEY_NAME, FETCH_RESPONSE_PARTITION_HEADER_V5), new Field(RECORD_SET_KEY_NAME, Type.RECORDS));
        FETCH_RESPONSE_PARTITION_V6 = new Schema(new Field(PARTITION_HEADER_KEY_NAME, FETCH_RESPONSE_PARTITION_HEADER_V6), new Field(RECORD_SET_KEY_NAME, Type.RECORDS));
        FETCH_RESPONSE_TOPIC_V4 = new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(FETCH_RESPONSE_PARTITION_V4)));
        FETCH_RESPONSE_TOPIC_V5 = new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(FETCH_RESPONSE_PARTITION_V5)));
        FETCH_RESPONSE_TOPIC_V6 = new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(FETCH_RESPONSE_PARTITION_V6)));
        FETCH_RESPONSE_V4 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V4)));
        FETCH_RESPONSE_V6 = FETCH_RESPONSE_V5 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V5)));
        SESSION_ID = new Field.Int32("session_id", "The fetch session ID");
        FETCH_RESPONSE_V10 = FETCH_RESPONSE_V9 = (FETCH_RESPONSE_V8 = (FETCH_RESPONSE_V7 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, SESSION_ID, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V5)))));
        FETCH_RESPONSE_V11 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, SESSION_ID, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V6)));
    }

    public static final class PartitionData<T extends BaseRecords> {
        public final Errors error;
        public final long highWatermark;
        public final long lastStableOffset;
        public final long logStartOffset;
        public final Optional<Integer> preferredReadReplica;
        public final List<AbortedTransaction> abortedTransactions;
        public final T records;

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, Optional<Integer> preferredReadReplica, List<AbortedTransaction> abortedTransactions, T records) {
            this.error = error;
            this.highWatermark = highWatermark;
            this.lastStableOffset = lastStableOffset;
            this.logStartOffset = logStartOffset;
            this.preferredReadReplica = preferredReadReplica;
            this.abortedTransactions = abortedTransactions;
            this.records = records;
        }

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, List<AbortedTransaction> abortedTransactions, T records) {
            this.error = error;
            this.highWatermark = highWatermark;
            this.lastStableOffset = lastStableOffset;
            this.logStartOffset = logStartOffset;
            this.preferredReadReplica = Optional.empty();
            this.abortedTransactions = abortedTransactions;
            this.records = records;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return this.error == that.error && this.highWatermark == that.highWatermark && this.lastStableOffset == that.lastStableOffset && this.logStartOffset == that.logStartOffset && Objects.equals(this.preferredReadReplica, that.preferredReadReplica) && Objects.equals(this.abortedTransactions, that.abortedTransactions) && Objects.equals(this.records, that.records);
        }

        public int hashCode() {
            int result = this.error != null ? this.error.hashCode() : 0;
            result = 31 * result + Long.hashCode(this.highWatermark);
            result = 31 * result + Long.hashCode(this.lastStableOffset);
            result = 31 * result + Long.hashCode(this.logStartOffset);
            result = 31 * result + (this.preferredReadReplica != null ? this.preferredReadReplica.hashCode() : 0);
            result = 31 * result + (this.abortedTransactions != null ? this.abortedTransactions.hashCode() : 0);
            result = 31 * result + (this.records != null ? this.records.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "(error=" + (Object)((Object)this.error) + ", highWaterMark=" + this.highWatermark + ", lastStableOffset = " + this.lastStableOffset + ", logStartOffset = " + this.logStartOffset + ", preferredReadReplica = " + this.preferredReadReplica.map(Object::toString).orElse("absent") + ", abortedTransactions = " + this.abortedTransactions + ", recordsSizeInBytes=" + this.records.sizeInBytes() + ")";
        }
    }

    public static final class AbortedTransaction {
        public final long producerId;
        public final long firstOffset;

        public AbortedTransaction(long producerId, long firstOffset) {
            this.producerId = producerId;
            this.firstOffset = firstOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbortedTransaction that = (AbortedTransaction)o;
            return this.producerId == that.producerId && this.firstOffset == that.firstOffset;
        }

        public int hashCode() {
            int result = Long.hashCode(this.producerId);
            result = 31 * result + Long.hashCode(this.firstOffset);
            return result;
        }

        public String toString() {
            return "(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }
    }
}

