/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.CommonFields;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractResponse;

public class EndTxnResponse
extends AbstractResponse {
    private static final Schema END_TXN_RESPONSE_V0;
    private static final Schema END_TXN_RESPONSE_V1;
    private final Errors error;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{END_TXN_RESPONSE_V0, END_TXN_RESPONSE_V1};
    }

    public EndTxnResponse(int throttleTimeMs, Errors error) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
    }

    public EndTxnResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.END_TXN.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        return struct;
    }

    public static EndTxnResponse parse(ByteBuffer buffer, short version) {
        return new EndTxnResponse(ApiKeys.END_TXN.parseResponse(version, buffer));
    }

    public String toString() {
        return "EndTxnResponse(error=" + (Object)((Object)this.error) + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        END_TXN_RESPONSE_V1 = END_TXN_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE);
    }
}

