/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.CommonFields;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.DescribeDelegationTokenResponse;
import org.apache.kafkaesque.common.security.auth.KafkaPrincipal;

public class DescribeDelegationTokenRequest
extends AbstractRequest {
    private static final String OWNER_KEY_NAME = "owners";
    private final List<KafkaPrincipal> owners;
    public static final Schema TOKEN_DESCRIBE_REQUEST_V0;
    public static final Schema TOKEN_DESCRIBE_REQUEST_V1;

    private DescribeDelegationTokenRequest(short version, List<KafkaPrincipal> owners) {
        super(ApiKeys.DESCRIBE_DELEGATION_TOKEN, version);
        this.owners = owners;
    }

    public DescribeDelegationTokenRequest(Struct struct, short versionId) {
        super(ApiKeys.DESCRIBE_DELEGATION_TOKEN, versionId);
        Object[] ownerArray = struct.getArray(OWNER_KEY_NAME);
        if (ownerArray != null) {
            this.owners = new ArrayList<KafkaPrincipal>();
            for (Object ownerObj : ownerArray) {
                Struct ownerObjStruct = (Struct)ownerObj;
                String principalType = ownerObjStruct.get(CommonFields.PRINCIPAL_TYPE);
                String principalName = ownerObjStruct.get(CommonFields.PRINCIPAL_NAME);
                this.owners.add(new KafkaPrincipal(principalType, principalName));
            }
        } else {
            this.owners = null;
        }
    }

    public static Schema[] schemaVersions() {
        return new Schema[]{TOKEN_DESCRIBE_REQUEST_V0, TOKEN_DESCRIBE_REQUEST_V1};
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.DESCRIBE_DELEGATION_TOKEN.requestSchema(version));
        if (this.owners == null) {
            struct.set(OWNER_KEY_NAME, null);
        } else {
            Object[] ownersArray = new Object[this.owners.size()];
            int i = 0;
            for (KafkaPrincipal principal : this.owners) {
                Struct ownerStruct = struct.instance(OWNER_KEY_NAME);
                ownerStruct.set(CommonFields.PRINCIPAL_TYPE, principal.getPrincipalType());
                ownerStruct.set(CommonFields.PRINCIPAL_NAME, principal.getName());
                ownersArray[i++] = ownerStruct;
            }
            struct.set(OWNER_KEY_NAME, (Object)ownersArray);
        }
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeDelegationTokenResponse(throttleTimeMs, Errors.forException(e));
    }

    public List<KafkaPrincipal> owners() {
        return this.owners;
    }

    public boolean ownersListEmpty() {
        return this.owners != null && this.owners.isEmpty();
    }

    public static DescribeDelegationTokenRequest parse(ByteBuffer buffer, short version) {
        return new DescribeDelegationTokenRequest(ApiKeys.DESCRIBE_DELEGATION_TOKEN.parseRequest(version, buffer), version);
    }

    static {
        TOKEN_DESCRIBE_REQUEST_V1 = TOKEN_DESCRIBE_REQUEST_V0 = new Schema(new Field(OWNER_KEY_NAME, ArrayOf.nullable(new Schema(CommonFields.PRINCIPAL_TYPE, CommonFields.PRINCIPAL_NAME)), "An array of token owners."));
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeDelegationTokenRequest> {
        private final List<KafkaPrincipal> owners;

        public Builder(List<KafkaPrincipal> owners) {
            super(ApiKeys.DESCRIBE_DELEGATION_TOKEN);
            this.owners = owners;
        }

        @Override
        public DescribeDelegationTokenRequest build(short version) {
            return new DescribeDelegationTokenRequest(version, this.owners);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: DescribeDelegationTokenRequest").append(", owners=").append(this.owners).append(")");
            return bld.toString();
        }
    }
}

