/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafkaesque.common.acl.AccessControlEntry;
import org.apache.kafkaesque.common.acl.AclBinding;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.CommonFields;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.ApiError;
import org.apache.kafkaesque.common.requests.RequestUtils;
import org.apache.kafkaesque.common.resource.PatternType;
import org.apache.kafkaesque.common.resource.ResourcePattern;

public class DescribeAclsResponse
extends AbstractResponse {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String ACLS_KEY_NAME = "acls";
    private static final Schema DESCRIBE_ACLS_RESOURCE_V0 = new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, new Field("acls", new ArrayOf(new Schema(CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private static final Schema DESCRIBE_ACLS_RESOURCE_V1 = new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, CommonFields.RESOURCE_PATTERN_TYPE, new Field("acls", new ArrayOf(new Schema(CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private static final Schema DESCRIBE_ACLS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resources", new ArrayOf(DESCRIBE_ACLS_RESOURCE_V0), "The resources and their associated ACLs."));
    private static final Schema DESCRIBE_ACLS_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resources", new ArrayOf(DESCRIBE_ACLS_RESOURCE_V1), "The resources and their associated ACLs."));
    private final int throttleTimeMs;
    private final ApiError error;
    private final Collection<AclBinding> acls;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_ACLS_RESPONSE_V0, DESCRIBE_ACLS_RESPONSE_V1};
    }

    public DescribeAclsResponse(int throttleTimeMs, ApiError error, Collection<AclBinding> acls) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.acls = acls;
    }

    public DescribeAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        this.error = new ApiError(struct);
        this.acls = new ArrayList<AclBinding>();
        for (Object resourceStructObj : struct.getArray(RESOURCES_KEY_NAME)) {
            Struct resourceStruct = (Struct)resourceStructObj;
            ResourcePattern pattern = RequestUtils.resourcePatternromStructFields(resourceStruct);
            for (Object aclDataStructObj : resourceStruct.getArray(ACLS_KEY_NAME)) {
                Struct aclDataStruct = (Struct)aclDataStructObj;
                AccessControlEntry entry = RequestUtils.aceFromStructFields(aclDataStruct);
                this.acls.add(new AclBinding(pattern, entry));
            }
        }
    }

    @Override
    protected Struct toStruct(short version) {
        this.validate(version);
        Struct struct = new Struct(ApiKeys.DESCRIBE_ACLS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        this.error.write(struct);
        HashMap<ResourcePattern, List> resourceToData = new HashMap<ResourcePattern, List>();
        for (AclBinding acl : this.acls) {
            resourceToData.computeIfAbsent(acl.pattern(), k -> new ArrayList()).add(acl.entry());
        }
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>();
        for (Map.Entry tuple : resourceToData.entrySet()) {
            ResourcePattern resource = (ResourcePattern)tuple.getKey();
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            RequestUtils.resourcePatternSetStructFields(resource, resourceStruct);
            ArrayList<Struct> dataStructs = new ArrayList<Struct>();
            for (AccessControlEntry entry : (List)tuple.getValue()) {
                Struct dataStruct = resourceStruct.instance(ACLS_KEY_NAME);
                RequestUtils.aceSetStructFields(entry, dataStruct);
                dataStructs.add(dataStruct);
            }
            resourceStruct.set(ACLS_KEY_NAME, (Object)dataStructs.toArray());
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray());
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public ApiError error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error.error());
    }

    public Collection<AclBinding> acls() {
        return this.acls;
    }

    public static DescribeAclsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeAclsResponse(ApiKeys.DESCRIBE_ACLS.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    private void validate(short version) {
        boolean unsupported;
        if (version == 0 && (unsupported = this.acls.stream().map(AclBinding::pattern).map(ResourcePattern::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = this.acls.stream().anyMatch(AclBinding::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("Contain UNKNOWN elements");
        }
    }
}

