/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafkaesque.common.message.CreateTopicsResponseData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractResponse;

public class CreateTopicsResponse
extends AbstractResponse {
    private final CreateTopicsResponseData data;

    public CreateTopicsResponse(CreateTopicsResponseData data) {
        this.data = data;
    }

    public CreateTopicsResponse(Struct struct, short version) {
        this.data = new CreateTopicsResponseData(struct, version);
    }

    public CreateTopicsResponseData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        for (CreateTopicsResponseData.CreatableTopicResult result : this.data.topics()) {
            Errors error = Errors.forCode(result.errorCode());
            counts.put(error, counts.getOrDefault((Object)error, 0) + 1);
        }
        return counts;
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer, short version) {
        return new CreateTopicsResponse(ApiKeys.CREATE_TOPICS.responseSchema(version).read(buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }
}

