/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafkaesque.common.message.ControlledShutdownRequestData;
import org.apache.kafkaesque.common.message.ControlledShutdownResponseData;
import org.apache.kafkaesque.common.protocol.ApiKeys;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.AbstractResponse;
import org.apache.kafkaesque.common.requests.ControlledShutdownResponse;

public class ControlledShutdownRequest
extends AbstractRequest {
    private final ControlledShutdownRequestData data;
    private final short version;

    private ControlledShutdownRequest(ControlledShutdownRequestData data, short version) {
        super(ApiKeys.CONTROLLED_SHUTDOWN, version);
        this.data = data;
        this.version = version;
    }

    public ControlledShutdownRequest(Struct struct, short version) {
        super(ApiKeys.CONTROLLED_SHUTDOWN, version);
        this.data = new ControlledShutdownRequestData(struct, version);
        this.version = version;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ControlledShutdownResponseData response = new ControlledShutdownResponseData();
        response.setErrorCode(Errors.forException(e).code());
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new ControlledShutdownResponse(response);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CONTROLLED_SHUTDOWN.latestVersion()));
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownRequest(ApiKeys.CONTROLLED_SHUTDOWN.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public ControlledShutdownRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<ControlledShutdownRequest> {
        private final ControlledShutdownRequestData data;

        public Builder(ControlledShutdownRequestData data, short desiredVersion) {
            super(ApiKeys.CONTROLLED_SHUTDOWN, desiredVersion);
            this.data = data;
        }

        @Override
        public ControlledShutdownRequest build(short version) {
            return new ControlledShutdownRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

