/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.protocol;

import java.nio.charset.StandardCharsets;

public interface Writable {
    public void writeByte(byte var1);

    public void writeShort(short var1);

    public void writeInt(int var1);

    public void writeLong(long var1);

    public void writeArray(byte[] var1);

    default public void writeNullableBytes(byte[] arr) {
        if (arr == null) {
            this.writeInt(-1);
        } else {
            this.writeBytes(arr);
        }
    }

    default public void writeBytes(byte[] arr) {
        this.writeInt(arr.length);
        this.writeArray(arr);
    }

    default public void writeNullableString(String string) {
        if (string == null) {
            this.writeShort((short)-1);
        } else {
            this.writeString(string);
        }
    }

    default public void writeString(String string) {
        byte[] arr = string.getBytes(StandardCharsets.UTF_8);
        if (arr.length > Short.MAX_VALUE) {
            throw new RuntimeException("Can't store string longer than 32767");
        }
        this.writeShort((short)arr.length);
        this.writeArray(arr);
    }
}

