/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.network;

import java.io.Closeable;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafkaesque.common.KafkaException;
import org.apache.kafkaesque.common.memory.MemoryPool;
import org.apache.kafkaesque.common.network.Authenticator;
import org.apache.kafkaesque.common.network.ChannelBuilder;
import org.apache.kafkaesque.common.network.ChannelBuilders;
import org.apache.kafkaesque.common.network.KafkaChannel;
import org.apache.kafkaesque.common.network.ListenerName;
import org.apache.kafkaesque.common.network.PlaintextTransportLayer;
import org.apache.kafkaesque.common.security.auth.KafkaPrincipal;
import org.apache.kafkaesque.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafkaesque.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafkaesque.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaintextChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(PlaintextChannelBuilder.class);
    private final ListenerName listenerName;
    private Map<String, ?> configs;

    public PlaintextChannelBuilder(ListenerName listenerName) {
        this.listenerName = listenerName;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        this.configs = configs;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, MemoryPool memoryPool) throws KafkaException {
        try {
            PlaintextTransportLayer transportLayer = new PlaintextTransportLayer(key);
            Supplier<Authenticator> authenticatorCreator = () -> new PlaintextAuthenticator(this.configs, transportLayer, this.listenerName);
            return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, memoryPool != null ? memoryPool : MemoryPool.NONE);
        }
        catch (Exception e) {
            log.warn("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
    }

    private static class PlaintextAuthenticator
    implements Authenticator {
        private final PlaintextTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;
        private final ListenerName listenerName;

        private PlaintextAuthenticator(Map<String, ?> configs, PlaintextTransportLayer transportLayer, ListenerName listenerName) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, transportLayer, this, null, null);
            this.listenerName = listenerName;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            if (this.listenerName == null) {
                throw new IllegalStateException("Unexpected call to principal() when listenerName is null");
            }
            return this.principalBuilder.build(new PlaintextAuthenticationContext(clientAddress, this.listenerName.value()));
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public void close() {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }
    }
}

