/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class UpdateMetadataRequestData
implements ApiMessage {
    private int controllerId;
    private int controllerEpoch;
    private long brokerEpoch;
    private List<UpdateMetadataRequestTopicState> topicStates;
    private List<UpdateMetadataRequestPartitionStateV0> partitionStatesV0;
    private List<UpdateMetadataRequestBroker> brokers;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states_v0", new ArrayOf(UpdateMetadataRequestPartitionStateV0.SCHEMA_0), "Each partition that we would like to update."), new Field("brokers", new ArrayOf(UpdateMetadataRequestBroker.SCHEMA_0), ""));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states_v0", new ArrayOf(UpdateMetadataRequestPartitionStateV0.SCHEMA_0), "Each partition that we would like to update."), new Field("brokers", new ArrayOf(UpdateMetadataRequestBroker.SCHEMA_1), ""));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states_v0", new ArrayOf(UpdateMetadataRequestPartitionStateV0.SCHEMA_0), "Each partition that we would like to update."), new Field("brokers", new ArrayOf(UpdateMetadataRequestBroker.SCHEMA_2), ""));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states_v0", new ArrayOf(UpdateMetadataRequestPartitionStateV0.SCHEMA_0), "Each partition that we would like to update."), new Field("brokers", new ArrayOf(UpdateMetadataRequestBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_4 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states_v0", new ArrayOf(UpdateMetadataRequestPartitionStateV0.SCHEMA_4), "Each partition that we would like to update."), new Field("brokers", new ArrayOf(UpdateMetadataRequestBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_5 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new ArrayOf(UpdateMetadataRequestTopicState.SCHEMA_5), "Each topic that we would like to update."), new Field("brokers", new ArrayOf(UpdateMetadataRequestBroker.SCHEMA_3), ""));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};

    public UpdateMetadataRequestData(Readable readable, short version) {
        this.topicStates = new ArrayList<UpdateMetadataRequestTopicState>();
        this.partitionStatesV0 = new ArrayList<UpdateMetadataRequestPartitionStateV0>();
        this.brokers = new ArrayList<UpdateMetadataRequestBroker>();
        this.read(readable, version);
    }

    public UpdateMetadataRequestData(Struct struct, short version) {
        this.topicStates = new ArrayList<UpdateMetadataRequestTopicState>();
        this.partitionStatesV0 = new ArrayList<UpdateMetadataRequestPartitionStateV0>();
        this.brokers = new ArrayList<UpdateMetadataRequestBroker>();
        this.fromStruct(struct, version);
    }

    public UpdateMetadataRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.topicStates = new ArrayList<UpdateMetadataRequestTopicState>();
        this.partitionStatesV0 = new ArrayList<UpdateMetadataRequestPartitionStateV0>();
        this.brokers = new ArrayList<UpdateMetadataRequestBroker>();
    }

    @Override
    public short apiKey() {
        return 6;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable readable, short version) {
        int i;
        int arrayLength;
        this.controllerId = readable.readInt();
        this.controllerEpoch = readable.readInt();
        this.brokerEpoch = version >= 5 ? readable.readLong() : -1L;
        if (version >= 5) {
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topicStates = null;
            } else {
                this.topicStates.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.topicStates.add(new UpdateMetadataRequestTopicState(readable, version));
                }
            }
        } else {
            this.topicStates = new ArrayList<UpdateMetadataRequestTopicState>();
        }
        if (version <= 4) {
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionStatesV0 = null;
            } else {
                this.partitionStatesV0.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.partitionStatesV0.add(new UpdateMetadataRequestPartitionStateV0(readable, version));
                }
            }
        } else {
            this.partitionStatesV0 = new ArrayList<UpdateMetadataRequestPartitionStateV0>();
        }
        if ((arrayLength = readable.readInt()) < 0) {
            this.brokers = null;
        } else {
            this.brokers.clear();
            for (i = 0; i < arrayLength; ++i) {
                this.brokers.add(new UpdateMetadataRequestBroker(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.controllerId);
        writable.writeInt(this.controllerEpoch);
        if (version >= 5) {
            writable.writeLong(this.brokerEpoch);
        }
        if (version >= 5) {
            writable.writeInt(this.topicStates.size());
            for (UpdateMetadataRequestTopicState updateMetadataRequestTopicState : this.topicStates) {
                updateMetadataRequestTopicState.write(writable, version);
            }
        }
        if (version <= 4) {
            writable.writeInt(this.partitionStatesV0.size());
            for (UpdateMetadataRequestPartitionStateV0 updateMetadataRequestPartitionStateV0 : this.partitionStatesV0) {
                updateMetadataRequestPartitionStateV0.write(writable, version);
            }
        }
        writable.writeInt(this.brokers.size());
        for (UpdateMetadataRequestBroker updateMetadataRequestBroker : this.brokers) {
            updateMetadataRequestBroker.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects;
        this.controllerId = struct.getInt("controller_id");
        this.controllerEpoch = struct.getInt("controller_epoch");
        this.brokerEpoch = version >= 5 ? struct.getLong("broker_epoch") : -1L;
        if (version >= 5) {
            nestedObjects = struct.getArray("topic_states");
            this.topicStates = new ArrayList<UpdateMetadataRequestTopicState>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topicStates.add(new UpdateMetadataRequestTopicState((Struct)nestedObject, version));
            }
        } else {
            this.topicStates = new ArrayList<UpdateMetadataRequestTopicState>();
        }
        if (version <= 4) {
            nestedObjects = struct.getArray("partition_states_v0");
            this.partitionStatesV0 = new ArrayList<UpdateMetadataRequestPartitionStateV0>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionStatesV0.add(new UpdateMetadataRequestPartitionStateV0((Struct)nestedObject, version));
            }
        } else {
            this.partitionStatesV0 = new ArrayList<UpdateMetadataRequestPartitionStateV0>();
        }
        nestedObjects = struct.getArray("brokers");
        this.brokers = new ArrayList<UpdateMetadataRequestBroker>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.brokers.add(new UpdateMetadataRequestBroker((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        int i;
        Struct[] nestedObjects;
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("controller_id", (Object)this.controllerId);
        struct.set("controller_epoch", (Object)this.controllerEpoch);
        if (version >= 5) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        if (version >= 5) {
            nestedObjects = new Struct[this.topicStates.size()];
            i = 0;
            for (UpdateMetadataRequestTopicState updateMetadataRequestTopicState : this.topicStates) {
                nestedObjects[i++] = updateMetadataRequestTopicState.toStruct(version);
            }
            struct.set("topic_states", (Object)nestedObjects);
        }
        if (version <= 4) {
            nestedObjects = new Struct[this.partitionStatesV0.size()];
            i = 0;
            for (UpdateMetadataRequestPartitionStateV0 updateMetadataRequestPartitionStateV0 : this.partitionStatesV0) {
                nestedObjects[i++] = updateMetadataRequestPartitionStateV0.toStruct(version);
            }
            struct.set("partition_states_v0", (Object)nestedObjects);
        }
        nestedObjects = new Struct[this.brokers.size()];
        i = 0;
        for (UpdateMetadataRequestBroker updateMetadataRequestBroker : this.brokers) {
            nestedObjects[i++] = updateMetadataRequestBroker.toStruct(version);
        }
        struct.set("brokers", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        if (version >= 5) {
            size += 8;
        }
        if (version >= 5) {
            size += 4;
            for (UpdateMetadataRequestTopicState updateMetadataRequestTopicState : this.topicStates) {
                size += updateMetadataRequestTopicState.size(version);
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + version);
        }
        if (version <= 4) {
            size += 4;
            for (UpdateMetadataRequestPartitionStateV0 updateMetadataRequestPartitionStateV0 : this.partitionStatesV0) {
                size += updateMetadataRequestPartitionStateV0.size(version);
            }
        } else if (!this.partitionStatesV0.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default partitionStatesV0 at version " + version);
        }
        size += 4;
        for (UpdateMetadataRequestBroker updateMetadataRequestBroker : this.brokers) {
            size += updateMetadataRequestBroker.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateMetadataRequestData)) {
            return false;
        }
        UpdateMetadataRequestData other = (UpdateMetadataRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        if (this.partitionStatesV0 == null ? other.partitionStatesV0 != null : !this.partitionStatesV0.equals(other.partitionStatesV0)) {
            return false;
        }
        return !(this.brokers == null ? other.brokers != null : !this.brokers.equals(other.brokers));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.partitionStatesV0 == null ? 0 : this.partitionStatesV0.hashCode());
        hashCode = 31 * hashCode + (this.brokers == null ? 0 : this.brokers.hashCode());
        return hashCode;
    }

    public String toString() {
        return "UpdateMetadataRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", partitionStatesV0=" + MessageUtil.deepToString(this.partitionStatesV0.iterator()) + ", brokers=" + MessageUtil.deepToString(this.brokers.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<UpdateMetadataRequestTopicState> topicStates() {
        return this.topicStates;
    }

    public List<UpdateMetadataRequestPartitionStateV0> partitionStatesV0() {
        return this.partitionStatesV0;
    }

    public List<UpdateMetadataRequestBroker> brokers() {
        return this.brokers;
    }

    public UpdateMetadataRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public UpdateMetadataRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public UpdateMetadataRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public UpdateMetadataRequestData setTopicStates(List<UpdateMetadataRequestTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public UpdateMetadataRequestData setPartitionStatesV0(List<UpdateMetadataRequestPartitionStateV0> v) {
        this.partitionStatesV0 = v;
        return this;
    }

    public UpdateMetadataRequestData setBrokers(List<UpdateMetadataRequestBroker> v) {
        this.brokers = v;
        return this;
    }

    public static class UpdateMetadataRequestEndpoint
    implements Message {
        private int port;
        private String host;
        private String listener;
        private short securityProtocol;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public UpdateMetadataRequestEndpoint(Readable readable, short version) {
            this.read(readable, version);
        }

        public UpdateMetadataRequestEndpoint(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public UpdateMetadataRequestEndpoint() {
            this.port = 0;
            this.host = "";
            this.listener = "";
            this.securityProtocol = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't read version " + version + " of UpdateMetadataRequestEndpoint");
            }
            this.port = readable.readInt();
            this.host = readable.readNullableString();
            this.listener = version >= 3 ? readable.readNullableString() : "";
            this.securityProtocol = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't write version " + version + " of UpdateMetadataRequestEndpoint");
            }
            writable.writeInt(this.port);
            writable.writeString(this.host);
            if (version >= 3) {
                writable.writeString(this.listener);
            }
            writable.writeShort(this.securityProtocol);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't read version " + version + " of UpdateMetadataRequestEndpoint");
            }
            this.port = struct.getInt("port");
            this.host = struct.getString("host");
            this.listener = version >= 3 ? struct.getString("listener") : "";
            this.securityProtocol = struct.getShort("security_protocol");
        }

        @Override
        public Struct toStruct(short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("Can't write version " + version + " of UpdateMetadataRequestEndpoint");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("port", (Object)this.port);
            struct.set("host", (Object)this.host);
            if (version >= 3) {
                struct.set("listener", (Object)this.listener);
            }
            struct.set("security_protocol", (Object)this.securityProtocol);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version < 1) {
                throw new UnsupportedVersionException("Can't size version " + version + " of UpdateMetadataRequestEndpoint");
            }
            size += 4;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.host);
            if (version >= 3) {
                size += 2;
                size += MessageUtil.serializedUtf8Length(this.listener);
            } else if (!this.listener.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default listener at version " + version);
            }
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataRequestEndpoint)) {
                return false;
            }
            UpdateMetadataRequestEndpoint other = (UpdateMetadataRequestEndpoint)obj;
            if (this.port != other.port) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            return this.securityProtocol == other.securityProtocol;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.port;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + (this.listener == null ? 0 : this.listener.hashCode());
            hashCode = 31 * hashCode + this.securityProtocol;
            return hashCode;
        }

        public String toString() {
            return "UpdateMetadataRequestEndpoint(port=" + this.port + ", host='" + this.host + "', listener='" + this.listener + "', securityProtocol=" + this.securityProtocol + ")";
        }

        public int port() {
            return this.port;
        }

        public String host() {
            return this.host;
        }

        public String listener() {
            return this.listener;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        public UpdateMetadataRequestEndpoint setPort(int v) {
            this.port = v;
            return this;
        }

        public UpdateMetadataRequestEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public UpdateMetadataRequestEndpoint setListener(String v) {
            this.listener = v;
            return this;
        }

        public UpdateMetadataRequestEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.STRING, "The hostname of this endpoint"), new Field("security_protocol", Type.INT16, "The security protocol type."));
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.STRING, "The hostname of this endpoint"), new Field("listener", Type.STRING, "The listener name."), new Field("security_protocol", Type.INT16, "The security protocol type.")));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class UpdateMetadataRequestBroker
    implements Message {
        private int id;
        private String v0Host;
        private int v0Port;
        private List<UpdateMetadataRequestEndpoint> endpoints;
        private String rack;
        public static final Schema SCHEMA_0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("v0_host", Type.STRING, "The broker hostname."), new Field("v0_port", Type.INT32, "The broker port."));
        public static final Schema SCHEMA_1 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataRequestEndpoint.SCHEMA_1), "The broker endpoints."));
        public static final Schema SCHEMA_2 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataRequestEndpoint.SCHEMA_1), "The broker endpoints."), new Field("rack", Type.NULLABLE_STRING, "The rack which this broker belongs to."));
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public UpdateMetadataRequestBroker(Readable readable, short version) {
            this.endpoints = new ArrayList<UpdateMetadataRequestEndpoint>();
            this.read(readable, version);
        }

        public UpdateMetadataRequestBroker(Struct struct, short version) {
            this.endpoints = new ArrayList<UpdateMetadataRequestEndpoint>();
            this.fromStruct(struct, version);
        }

        public UpdateMetadataRequestBroker() {
            this.id = 0;
            this.v0Host = "";
            this.v0Port = 0;
            this.endpoints = new ArrayList<UpdateMetadataRequestEndpoint>();
            this.rack = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            this.id = readable.readInt();
            this.v0Host = version <= 0 ? readable.readNullableString() : "";
            this.v0Port = version <= 0 ? readable.readInt() : 0;
            if (version >= 1) {
                int arrayLength = readable.readInt();
                if (arrayLength < 0) {
                    this.endpoints = null;
                } else {
                    this.endpoints.clear();
                    for (int i = 0; i < arrayLength; ++i) {
                        this.endpoints.add(new UpdateMetadataRequestEndpoint(readable, version));
                    }
                }
            } else {
                this.endpoints = new ArrayList<UpdateMetadataRequestEndpoint>();
            }
            this.rack = version >= 2 ? readable.readNullableString() : "";
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.id);
            if (version <= 0) {
                writable.writeString(this.v0Host);
            }
            if (version <= 0) {
                writable.writeInt(this.v0Port);
            }
            if (version >= 1) {
                writable.writeInt(this.endpoints.size());
                for (UpdateMetadataRequestEndpoint element : this.endpoints) {
                    element.write(writable, version);
                }
            }
            if (version >= 2) {
                writable.writeNullableString(this.rack);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.id = struct.getInt("id");
            this.v0Host = version <= 0 ? struct.getString("v0_host") : "";
            this.v0Port = version <= 0 ? struct.getInt("v0_port") : 0;
            if (version >= 1) {
                Object[] nestedObjects = struct.getArray("endpoints");
                this.endpoints = new ArrayList<UpdateMetadataRequestEndpoint>(nestedObjects.length);
                for (Object nestedObject : nestedObjects) {
                    this.endpoints.add(new UpdateMetadataRequestEndpoint((Struct)nestedObject, version));
                }
            } else {
                this.endpoints = new ArrayList<UpdateMetadataRequestEndpoint>();
            }
            this.rack = version >= 2 ? struct.getString("rack") : "";
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("id", (Object)this.id);
            if (version <= 0) {
                struct.set("v0_host", (Object)this.v0Host);
            }
            if (version <= 0) {
                struct.set("v0_port", (Object)this.v0Port);
            }
            if (version >= 1) {
                Struct[] nestedObjects = new Struct[this.endpoints.size()];
                int i = 0;
                for (UpdateMetadataRequestEndpoint element : this.endpoints) {
                    nestedObjects[i++] = element.toStruct(version);
                }
                struct.set("endpoints", (Object)nestedObjects);
            }
            if (version >= 2) {
                struct.set("rack", (Object)this.rack);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            if (version <= 0) {
                size += 2;
                size += MessageUtil.serializedUtf8Length(this.v0Host);
            }
            if (version <= 0) {
                size += 4;
            }
            if (version >= 1) {
                size += 4;
                for (UpdateMetadataRequestEndpoint element : this.endpoints) {
                    size += element.size(version);
                }
            } else if (!this.endpoints.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default endpoints at version " + version);
            }
            if (version >= 2) {
                size += 2;
                if (this.rack != null) {
                    size += MessageUtil.serializedUtf8Length(this.rack);
                }
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataRequestBroker)) {
                return false;
            }
            UpdateMetadataRequestBroker other = (UpdateMetadataRequestBroker)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.v0Host == null ? other.v0Host != null : !this.v0Host.equals(other.v0Host)) {
                return false;
            }
            if (this.v0Port != other.v0Port) {
                return false;
            }
            if (this.endpoints == null ? other.endpoints != null : !this.endpoints.equals(other.endpoints)) {
                return false;
            }
            return !(this.rack == null ? other.rack != null : !this.rack.equals(other.rack));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.id;
            hashCode = 31 * hashCode + (this.v0Host == null ? 0 : this.v0Host.hashCode());
            hashCode = 31 * hashCode + this.v0Port;
            hashCode = 31 * hashCode + (this.endpoints == null ? 0 : this.endpoints.hashCode());
            hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
            return hashCode;
        }

        public String toString() {
            return "UpdateMetadataRequestBroker(id=" + this.id + ", v0Host='" + this.v0Host + "', v0Port=" + this.v0Port + ", endpoints=" + MessageUtil.deepToString(this.endpoints.iterator()) + ", rack='" + this.rack + "')";
        }

        public int id() {
            return this.id;
        }

        public String v0Host() {
            return this.v0Host;
        }

        public int v0Port() {
            return this.v0Port;
        }

        public List<UpdateMetadataRequestEndpoint> endpoints() {
            return this.endpoints;
        }

        public String rack() {
            return this.rack;
        }

        public UpdateMetadataRequestBroker setId(int v) {
            this.id = v;
            return this;
        }

        public UpdateMetadataRequestBroker setV0Host(String v) {
            this.v0Host = v;
            return this;
        }

        public UpdateMetadataRequestBroker setV0Port(int v) {
            this.v0Port = v;
            return this;
        }

        public UpdateMetadataRequestBroker setEndpoints(List<UpdateMetadataRequestEndpoint> v) {
            this.endpoints = v;
            return this;
        }

        public UpdateMetadataRequestBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataRequestEndpoint.SCHEMA_3), "The broker endpoints."), new Field("rack", Type.NULLABLE_STRING, "The rack which this broker belongs to.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class UpdateMetadataRequestPartitionStateV0
    implements Message {
        private String topicName;
        private int partitionIndex;
        private int controllerEpoch;
        private int leader;
        private int leaderEpoch;
        private List<Integer> isr;
        private int zkVersion;
        private List<Integer> replicas;
        private List<Integer> offlineReplicas;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;

        public UpdateMetadataRequestPartitionStateV0(Readable readable, short version) {
            this.isr = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public UpdateMetadataRequestPartitionStateV0(Struct struct, short version) {
            this.isr = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public UpdateMetadataRequestPartitionStateV0() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>();
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            int i;
            if (version > 4) {
                throw new UnsupportedVersionException("Can't read version " + version + " of UpdateMetadataRequestPartitionStateV0");
            }
            this.topicName = readable.readNullableString();
            this.partitionIndex = readable.readInt();
            this.controllerEpoch = readable.readInt();
            this.leader = readable.readInt();
            this.leaderEpoch = readable.readInt();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.isr = null;
            } else {
                this.isr.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.isr.add(readable.readInt());
                }
            }
            this.zkVersion = readable.readInt();
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.replicas = null;
            } else {
                this.replicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.replicas.add(readable.readInt());
                }
            }
            if (version >= 4) {
                arrayLength = readable.readInt();
                if (arrayLength < 0) {
                    this.offlineReplicas = null;
                } else {
                    this.offlineReplicas.clear();
                    for (i = 0; i < arrayLength; ++i) {
                        this.offlineReplicas.add(readable.readInt());
                    }
                }
            } else {
                this.offlineReplicas = new ArrayList<Integer>();
            }
        }

        @Override
        public void write(Writable writable, short version) {
            if (version > 4) {
                throw new UnsupportedVersionException("Can't write version " + version + " of UpdateMetadataRequestPartitionStateV0");
            }
            writable.writeString(this.topicName);
            writable.writeInt(this.partitionIndex);
            writable.writeInt(this.controllerEpoch);
            writable.writeInt(this.leader);
            writable.writeInt(this.leaderEpoch);
            writable.writeInt(this.isr.size());
            for (Integer element : this.isr) {
                writable.writeInt(element);
            }
            writable.writeInt(this.zkVersion);
            writable.writeInt(this.replicas.size());
            for (Integer element : this.replicas) {
                writable.writeInt(element);
            }
            if (version >= 4) {
                writable.writeInt(this.offlineReplicas.size());
                for (Integer element : this.offlineReplicas) {
                    writable.writeInt(element);
                }
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version > 4) {
                throw new UnsupportedVersionException("Can't read version " + version + " of UpdateMetadataRequestPartitionStateV0");
            }
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leader = struct.getInt("leader");
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] nestedObjects = struct.getArray("isr");
            this.isr = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.isr.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            if (version >= 4) {
                nestedObjects = struct.getArray("offline_replicas");
                this.offlineReplicas = new ArrayList<Integer>(nestedObjects.length);
                for (Object nestedObject : nestedObjects) {
                    this.offlineReplicas.add((Integer)nestedObject);
                }
            } else {
                this.offlineReplicas = new ArrayList<Integer>();
            }
        }

        @Override
        public Struct toStruct(short version) {
            if (version > 4) {
                throw new UnsupportedVersionException("Can't write version " + version + " of UpdateMetadataRequestPartitionStateV0");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader", (Object)this.leader);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] nestedObjects = new Integer[this.isr.size()];
            int i = 0;
            for (Integer element : this.isr) {
                nestedObjects[i++] = element;
            }
            struct.set("isr", (Object)nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)nestedObjects);
            if (version >= 4) {
                nestedObjects = new Integer[this.offlineReplicas.size()];
                i = 0;
                for (Integer element : this.offlineReplicas) {
                    nestedObjects[i++] = element;
                }
                struct.set("offline_replicas", (Object)nestedObjects);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version > 4) {
                throw new UnsupportedVersionException("Can't size version " + version + " of UpdateMetadataRequestPartitionStateV0");
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += this.isr.size() * 4;
            size += 4;
            size += 4;
            size += this.replicas.size() * 4;
            if (version >= 4) {
                size += 4;
                size += this.offlineReplicas.size() * 4;
            } else if (!this.offlineReplicas.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default offlineReplicas at version " + version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataRequestPartitionStateV0)) {
                return false;
            }
            UpdateMetadataRequestPartitionStateV0 other = (UpdateMetadataRequestPartitionStateV0)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            return !(this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        public String toString() {
            return "UpdateMetadataRequestPartitionStateV0(topicName='" + this.topicName + "', partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        public UpdateMetadataRequestPartitionStateV0 setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setLeader(int v) {
            this.leader = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public UpdateMetadataRequestPartitionStateV0 setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."))));
            SCHEMA_4 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The replicas of this partition which are offline."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class UpdateMetadataPartitionState
    implements Message {
        private int partitionIndex;
        private int controllerEpoch;
        private int leader;
        private int leaderEpoch;
        private List<Integer> isr;
        private int zkVersion;
        private List<Integer> replicas;
        private List<Integer> offlineReplicas;
        public static final Schema SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The replicas of this partition which are offline."));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5};

        public UpdateMetadataPartitionState(Readable readable, short version) {
            this.isr = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public UpdateMetadataPartitionState(Struct struct, short version) {
            this.isr = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public UpdateMetadataPartitionState() {
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>();
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>();
            this.offlineReplicas = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 5;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            int i;
            this.partitionIndex = readable.readInt();
            this.controllerEpoch = readable.readInt();
            this.leader = readable.readInt();
            this.leaderEpoch = readable.readInt();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.isr = null;
            } else {
                this.isr.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.isr.add(readable.readInt());
                }
            }
            this.zkVersion = readable.readInt();
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.replicas = null;
            } else {
                this.replicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.replicas.add(readable.readInt());
                }
            }
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.offlineReplicas = null;
            } else {
                this.offlineReplicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.offlineReplicas.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeInt(this.controllerEpoch);
            writable.writeInt(this.leader);
            writable.writeInt(this.leaderEpoch);
            writable.writeInt(this.isr.size());
            for (Integer element : this.isr) {
                writable.writeInt(element);
            }
            writable.writeInt(this.zkVersion);
            writable.writeInt(this.replicas.size());
            for (Integer element : this.replicas) {
                writable.writeInt(element);
            }
            writable.writeInt(this.offlineReplicas.size());
            for (Integer element : this.offlineReplicas) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leader = struct.getInt("leader");
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] nestedObjects = struct.getArray("isr");
            this.isr = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.isr.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            nestedObjects = struct.getArray("offline_replicas");
            this.offlineReplicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.offlineReplicas.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader", (Object)this.leader);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] nestedObjects = new Integer[this.isr.size()];
            int i = 0;
            for (Integer element : this.isr) {
                nestedObjects[i++] = element;
            }
            struct.set("isr", (Object)nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)nestedObjects);
            nestedObjects = new Integer[this.offlineReplicas.size()];
            i = 0;
            for (Integer element : this.offlineReplicas) {
                nestedObjects[i++] = element;
            }
            struct.set("offline_replicas", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += this.isr.size() * 4;
            size += 4;
            size += 4;
            size += this.replicas.size() * 4;
            size += 4;
            return size += this.offlineReplicas.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataPartitionState)) {
                return false;
            }
            UpdateMetadataPartitionState other = (UpdateMetadataPartitionState)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            return !(this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        public String toString() {
            return "UpdateMetadataPartitionState(partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        public UpdateMetadataPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public UpdateMetadataPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public UpdateMetadataPartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public UpdateMetadataPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public UpdateMetadataPartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public UpdateMetadataPartitionState setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public UpdateMetadataPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public UpdateMetadataPartitionState setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }
    }

    public static class UpdateMetadataRequestTopicState
    implements Message {
        private String topicName;
        private List<UpdateMetadataPartitionState> partitionStates;
        public static final Schema SCHEMA_5 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_5), "The partition that we would like to update."));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5};

        public UpdateMetadataRequestTopicState(Readable readable, short version) {
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>();
            this.read(readable, version);
        }

        public UpdateMetadataRequestTopicState(Struct struct, short version) {
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>();
            this.fromStruct(struct, version);
        }

        public UpdateMetadataRequestTopicState() {
            this.topicName = "";
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable readable, short version) {
            if (version < 5) {
                throw new UnsupportedVersionException("Can't read version " + version + " of UpdateMetadataRequestTopicState");
            }
            this.topicName = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionStates = null;
            } else {
                this.partitionStates.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionStates.add(new UpdateMetadataPartitionState(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            if (version < 5) {
                throw new UnsupportedVersionException("Can't write version " + version + " of UpdateMetadataRequestTopicState");
            }
            writable.writeString(this.topicName);
            writable.writeInt(this.partitionStates.size());
            for (UpdateMetadataPartitionState element : this.partitionStates) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version < 5) {
                throw new UnsupportedVersionException("Can't read version " + version + " of UpdateMetadataRequestTopicState");
            }
            this.topicName = struct.getString("topic_name");
            Object[] nestedObjects = struct.getArray("partition_states");
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionStates.add(new UpdateMetadataPartitionState((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            if (version < 5) {
                throw new UnsupportedVersionException("Can't write version " + version + " of UpdateMetadataRequestTopicState");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            Struct[] nestedObjects = new Struct[this.partitionStates.size()];
            int i = 0;
            for (UpdateMetadataPartitionState element : this.partitionStates) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partition_states", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version < 5) {
                throw new UnsupportedVersionException("Can't size version " + version + " of UpdateMetadataRequestTopicState");
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            size += 4;
            for (UpdateMetadataPartitionState element : this.partitionStates) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataRequestTopicState)) {
                return false;
            }
            UpdateMetadataRequestTopicState other = (UpdateMetadataRequestTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return !(this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        public String toString() {
            return "UpdateMetadataRequestTopicState(topicName='" + this.topicName + "', partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<UpdateMetadataPartitionState> partitionStates() {
            return this.partitionStates;
        }

        public UpdateMetadataRequestTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public UpdateMetadataRequestTopicState setPartitionStates(List<UpdateMetadataPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }
}

