/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.Arrays;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.utils.Bytes;

public class SyncGroupResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private byte[] assignment;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("assignment", Type.BYTES, "The member assignment."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public SyncGroupResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public SyncGroupResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public SyncGroupResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.assignment = Bytes.EMPTY;
    }

    @Override
    public short apiKey() {
        return 14;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        this.errorCode = readable.readShort();
        this.assignment = readable.readNullableBytes();
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        writable.writeShort(this.errorCode);
        writable.writeBytes(this.assignment);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = struct.getShort("error_code");
        this.assignment = struct.getByteArray("assignment");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        struct.set("error_code", (Object)this.errorCode);
        struct.setByteArray("assignment", this.assignment);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 1) {
            size += 4;
        }
        size += 2;
        size += 4;
        return size += this.assignment.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SyncGroupResponseData)) {
            return false;
        }
        SyncGroupResponseData other = (SyncGroupResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return Arrays.equals(this.assignment, other.assignment);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + Arrays.hashCode(this.assignment);
        return hashCode;
    }

    public String toString() {
        return "SyncGroupResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", assignment=" + Arrays.toString(this.assignment) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public byte[] assignment() {
        return this.assignment;
    }

    public SyncGroupResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public SyncGroupResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public SyncGroupResponseData setAssignment(byte[] v) {
        this.assignment = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("assignment", Type.BYTES, "The member assignment.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

