/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class SaslHandshakeRequestData
implements ApiMessage {
    private String mechanism;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public SaslHandshakeRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public SaslHandshakeRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public SaslHandshakeRequestData() {
        this.mechanism = "";
    }

    @Override
    public short apiKey() {
        return 17;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.mechanism = readable.readNullableString();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.mechanism);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.mechanism = struct.getString("mechanism");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("mechanism", (Object)this.mechanism);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        return size += MessageUtil.serializedUtf8Length(this.mechanism);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslHandshakeRequestData)) {
            return false;
        }
        SaslHandshakeRequestData other = (SaslHandshakeRequestData)obj;
        return !(this.mechanism == null ? other.mechanism != null : !this.mechanism.equals(other.mechanism));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.mechanism == null ? 0 : this.mechanism.hashCode());
        return hashCode;
    }

    public String toString() {
        return "SaslHandshakeRequestData(mechanism='" + this.mechanism + "')";
    }

    public String mechanism() {
        return this.mechanism;
    }

    public SaslHandshakeRequestData setMechanism(String v) {
        this.mechanism = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("mechanism", Type.STRING, "The SASL mechanism chosen by the client."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

