/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class LeaderAndIsrRequestData
implements ApiMessage {
    private int controllerId;
    private int controllerEpoch;
    private long brokerEpoch;
    private List<LeaderAndIsrRequestTopicState> topicStates;
    private List<LeaderAndIsrRequestPartitionStateV0> partitionStatesV0;
    private List<LeaderAndIsrLiveLeader> liveLeaders;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("partition_states_v0", new ArrayOf(LeaderAndIsrRequestPartitionStateV0.SCHEMA_0), "The state of each partition"), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("partition_states_v0", new ArrayOf(LeaderAndIsrRequestPartitionStateV0.SCHEMA_1), "The state of each partition"), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The current controller ID."), new Field("controller_epoch", Type.INT32, "The current controller epoch."), new Field("broker_epoch", Type.INT64, "The current broker epoch."), new Field("topic_states", new ArrayOf(LeaderAndIsrRequestTopicState.SCHEMA_2), "Each topic."), new Field("live_leaders", new ArrayOf(LeaderAndIsrLiveLeader.SCHEMA_0), "The current live leaders."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public LeaderAndIsrRequestData(Readable readable, short version) {
        this.topicStates = new ArrayList<LeaderAndIsrRequestTopicState>();
        this.partitionStatesV0 = new ArrayList<LeaderAndIsrRequestPartitionStateV0>();
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>();
        this.read(readable, version);
    }

    public LeaderAndIsrRequestData(Struct struct, short version) {
        this.topicStates = new ArrayList<LeaderAndIsrRequestTopicState>();
        this.partitionStatesV0 = new ArrayList<LeaderAndIsrRequestPartitionStateV0>();
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>();
        this.fromStruct(struct, version);
    }

    public LeaderAndIsrRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.topicStates = new ArrayList<LeaderAndIsrRequestTopicState>();
        this.partitionStatesV0 = new ArrayList<LeaderAndIsrRequestPartitionStateV0>();
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>();
    }

    @Override
    public short apiKey() {
        return 4;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        int i;
        int arrayLength;
        this.controllerId = readable.readInt();
        this.controllerEpoch = readable.readInt();
        this.brokerEpoch = version >= 2 ? readable.readLong() : -1L;
        if (version >= 2) {
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topicStates = null;
            } else {
                this.topicStates.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.topicStates.add(new LeaderAndIsrRequestTopicState(readable, version));
                }
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrRequestTopicState>();
        }
        if (version <= 1) {
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionStatesV0 = null;
            } else {
                this.partitionStatesV0.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.partitionStatesV0.add(new LeaderAndIsrRequestPartitionStateV0(readable, version));
                }
            }
        } else {
            this.partitionStatesV0 = new ArrayList<LeaderAndIsrRequestPartitionStateV0>();
        }
        if ((arrayLength = readable.readInt()) < 0) {
            this.liveLeaders = null;
        } else {
            this.liveLeaders.clear();
            for (i = 0; i < arrayLength; ++i) {
                this.liveLeaders.add(new LeaderAndIsrLiveLeader(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.controllerId);
        writable.writeInt(this.controllerEpoch);
        if (version >= 2) {
            writable.writeLong(this.brokerEpoch);
        }
        if (version >= 2) {
            writable.writeInt(this.topicStates.size());
            for (LeaderAndIsrRequestTopicState leaderAndIsrRequestTopicState : this.topicStates) {
                leaderAndIsrRequestTopicState.write(writable, version);
            }
        }
        if (version <= 1) {
            writable.writeInt(this.partitionStatesV0.size());
            for (LeaderAndIsrRequestPartitionStateV0 leaderAndIsrRequestPartitionStateV0 : this.partitionStatesV0) {
                leaderAndIsrRequestPartitionStateV0.write(writable, version);
            }
        }
        writable.writeInt(this.liveLeaders.size());
        for (LeaderAndIsrLiveLeader leaderAndIsrLiveLeader : this.liveLeaders) {
            leaderAndIsrLiveLeader.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects;
        this.controllerId = struct.getInt("controller_id");
        this.controllerEpoch = struct.getInt("controller_epoch");
        this.brokerEpoch = version >= 2 ? struct.getLong("broker_epoch") : -1L;
        if (version >= 2) {
            nestedObjects = struct.getArray("topic_states");
            this.topicStates = new ArrayList<LeaderAndIsrRequestTopicState>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topicStates.add(new LeaderAndIsrRequestTopicState((Struct)nestedObject, version));
            }
        } else {
            this.topicStates = new ArrayList<LeaderAndIsrRequestTopicState>();
        }
        if (version <= 1) {
            nestedObjects = struct.getArray("partition_states_v0");
            this.partitionStatesV0 = new ArrayList<LeaderAndIsrRequestPartitionStateV0>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionStatesV0.add(new LeaderAndIsrRequestPartitionStateV0((Struct)nestedObject, version));
            }
        } else {
            this.partitionStatesV0 = new ArrayList<LeaderAndIsrRequestPartitionStateV0>();
        }
        nestedObjects = struct.getArray("live_leaders");
        this.liveLeaders = new ArrayList<LeaderAndIsrLiveLeader>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.liveLeaders.add(new LeaderAndIsrLiveLeader((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        int i;
        Struct[] nestedObjects;
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("controller_id", (Object)this.controllerId);
        struct.set("controller_epoch", (Object)this.controllerEpoch);
        if (version >= 2) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        if (version >= 2) {
            nestedObjects = new Struct[this.topicStates.size()];
            i = 0;
            for (LeaderAndIsrRequestTopicState leaderAndIsrRequestTopicState : this.topicStates) {
                nestedObjects[i++] = leaderAndIsrRequestTopicState.toStruct(version);
            }
            struct.set("topic_states", (Object)nestedObjects);
        }
        if (version <= 1) {
            nestedObjects = new Struct[this.partitionStatesV0.size()];
            i = 0;
            for (LeaderAndIsrRequestPartitionStateV0 leaderAndIsrRequestPartitionStateV0 : this.partitionStatesV0) {
                nestedObjects[i++] = leaderAndIsrRequestPartitionStateV0.toStruct(version);
            }
            struct.set("partition_states_v0", (Object)nestedObjects);
        }
        nestedObjects = new Struct[this.liveLeaders.size()];
        i = 0;
        for (LeaderAndIsrLiveLeader leaderAndIsrLiveLeader : this.liveLeaders) {
            nestedObjects[i++] = leaderAndIsrLiveLeader.toStruct(version);
        }
        struct.set("live_leaders", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        if (version >= 2) {
            size += 8;
        }
        if (version >= 2) {
            size += 4;
            for (LeaderAndIsrRequestTopicState leaderAndIsrRequestTopicState : this.topicStates) {
                size += leaderAndIsrRequestTopicState.size(version);
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + version);
        }
        if (version <= 1) {
            size += 4;
            for (LeaderAndIsrRequestPartitionStateV0 leaderAndIsrRequestPartitionStateV0 : this.partitionStatesV0) {
                size += leaderAndIsrRequestPartitionStateV0.size(version);
            }
        } else if (!this.partitionStatesV0.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default partitionStatesV0 at version " + version);
        }
        size += 4;
        for (LeaderAndIsrLiveLeader leaderAndIsrLiveLeader : this.liveLeaders) {
            size += leaderAndIsrLiveLeader.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderAndIsrRequestData)) {
            return false;
        }
        LeaderAndIsrRequestData other = (LeaderAndIsrRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        if (this.partitionStatesV0 == null ? other.partitionStatesV0 != null : !this.partitionStatesV0.equals(other.partitionStatesV0)) {
            return false;
        }
        return !(this.liveLeaders == null ? other.liveLeaders != null : !this.liveLeaders.equals(other.liveLeaders));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.partitionStatesV0 == null ? 0 : this.partitionStatesV0.hashCode());
        hashCode = 31 * hashCode + (this.liveLeaders == null ? 0 : this.liveLeaders.hashCode());
        return hashCode;
    }

    public String toString() {
        return "LeaderAndIsrRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", partitionStatesV0=" + MessageUtil.deepToString(this.partitionStatesV0.iterator()) + ", liveLeaders=" + MessageUtil.deepToString(this.liveLeaders.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<LeaderAndIsrRequestTopicState> topicStates() {
        return this.topicStates;
    }

    public List<LeaderAndIsrRequestPartitionStateV0> partitionStatesV0() {
        return this.partitionStatesV0;
    }

    public List<LeaderAndIsrLiveLeader> liveLeaders() {
        return this.liveLeaders;
    }

    public LeaderAndIsrRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public LeaderAndIsrRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public LeaderAndIsrRequestData setTopicStates(List<LeaderAndIsrRequestTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public LeaderAndIsrRequestData setPartitionStatesV0(List<LeaderAndIsrRequestPartitionStateV0> v) {
        this.partitionStatesV0 = v;
        return this;
    }

    public LeaderAndIsrRequestData setLiveLeaders(List<LeaderAndIsrLiveLeader> v) {
        this.liveLeaders = v;
        return this;
    }

    public static class LeaderAndIsrLiveLeader
    implements Message {
        private int brokerId;
        private String hostName;
        private int port;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public LeaderAndIsrLiveLeader(Readable readable, short version) {
            this.read(readable, version);
        }

        public LeaderAndIsrLiveLeader(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public LeaderAndIsrLiveLeader() {
            this.brokerId = 0;
            this.hostName = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.brokerId = readable.readInt();
            this.hostName = readable.readNullableString();
            this.port = readable.readInt();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.brokerId);
            writable.writeString(this.hostName);
            writable.writeInt(this.port);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.brokerId = struct.getInt("broker_id");
            this.hostName = struct.getString("host_name");
            this.port = struct.getInt("port");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("broker_id", (Object)this.brokerId);
            struct.set("host_name", (Object)this.hostName);
            struct.set("port", (Object)this.port);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.hostName);
            return size += 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrLiveLeader)) {
                return false;
            }
            LeaderAndIsrLiveLeader other = (LeaderAndIsrLiveLeader)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
                return false;
            }
            return this.port == other.port;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.hostName == null ? 0 : this.hostName.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrLiveLeader(brokerId=" + this.brokerId + ", hostName='" + this.hostName + "', port=" + this.port + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String hostName() {
            return this.hostName;
        }

        public int port() {
            return this.port;
        }

        public LeaderAndIsrLiveLeader setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setHostName(String v) {
            this.hostName = v;
            return this;
        }

        public LeaderAndIsrLiveLeader setPort(int v) {
            this.port = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The leader's broker ID."), new Field("host_name", Type.STRING, "The leader's hostname."), new Field("port", Type.INT32, "The leader's port.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class LeaderAndIsrRequestPartitionStateV0
    implements Message {
        private String topicName;
        private int partitionIndex;
        private int controllerEpoch;
        private int leaderKey;
        private int leaderEpoch;
        private List<Integer> isrReplicas;
        private int zkVersion;
        private List<Integer> replicas;
        private boolean isNew;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader_key", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr_replicas", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader_key", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr_replicas", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public LeaderAndIsrRequestPartitionStateV0(Readable readable, short version) {
            this.isrReplicas = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public LeaderAndIsrRequestPartitionStateV0(Struct struct, short version) {
            this.isrReplicas = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public LeaderAndIsrRequestPartitionStateV0() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leaderKey = 0;
            this.leaderEpoch = 0;
            this.isrReplicas = new ArrayList<Integer>();
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>();
            this.isNew = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            int i;
            if (version > 1) {
                throw new UnsupportedVersionException("Can't read version " + version + " of LeaderAndIsrRequestPartitionStateV0");
            }
            this.topicName = readable.readNullableString();
            this.partitionIndex = readable.readInt();
            this.controllerEpoch = readable.readInt();
            this.leaderKey = readable.readInt();
            this.leaderEpoch = readable.readInt();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.isrReplicas = null;
            } else {
                this.isrReplicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.isrReplicas.add(readable.readInt());
                }
            }
            this.zkVersion = readable.readInt();
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.replicas = null;
            } else {
                this.replicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.replicas.add(readable.readInt());
                }
            }
            this.isNew = version >= 1 ? readable.readByte() != 0 : false;
        }

        @Override
        public void write(Writable writable, short version) {
            if (version > 1) {
                throw new UnsupportedVersionException("Can't write version " + version + " of LeaderAndIsrRequestPartitionStateV0");
            }
            writable.writeString(this.topicName);
            writable.writeInt(this.partitionIndex);
            writable.writeInt(this.controllerEpoch);
            writable.writeInt(this.leaderKey);
            writable.writeInt(this.leaderEpoch);
            writable.writeInt(this.isrReplicas.size());
            for (Integer element : this.isrReplicas) {
                writable.writeInt(element);
            }
            writable.writeInt(this.zkVersion);
            writable.writeInt(this.replicas.size());
            for (Integer element : this.replicas) {
                writable.writeInt(element);
            }
            if (version >= 1) {
                writable.writeByte(this.isNew ? (byte)1 : 0);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version > 1) {
                throw new UnsupportedVersionException("Can't read version " + version + " of LeaderAndIsrRequestPartitionStateV0");
            }
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leaderKey = struct.getInt("leader_key");
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] nestedObjects = struct.getArray("isr_replicas");
            this.isrReplicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.isrReplicas.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            this.isNew = version >= 1 ? struct.getBoolean("is_new") : false;
        }

        @Override
        public Struct toStruct(short version) {
            if (version > 1) {
                throw new UnsupportedVersionException("Can't write version " + version + " of LeaderAndIsrRequestPartitionStateV0");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader_key", (Object)this.leaderKey);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] nestedObjects = new Integer[this.isrReplicas.size()];
            int i = 0;
            for (Integer element : this.isrReplicas) {
                nestedObjects[i++] = element;
            }
            struct.set("isr_replicas", (Object)nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)nestedObjects);
            if (version >= 1) {
                struct.set("is_new", (Object)this.isNew);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version > 1) {
                throw new UnsupportedVersionException("Can't size version " + version + " of LeaderAndIsrRequestPartitionStateV0");
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += this.isrReplicas.size() * 4;
            size += 4;
            size += 4;
            size += this.replicas.size() * 4;
            if (version >= 1) {
                ++size;
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrRequestPartitionStateV0)) {
                return false;
            }
            LeaderAndIsrRequestPartitionStateV0 other = (LeaderAndIsrRequestPartitionStateV0)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leaderKey != other.leaderKey) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isrReplicas == null ? other.isrReplicas != null : !this.isrReplicas.equals(other.isrReplicas)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            return this.isNew == other.isNew;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leaderKey;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isrReplicas == null ? 0 : this.isrReplicas.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.isNew ? 1231 : 1237);
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrRequestPartitionStateV0(topicName='" + this.topicName + "', partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leaderKey=" + this.leaderKey + ", leaderEpoch=" + this.leaderEpoch + ", isrReplicas=" + MessageUtil.deepToString(this.isrReplicas.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", isNew=" + (this.isNew ? "true" : "false") + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leaderKey() {
            return this.leaderKey;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isrReplicas() {
            return this.isrReplicas;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public LeaderAndIsrRequestPartitionStateV0 setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setLeaderKey(int v) {
            this.leaderKey = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setIsrReplicas(List<Integer> v) {
            this.isrReplicas = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionStateV0 setIsNew(boolean v) {
            this.isNew = v;
            return this;
        }
    }

    public static class LeaderAndIsrRequestPartitionState
    implements Message {
        private int partitionIndex;
        private int controllerEpoch;
        private int leaderKey;
        private int leaderEpoch;
        private List<Integer> isrReplicas;
        private int zkVersion;
        private List<Integer> replicas;
        private boolean isNew;
        public static final Schema SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader_key", Type.INT32, "The broker ID of the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr_replicas", new ArrayOf(Type.INT32), "The in-sync replica IDs."), new Field("zk_version", Type.INT32, "The ZooKeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica IDs."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not."));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};

        public LeaderAndIsrRequestPartitionState(Readable readable, short version) {
            this.isrReplicas = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public LeaderAndIsrRequestPartitionState(Struct struct, short version) {
            this.isrReplicas = new ArrayList<Integer>();
            this.replicas = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public LeaderAndIsrRequestPartitionState() {
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leaderKey = 0;
            this.leaderEpoch = 0;
            this.isrReplicas = new ArrayList<Integer>();
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>();
            this.isNew = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 2;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            int i;
            this.partitionIndex = readable.readInt();
            this.controllerEpoch = readable.readInt();
            this.leaderKey = readable.readInt();
            this.leaderEpoch = readable.readInt();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.isrReplicas = null;
            } else {
                this.isrReplicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.isrReplicas.add(readable.readInt());
                }
            }
            this.zkVersion = readable.readInt();
            arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.replicas = null;
            } else {
                this.replicas.clear();
                for (i = 0; i < arrayLength; ++i) {
                    this.replicas.add(readable.readInt());
                }
            }
            this.isNew = readable.readByte() != 0;
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeInt(this.controllerEpoch);
            writable.writeInt(this.leaderKey);
            writable.writeInt(this.leaderEpoch);
            writable.writeInt(this.isrReplicas.size());
            for (Integer element : this.isrReplicas) {
                writable.writeInt(element);
            }
            writable.writeInt(this.zkVersion);
            writable.writeInt(this.replicas.size());
            for (Integer element : this.replicas) {
                writable.writeInt(element);
            }
            writable.writeByte(this.isNew ? (byte)1 : 0);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leaderKey = struct.getInt("leader_key");
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] nestedObjects = struct.getArray("isr_replicas");
            this.isrReplicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.isrReplicas.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            this.isNew = struct.getBoolean("is_new");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader_key", (Object)this.leaderKey);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] nestedObjects = new Integer[this.isrReplicas.size()];
            int i = 0;
            for (Integer element : this.isrReplicas) {
                nestedObjects[i++] = element;
            }
            struct.set("isr_replicas", (Object)nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)nestedObjects);
            struct.set("is_new", (Object)this.isNew);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += 4;
            size += this.isrReplicas.size() * 4;
            size += 4;
            size += 4;
            size += this.replicas.size() * 4;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrRequestPartitionState)) {
                return false;
            }
            LeaderAndIsrRequestPartitionState other = (LeaderAndIsrRequestPartitionState)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leaderKey != other.leaderKey) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isrReplicas == null ? other.isrReplicas != null : !this.isrReplicas.equals(other.isrReplicas)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            return this.isNew == other.isNew;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leaderKey;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isrReplicas == null ? 0 : this.isrReplicas.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.isNew ? 1231 : 1237);
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrRequestPartitionState(partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leaderKey=" + this.leaderKey + ", leaderEpoch=" + this.leaderEpoch + ", isrReplicas=" + MessageUtil.deepToString(this.isrReplicas.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", isNew=" + (this.isNew ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leaderKey() {
            return this.leaderKey;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isrReplicas() {
            return this.isrReplicas;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public LeaderAndIsrRequestPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setLeaderKey(int v) {
            this.leaderKey = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setIsrReplicas(List<Integer> v) {
            this.isrReplicas = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public LeaderAndIsrRequestPartitionState setIsNew(boolean v) {
            this.isNew = v;
            return this;
        }
    }

    public static class LeaderAndIsrRequestTopicState
    implements Message {
        private String name;
        private List<LeaderAndIsrRequestPartitionState> partitionStates;
        public static final Schema SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(LeaderAndIsrRequestPartitionState.SCHEMA_2), "The state of each partition"));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, SCHEMA_2};

        public LeaderAndIsrRequestTopicState(Readable readable, short version) {
            this.partitionStates = new ArrayList<LeaderAndIsrRequestPartitionState>();
            this.read(readable, version);
        }

        public LeaderAndIsrRequestTopicState(Struct struct, short version) {
            this.partitionStates = new ArrayList<LeaderAndIsrRequestPartitionState>();
            this.fromStruct(struct, version);
        }

        public LeaderAndIsrRequestTopicState() {
            this.name = "";
            this.partitionStates = new ArrayList<LeaderAndIsrRequestPartitionState>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            if (version < 2) {
                throw new UnsupportedVersionException("Can't read version " + version + " of LeaderAndIsrRequestTopicState");
            }
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionStates = null;
            } else {
                this.partitionStates.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionStates.add(new LeaderAndIsrRequestPartitionState(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            if (version < 2) {
                throw new UnsupportedVersionException("Can't write version " + version + " of LeaderAndIsrRequestTopicState");
            }
            writable.writeString(this.name);
            writable.writeInt(this.partitionStates.size());
            for (LeaderAndIsrRequestPartitionState element : this.partitionStates) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            if (version < 2) {
                throw new UnsupportedVersionException("Can't read version " + version + " of LeaderAndIsrRequestTopicState");
            }
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partition_states");
            this.partitionStates = new ArrayList<LeaderAndIsrRequestPartitionState>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionStates.add(new LeaderAndIsrRequestPartitionState((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            if (version < 2) {
                throw new UnsupportedVersionException("Can't write version " + version + " of LeaderAndIsrRequestTopicState");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitionStates.size()];
            int i = 0;
            for (LeaderAndIsrRequestPartitionState element : this.partitionStates) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partition_states", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            if (version < 2) {
                throw new UnsupportedVersionException("Can't size version " + version + " of LeaderAndIsrRequestTopicState");
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (LeaderAndIsrRequestPartitionState element : this.partitionStates) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrRequestTopicState)) {
                return false;
            }
            LeaderAndIsrRequestTopicState other = (LeaderAndIsrRequestTopicState)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrRequestTopicState(name='" + this.name + "', partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<LeaderAndIsrRequestPartitionState> partitionStates() {
            return this.partitionStates;
        }

        public LeaderAndIsrRequestTopicState setName(String v) {
            this.name = v;
            return this;
        }

        public LeaderAndIsrRequestTopicState setPartitionStates(List<LeaderAndIsrRequestPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }
}

