/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class InitProducerIdResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private long producerId;
    private short producerEpoch;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public InitProducerIdResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public InitProducerIdResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public InitProducerIdResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.producerId = -1L;
        this.producerEpoch = 0;
    }

    @Override
    public short apiKey() {
        return 22;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        this.errorCode = readable.readShort();
        this.producerId = readable.readLong();
        this.producerEpoch = readable.readShort();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeShort(this.errorCode);
        writable.writeLong(this.producerId);
        writable.writeShort(this.producerEpoch);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 2;
        size += 8;
        return size += 2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitProducerIdResponseData)) {
            return false;
        }
        InitProducerIdResponseData other = (InitProducerIdResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        return this.producerEpoch == other.producerEpoch;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        return hashCode;
    }

    public String toString() {
        return "InitProducerIdResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public InitProducerIdResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public InitProducerIdResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public InitProducerIdResponseData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public InitProducerIdResponseData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("producer_id", Type.INT64, "The current producer id."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer id."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

