/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class HeartbeatRequestData
implements ApiMessage {
    private String groupId;
    private int generationId;
    private String memberId;
    private String groupInstanceId;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public HeartbeatRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public HeartbeatRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public HeartbeatRequestData() {
        this.groupId = "";
        this.generationId = 0;
        this.memberId = "";
        this.groupInstanceId = null;
    }

    @Override
    public short apiKey() {
        return 12;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        this.generationId = readable.readInt();
        this.memberId = readable.readNullableString();
        this.groupInstanceId = version >= 3 ? readable.readNullableString() : null;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        writable.writeInt(this.generationId);
        writable.writeString(this.memberId);
        if (version >= 3) {
            writable.writeNullableString(this.groupInstanceId);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        this.generationId = struct.getInt("generation_id");
        this.memberId = struct.getString("member_id");
        this.groupInstanceId = version >= 3 ? struct.getString("group_instance_id") : null;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("generation_id", (Object)this.generationId);
        struct.set("member_id", (Object)this.memberId);
        if (version >= 3) {
            struct.set("group_instance_id", (Object)this.groupInstanceId);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.groupId);
        size += 4;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.memberId);
        if (version >= 3) {
            size += 2;
            if (this.groupInstanceId != null) {
                size += MessageUtil.serializedUtf8Length(this.groupInstanceId);
            }
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeartbeatRequestData)) {
            return false;
        }
        HeartbeatRequestData other = (HeartbeatRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        return !(this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.generationId;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
        return hashCode;
    }

    public String toString() {
        return "HeartbeatRequestData(groupId='" + this.groupId + "', generationId=" + this.generationId + ", memberId='" + this.memberId + "', groupInstanceId='" + this.groupInstanceId + "')";
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public String groupInstanceId() {
        return this.groupInstanceId;
    }

    public HeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public HeartbeatRequestData setGenerationId(int v) {
        this.generationId = v;
        return this;
    }

    public HeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public HeartbeatRequestData setGroupInstanceId(String v) {
        this.groupInstanceId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID.")));
        SCHEMA_3 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("generation_id", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID."), new Field("group_instance_id", Type.NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }
}

