/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class ElectPreferredLeadersResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<ReplicaElectionResult> replicaElectionResults;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("replica_election_results", new ArrayOf(ReplicaElectionResult.SCHEMA_0), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public ElectPreferredLeadersResponseData(Readable readable, short version) {
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>();
        this.read(readable, version);
    }

    public ElectPreferredLeadersResponseData(Struct struct, short version) {
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>();
        this.fromStruct(struct, version);
    }

    public ElectPreferredLeadersResponseData() {
        this.throttleTimeMs = 0;
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>();
    }

    @Override
    public short apiKey() {
        return 43;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.replicaElectionResults = null;
        } else {
            this.replicaElectionResults.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.replicaElectionResults.add(new ReplicaElectionResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.replicaElectionResults.size());
        for (ReplicaElectionResult element : this.replicaElectionResults) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("replica_election_results");
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.replicaElectionResults.add(new ReplicaElectionResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.replicaElectionResults.size()];
        int i = 0;
        for (ReplicaElectionResult element : this.replicaElectionResults) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("replica_election_results", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (ReplicaElectionResult element : this.replicaElectionResults) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElectPreferredLeadersResponseData)) {
            return false;
        }
        ElectPreferredLeadersResponseData other = (ElectPreferredLeadersResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.replicaElectionResults == null ? other.replicaElectionResults != null : !this.replicaElectionResults.equals(other.replicaElectionResults));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.replicaElectionResults == null ? 0 : this.replicaElectionResults.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ElectPreferredLeadersResponseData(throttleTimeMs=" + this.throttleTimeMs + ", replicaElectionResults=" + MessageUtil.deepToString(this.replicaElectionResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<ReplicaElectionResult> replicaElectionResults() {
        return this.replicaElectionResults;
    }

    public ElectPreferredLeadersResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ElectPreferredLeadersResponseData setReplicaElectionResults(List<ReplicaElectionResult> v) {
        this.replicaElectionResults = v;
        return this;
    }

    public static class PartitionResult
    implements Message {
        private int partitionId;
        private short errorCode;
        private String errorMessage;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_id", Type.INT32, "The partition id"), new Field("error_code", Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The result message, or null if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public PartitionResult(Readable readable, short version) {
            this.read(readable, version);
        }

        public PartitionResult(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public PartitionResult() {
            this.partitionId = 0;
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionId = readable.readInt();
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionId);
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionId = struct.getInt("partition_id");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_id", (Object)this.partitionId);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            size += 2;
            if (this.errorMessage != null) {
                size += MessageUtil.serializedUtf8Length(this.errorMessage);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionResult)) {
                return false;
            }
            PartitionResult other = (PartitionResult)obj;
            if (this.partitionId != other.partitionId) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return !(this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionId;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        public String toString() {
            return "PartitionResult(partitionId=" + this.partitionId + ", errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "')";
        }

        public int partitionId() {
            return this.partitionId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public PartitionResult setPartitionId(int v) {
            this.partitionId = v;
            return this;
        }

        public PartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }
    }

    public static class ReplicaElectionResult
    implements Message {
        private String topic;
        private List<PartitionResult> partitionResult;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name"), new Field("partition_result", new ArrayOf(PartitionResult.SCHEMA_0), "The results for each partition"));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public ReplicaElectionResult(Readable readable, short version) {
            this.partitionResult = new ArrayList<PartitionResult>();
            this.read(readable, version);
        }

        public ReplicaElectionResult(Struct struct, short version) {
            this.partitionResult = new ArrayList<PartitionResult>();
            this.fromStruct(struct, version);
        }

        public ReplicaElectionResult() {
            this.topic = "";
            this.partitionResult = new ArrayList<PartitionResult>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.topic = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionResult = null;
            } else {
                this.partitionResult.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionResult.add(new PartitionResult(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.topic);
            writable.writeInt(this.partitionResult.size());
            for (PartitionResult element : this.partitionResult) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.topic = struct.getString("topic");
            Object[] nestedObjects = struct.getArray("partition_result");
            this.partitionResult = new ArrayList<PartitionResult>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionResult.add(new PartitionResult((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic", (Object)this.topic);
            Struct[] nestedObjects = new Struct[this.partitionResult.size()];
            int i = 0;
            for (PartitionResult element : this.partitionResult) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partition_result", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topic);
            size += 4;
            for (PartitionResult element : this.partitionResult) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaElectionResult)) {
                return false;
            }
            ReplicaElectionResult other = (ReplicaElectionResult)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return !(this.partitionResult == null ? other.partitionResult != null : !this.partitionResult.equals(other.partitionResult));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionResult == null ? 0 : this.partitionResult.hashCode());
            return hashCode;
        }

        public String toString() {
            return "ReplicaElectionResult(topic='" + this.topic + "', partitionResult=" + MessageUtil.deepToString(this.partitionResult.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<PartitionResult> partitionResult() {
            return this.partitionResult;
        }

        public ReplicaElectionResult setTopic(String v) {
            this.topic = v;
            return this;
        }

        public ReplicaElectionResult setPartitionResult(List<PartitionResult> v) {
            this.partitionResult = v;
            return this;
        }
    }
}

