/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class DescribeLogDirsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<DescribeLogDirsResult> results;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DescribeLogDirsResponseData(Readable readable, short version) {
        this.results = new ArrayList<DescribeLogDirsResult>();
        this.read(readable, version);
    }

    public DescribeLogDirsResponseData(Struct struct, short version) {
        this.results = new ArrayList<DescribeLogDirsResult>();
        this.fromStruct(struct, version);
    }

    public DescribeLogDirsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<DescribeLogDirsResult>();
    }

    @Override
    public short apiKey() {
        return 35;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.results = null;
        } else {
            this.results.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.results.add(new DescribeLogDirsResult(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.results.size());
        for (DescribeLogDirsResult element : this.results) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("results");
        this.results = new ArrayList<DescribeLogDirsResult>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.results.add(new DescribeLogDirsResult((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.results.size()];
        int i = 0;
        for (DescribeLogDirsResult element : this.results) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("results", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (DescribeLogDirsResult element : this.results) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeLogDirsResponseData)) {
            return false;
        }
        DescribeLogDirsResponseData other = (DescribeLogDirsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeLogDirsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DescribeLogDirsResult> results() {
        return this.results;
    }

    public DescribeLogDirsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeLogDirsResponseData setResults(List<DescribeLogDirsResult> v) {
        this.results = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new ArrayOf(DescribeLogDirsResult.SCHEMA_0), "The log directories."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DescribeLogDirsPartition
    implements Message {
        private int partitionIndex;
        private long partitionSize;
        private long offsetLag;
        private boolean isFutureKey;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribeLogDirsPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public DescribeLogDirsPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DescribeLogDirsPartition() {
            this.partitionIndex = 0;
            this.partitionSize = 0L;
            this.offsetLag = 0L;
            this.isFutureKey = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.partitionSize = readable.readLong();
            this.offsetLag = readable.readLong();
            this.isFutureKey = readable.readByte() != 0;
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeLong(this.partitionSize);
            writable.writeLong(this.offsetLag);
            writable.writeByte(this.isFutureKey ? (byte)1 : 0);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.partitionSize = struct.getLong("partition_size");
            this.offsetLag = struct.getLong("offset_lag");
            this.isFutureKey = struct.getBoolean("is_future_key");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("partition_size", (Object)this.partitionSize);
            struct.set("offset_lag", (Object)this.offsetLag);
            struct.set("is_future_key", (Object)this.isFutureKey);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 8;
            size += 8;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsPartition)) {
                return false;
            }
            DescribeLogDirsPartition other = (DescribeLogDirsPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.partitionSize != other.partitionSize) {
                return false;
            }
            if (this.offsetLag != other.offsetLag) {
                return false;
            }
            return this.isFutureKey == other.isFutureKey;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.partitionSize >> 32) ^ (int)this.partitionSize);
            hashCode = 31 * hashCode + ((int)(this.offsetLag >> 32) ^ (int)this.offsetLag);
            hashCode = 31 * hashCode + (this.isFutureKey ? 1231 : 1237);
            return hashCode;
        }

        public String toString() {
            return "DescribeLogDirsPartition(partitionIndex=" + this.partitionIndex + ", partitionSize=" + this.partitionSize + ", offsetLag=" + this.offsetLag + ", isFutureKey=" + (this.isFutureKey ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long partitionSize() {
            return this.partitionSize;
        }

        public long offsetLag() {
            return this.offsetLag;
        }

        public boolean isFutureKey() {
            return this.isFutureKey;
        }

        public DescribeLogDirsPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DescribeLogDirsPartition setPartitionSize(long v) {
            this.partitionSize = v;
            return this;
        }

        public DescribeLogDirsPartition setOffsetLag(long v) {
            this.offsetLag = v;
            return this;
        }

        public DescribeLogDirsPartition setIsFutureKey(boolean v) {
            this.isFutureKey = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("partition_size", Type.INT64, "The size of the log segments in this partition in bytes."), new Field("offset_lag", Type.INT64, "The lag of the log's LEO w.r.t. partition's HW (if it is the current log for the partition) or current replica's LEO (if it is the future log for the partition)"), new Field("is_future_key", Type.BOOLEAN, "True if this log is created by AlterReplicaLogDirsRequest and will replace the current log of the replica in the future."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DescribeLogDirsTopic
    implements Message {
        private String name;
        private List<DescribeLogDirsPartition> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribeLogDirsTopic(Readable readable, short version) {
            this.partitions = new ArrayList<DescribeLogDirsPartition>();
            this.read(readable, version);
        }

        public DescribeLogDirsTopic(Struct struct, short version) {
            this.partitions = new ArrayList<DescribeLogDirsPartition>();
            this.fromStruct(struct, version);
        }

        public DescribeLogDirsTopic() {
            this.name = "";
            this.partitions = new ArrayList<DescribeLogDirsPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new DescribeLogDirsPartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (DescribeLogDirsPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<DescribeLogDirsPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new DescribeLogDirsPartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (DescribeLogDirsPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (DescribeLogDirsPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsTopic)) {
                return false;
            }
            DescribeLogDirsTopic other = (DescribeLogDirsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeLogDirsTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<DescribeLogDirsPartition> partitions() {
            return this.partitions;
        }

        public DescribeLogDirsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeLogDirsTopic setPartitions(List<DescribeLogDirsPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(DescribeLogDirsPartition.SCHEMA_0), ""));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DescribeLogDirsResult
    implements Message {
        private short errorCode;
        private String logDir;
        private List<DescribeLogDirsTopic> topics;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribeLogDirsResult(Readable readable, short version) {
            this.topics = new ArrayList<DescribeLogDirsTopic>();
            this.read(readable, version);
        }

        public DescribeLogDirsResult(Struct struct, short version) {
            this.topics = new ArrayList<DescribeLogDirsTopic>();
            this.fromStruct(struct, version);
        }

        public DescribeLogDirsResult() {
            this.errorCode = 0;
            this.logDir = "";
            this.topics = new ArrayList<DescribeLogDirsTopic>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.logDir = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                this.topics.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.topics.add(new DescribeLogDirsTopic(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeString(this.logDir);
            writable.writeInt(this.topics.size());
            for (DescribeLogDirsTopic element : this.topics) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.logDir = struct.getString("log_dir");
            Object[] nestedObjects = struct.getArray("topics");
            this.topics = new ArrayList<DescribeLogDirsTopic>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new DescribeLogDirsTopic((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("log_dir", (Object)this.logDir);
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (DescribeLogDirsTopic element : this.topics) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.logDir);
            size += 4;
            for (DescribeLogDirsTopic element : this.topics) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeLogDirsResult)) {
                return false;
            }
            DescribeLogDirsResult other = (DescribeLogDirsResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.logDir == null ? other.logDir != null : !this.logDir.equals(other.logDir)) {
                return false;
            }
            return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.logDir == null ? 0 : this.logDir.hashCode());
            hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeLogDirsResult(errorCode=" + this.errorCode + ", logDir='" + this.logDir + "', topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String logDir() {
            return this.logDir;
        }

        public List<DescribeLogDirsTopic> topics() {
            return this.topics;
        }

        public DescribeLogDirsResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DescribeLogDirsResult setLogDir(String v) {
            this.logDir = v;
            return this;
        }

        public DescribeLogDirsResult setTopics(List<DescribeLogDirsTopic> v) {
            this.topics = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("log_dir", Type.STRING, "The absolute log directory path."), new Field("topics", new ArrayOf(DescribeLogDirsTopic.SCHEMA_0), "Each topic."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

