/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.utils.Bytes;

public class DescribeDelegationTokenResponseData
implements ApiMessage {
    private short errorCode;
    private List<DescribedDelegationToken> tokens;
    private int throttleTimeMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DescribeDelegationTokenResponseData(Readable readable, short version) {
        this.tokens = new ArrayList<DescribedDelegationToken>();
        this.read(readable, version);
    }

    public DescribeDelegationTokenResponseData(Struct struct, short version) {
        this.tokens = new ArrayList<DescribedDelegationToken>();
        this.fromStruct(struct, version);
    }

    public DescribeDelegationTokenResponseData() {
        this.errorCode = 0;
        this.tokens = new ArrayList<DescribedDelegationToken>();
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 41;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.tokens = null;
        } else {
            this.tokens.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.tokens.add(new DescribedDelegationToken(readable, version));
            }
        }
        this.throttleTimeMs = readable.readInt();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeInt(this.tokens.size());
        for (DescribedDelegationToken element : this.tokens) {
            element.write(writable, version);
        }
        writable.writeInt(this.throttleTimeMs);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        Object[] nestedObjects = struct.getArray("tokens");
        this.tokens = new ArrayList<DescribedDelegationToken>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.tokens.add(new DescribedDelegationToken((Struct)nestedObject, version));
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] nestedObjects = new Struct[this.tokens.size()];
        int i = 0;
        for (DescribedDelegationToken element : this.tokens) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("tokens", (Object)nestedObjects);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 4;
        for (DescribedDelegationToken element : this.tokens) {
            size += element.size(version);
        }
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeDelegationTokenResponseData)) {
            return false;
        }
        DescribeDelegationTokenResponseData other = (DescribeDelegationTokenResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.tokens == null ? other.tokens != null : !this.tokens.equals(other.tokens)) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.tokens == null ? 0 : this.tokens.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public String toString() {
        return "DescribeDelegationTokenResponseData(errorCode=" + this.errorCode + ", tokens=" + MessageUtil.deepToString(this.tokens.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<DescribedDelegationToken> tokens() {
        return this.tokens;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DescribeDelegationTokenResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeDelegationTokenResponseData setTokens(List<DescribedDelegationToken> v) {
        this.tokens = v;
        return this;
    }

    public DescribeDelegationTokenResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("tokens", new ArrayOf(DescribedDelegationToken.SCHEMA_0), "The tokens."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DescribedDelegationTokenRenewer
    implements Message {
        private String principalType;
        private String principalName;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribedDelegationTokenRenewer(Readable readable, short version) {
            this.read(readable, version);
        }

        public DescribedDelegationTokenRenewer(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DescribedDelegationTokenRenewer() {
            this.principalType = "";
            this.principalName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.principalType = readable.readNullableString();
            this.principalName = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.principalType);
            writable.writeString(this.principalName);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.principalType = struct.getString("principal_type");
            this.principalName = struct.getString("principal_name");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("principal_type", (Object)this.principalType);
            struct.set("principal_name", (Object)this.principalName);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principalType);
            size += 2;
            return size += MessageUtil.serializedUtf8Length(this.principalName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedDelegationTokenRenewer)) {
                return false;
            }
            DescribedDelegationTokenRenewer other = (DescribedDelegationTokenRenewer)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            return !(this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribedDelegationTokenRenewer(principalType='" + this.principalType + "', principalName='" + this.principalName + "')";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        public DescribedDelegationTokenRenewer setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribedDelegationTokenRenewer setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The renewer principal type"), new Field("principal_name", Type.STRING, "The renewer principal name"));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DescribedDelegationToken
    implements Message {
        private String principalType;
        private String principalName;
        private long issueTimestamp;
        private long expiryTimestamp;
        private long maxTimestamp;
        private String tokenId;
        private byte[] hmac;
        private List<DescribedDelegationTokenRenewer> renewers;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribedDelegationToken(Readable readable, short version) {
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>();
            this.read(readable, version);
        }

        public DescribedDelegationToken(Struct struct, short version) {
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>();
            this.fromStruct(struct, version);
        }

        public DescribedDelegationToken() {
            this.principalType = "";
            this.principalName = "";
            this.issueTimestamp = 0L;
            this.expiryTimestamp = 0L;
            this.maxTimestamp = 0L;
            this.tokenId = "";
            this.hmac = Bytes.EMPTY;
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.principalType = readable.readNullableString();
            this.principalName = readable.readNullableString();
            this.issueTimestamp = readable.readLong();
            this.expiryTimestamp = readable.readLong();
            this.maxTimestamp = readable.readLong();
            this.tokenId = readable.readNullableString();
            this.hmac = readable.readNullableBytes();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.renewers = null;
            } else {
                this.renewers.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.renewers.add(new DescribedDelegationTokenRenewer(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.principalType);
            writable.writeString(this.principalName);
            writable.writeLong(this.issueTimestamp);
            writable.writeLong(this.expiryTimestamp);
            writable.writeLong(this.maxTimestamp);
            writable.writeString(this.tokenId);
            writable.writeBytes(this.hmac);
            writable.writeInt(this.renewers.size());
            for (DescribedDelegationTokenRenewer element : this.renewers) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.principalType = struct.getString("principal_type");
            this.principalName = struct.getString("principal_name");
            this.issueTimestamp = struct.getLong("issue_timestamp");
            this.expiryTimestamp = struct.getLong("expiry_timestamp");
            this.maxTimestamp = struct.getLong("max_timestamp");
            this.tokenId = struct.getString("token_id");
            this.hmac = struct.getByteArray("hmac");
            Object[] nestedObjects = struct.getArray("renewers");
            this.renewers = new ArrayList<DescribedDelegationTokenRenewer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.renewers.add(new DescribedDelegationTokenRenewer((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("principal_type", (Object)this.principalType);
            struct.set("principal_name", (Object)this.principalName);
            struct.set("issue_timestamp", (Object)this.issueTimestamp);
            struct.set("expiry_timestamp", (Object)this.expiryTimestamp);
            struct.set("max_timestamp", (Object)this.maxTimestamp);
            struct.set("token_id", (Object)this.tokenId);
            struct.setByteArray("hmac", this.hmac);
            Struct[] nestedObjects = new Struct[this.renewers.size()];
            int i = 0;
            for (DescribedDelegationTokenRenewer element : this.renewers) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("renewers", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principalType);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principalName);
            size += 8;
            size += 8;
            size += 8;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.tokenId);
            size += 4;
            size += this.hmac.length;
            size += 4;
            for (DescribedDelegationTokenRenewer element : this.renewers) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribedDelegationToken)) {
                return false;
            }
            DescribedDelegationToken other = (DescribedDelegationToken)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            if (this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName)) {
                return false;
            }
            if (this.issueTimestamp != other.issueTimestamp) {
                return false;
            }
            if (this.expiryTimestamp != other.expiryTimestamp) {
                return false;
            }
            if (this.maxTimestamp != other.maxTimestamp) {
                return false;
            }
            if (this.tokenId == null ? other.tokenId != null : !this.tokenId.equals(other.tokenId)) {
                return false;
            }
            if (!Arrays.equals(this.hmac, other.hmac)) {
                return false;
            }
            return !(this.renewers == null ? other.renewers != null : !this.renewers.equals(other.renewers));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            hashCode = 31 * hashCode + ((int)(this.issueTimestamp >> 32) ^ (int)this.issueTimestamp);
            hashCode = 31 * hashCode + ((int)(this.expiryTimestamp >> 32) ^ (int)this.expiryTimestamp);
            hashCode = 31 * hashCode + ((int)(this.maxTimestamp >> 32) ^ (int)this.maxTimestamp);
            hashCode = 31 * hashCode + (this.tokenId == null ? 0 : this.tokenId.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
            hashCode = 31 * hashCode + (this.renewers == null ? 0 : this.renewers.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribedDelegationToken(principalType='" + this.principalType + "', principalName='" + this.principalName + "', issueTimestamp=" + this.issueTimestamp + ", expiryTimestamp=" + this.expiryTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", tokenId='" + this.tokenId + "', hmac=" + Arrays.toString(this.hmac) + ", renewers=" + MessageUtil.deepToString(this.renewers.iterator()) + ")";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        public long issueTimestamp() {
            return this.issueTimestamp;
        }

        public long expiryTimestamp() {
            return this.expiryTimestamp;
        }

        public long maxTimestamp() {
            return this.maxTimestamp;
        }

        public String tokenId() {
            return this.tokenId;
        }

        public byte[] hmac() {
            return this.hmac;
        }

        public List<DescribedDelegationTokenRenewer> renewers() {
            return this.renewers;
        }

        public DescribedDelegationToken setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribedDelegationToken setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        public DescribedDelegationToken setIssueTimestamp(long v) {
            this.issueTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setExpiryTimestamp(long v) {
            this.expiryTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setMaxTimestamp(long v) {
            this.maxTimestamp = v;
            return this;
        }

        public DescribedDelegationToken setTokenId(String v) {
            this.tokenId = v;
            return this;
        }

        public DescribedDelegationToken setHmac(byte[] v) {
            this.hmac = v;
            return this;
        }

        public DescribedDelegationToken setRenewers(List<DescribedDelegationTokenRenewer> v) {
            this.renewers = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The token principal type."), new Field("principal_name", Type.STRING, "The token principal name."), new Field("issue_timestamp", Type.INT64, "The token issue timestamp in milliseconds."), new Field("expiry_timestamp", Type.INT64, "The token expiry timestamp in milliseconds."), new Field("max_timestamp", Type.INT64, "The token maximum timestamp length in milliseconds."), new Field("token_id", Type.STRING, "The token ID."), new Field("hmac", Type.BYTES, "The token HMAC."), new Field("renewers", new ArrayOf(DescribedDelegationTokenRenewer.SCHEMA_0), "Those who are able to renew this token before it expires."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

