/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class DescribeDelegationTokenRequestData
implements ApiMessage {
    private List<DescribeDelegationTokenOwner> owners = new ArrayList<DescribeDelegationTokenOwner>();
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DescribeDelegationTokenRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DescribeDelegationTokenRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DescribeDelegationTokenRequestData() {
    }

    @Override
    public short apiKey() {
        return 41;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.owners = null;
        } else {
            this.owners.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.owners.add(new DescribeDelegationTokenOwner(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (this.owners == null) {
            writable.writeInt(-1);
        } else {
            writable.writeInt(this.owners.size());
            for (DescribeDelegationTokenOwner element : this.owners) {
                element.write(writable, version);
            }
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("owners");
        if (nestedObjects == null) {
            this.owners = null;
        } else {
            this.owners = new ArrayList<DescribeDelegationTokenOwner>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.owners.add(new DescribeDelegationTokenOwner((Struct)nestedObject, version));
            }
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (this.owners == null) {
            struct.set("owners", null);
        } else {
            Struct[] nestedObjects = new Struct[this.owners.size()];
            int i = 0;
            for (DescribeDelegationTokenOwner element : this.owners) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("owners", (Object)nestedObjects);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (this.owners == null) {
            size += 4;
        } else {
            size += 4;
            for (DescribeDelegationTokenOwner element : this.owners) {
                size += element.size(version);
            }
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeDelegationTokenRequestData)) {
            return false;
        }
        DescribeDelegationTokenRequestData other = (DescribeDelegationTokenRequestData)obj;
        return !(this.owners == null ? other.owners != null : !this.owners.equals(other.owners));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.owners == null ? 0 : this.owners.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeDelegationTokenRequestData(owners=" + (this.owners == null ? "null" : MessageUtil.deepToString(this.owners.iterator())) + ")";
    }

    public List<DescribeDelegationTokenOwner> owners() {
        return this.owners;
    }

    public DescribeDelegationTokenRequestData setOwners(List<DescribeDelegationTokenOwner> v) {
        this.owners = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("owners", ArrayOf.nullable(DescribeDelegationTokenOwner.SCHEMA_0), "Each owner that we want to describe delegation tokens for, or null to describe all tokens."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DescribeDelegationTokenOwner
    implements Message {
        private String principalType;
        private String principalName;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DescribeDelegationTokenOwner(Readable readable, short version) {
            this.read(readable, version);
        }

        public DescribeDelegationTokenOwner(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DescribeDelegationTokenOwner() {
            this.principalType = "";
            this.principalName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.principalType = readable.readNullableString();
            this.principalName = readable.readNullableString();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.principalType);
            writable.writeString(this.principalName);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.principalType = struct.getString("principal_type");
            this.principalName = struct.getString("principal_name");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("principal_type", (Object)this.principalType);
            struct.set("principal_name", (Object)this.principalName);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principalType);
            size += 2;
            return size += MessageUtil.serializedUtf8Length(this.principalName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeDelegationTokenOwner)) {
                return false;
            }
            DescribeDelegationTokenOwner other = (DescribeDelegationTokenOwner)obj;
            if (this.principalType == null ? other.principalType != null : !this.principalType.equals(other.principalType)) {
                return false;
            }
            return !(this.principalName == null ? other.principalName != null : !this.principalName.equals(other.principalName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principalType == null ? 0 : this.principalType.hashCode());
            hashCode = 31 * hashCode + (this.principalName == null ? 0 : this.principalName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeDelegationTokenOwner(principalType='" + this.principalType + "', principalName='" + this.principalName + "')";
        }

        public String principalType() {
            return this.principalType;
        }

        public String principalName() {
            return this.principalName;
        }

        public DescribeDelegationTokenOwner setPrincipalType(String v) {
            this.principalType = v;
            return this;
        }

        public DescribeDelegationTokenOwner setPrincipalName(String v) {
            this.principalName = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal_type", Type.STRING, "The owner principal type."), new Field("principal_name", Type.STRING, "The owner principal name."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

