/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class DescribeConfigsRequestData
implements ApiMessage {
    private List<DescribeConfigsResource> resources = new ArrayList<DescribeConfigsResource>();
    private boolean includeSynoyms;
    public static final Schema SCHEMA_0 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DescribeConfigsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DescribeConfigsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DescribeConfigsRequestData() {
        this.includeSynoyms = false;
    }

    @Override
    public short apiKey() {
        return 32;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.resources = null;
        } else {
            this.resources.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.resources.add(new DescribeConfigsResource(readable, version));
            }
        }
        this.includeSynoyms = version >= 1 ? readable.readByte() != 0 : false;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.resources.size());
        for (DescribeConfigsResource element : this.resources) {
            element.write(writable, version);
        }
        if (version >= 1) {
            writable.writeByte(this.includeSynoyms ? (byte)1 : 0);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("resources");
        this.resources = new ArrayList<DescribeConfigsResource>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.resources.add(new DescribeConfigsResource((Struct)nestedObject, version));
        }
        this.includeSynoyms = version >= 1 ? struct.getBoolean("include_synoyms") : false;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (DescribeConfigsResource element : this.resources) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("resources", (Object)nestedObjects);
        if (version >= 1) {
            struct.set("include_synoyms", (Object)this.includeSynoyms);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (DescribeConfigsResource element : this.resources) {
            size += element.size(version);
        }
        if (version >= 1) {
            ++size;
        } else if (this.includeSynoyms) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeSynoyms at version " + version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeConfigsRequestData)) {
            return false;
        }
        DescribeConfigsRequestData other = (DescribeConfigsRequestData)obj;
        if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
            return false;
        }
        return this.includeSynoyms == other.includeSynoyms;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        hashCode = 31 * hashCode + (this.includeSynoyms ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "DescribeConfigsRequestData(resources=" + MessageUtil.deepToString(this.resources.iterator()) + ", includeSynoyms=" + (this.includeSynoyms ? "true" : "false") + ")";
    }

    public List<DescribeConfigsResource> resources() {
        return this.resources;
    }

    public boolean includeSynoyms() {
        return this.includeSynoyms;
    }

    public DescribeConfigsRequestData setResources(List<DescribeConfigsResource> v) {
        this.resources = v;
        return this;
    }

    public DescribeConfigsRequestData setIncludeSynoyms(boolean v) {
        this.includeSynoyms = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."), new Field("include_synoyms", Type.BOOLEAN, "True if we should include all synonyms."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DescribeConfigsResource
    implements Message {
        private byte resourceType;
        private String resourceName;
        private List<String> configurationKeys;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribeConfigsResource(Readable readable, short version) {
            this.configurationKeys = new ArrayList<String>();
            this.read(readable, version);
        }

        public DescribeConfigsResource(Struct struct, short version) {
            this.configurationKeys = new ArrayList<String>();
            this.fromStruct(struct, version);
        }

        public DescribeConfigsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.configurationKeys = new ArrayList<String>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.resourceType = readable.readByte();
            this.resourceName = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.configurationKeys = null;
            } else {
                this.configurationKeys.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.configurationKeys.add(readable.readNullableString());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeByte(this.resourceType);
            writable.writeString(this.resourceName);
            if (this.configurationKeys == null) {
                writable.writeInt(-1);
            } else {
                writable.writeInt(this.configurationKeys.size());
                for (String element : this.configurationKeys) {
                    writable.writeString(element);
                }
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            Object[] nestedObjects = struct.getArray("configuration_keys");
            if (nestedObjects == null) {
                this.configurationKeys = null;
            } else {
                this.configurationKeys = new ArrayList<String>(nestedObjects.length);
                for (Object nestedObject : nestedObjects) {
                    this.configurationKeys.add((String)nestedObject);
                }
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            if (this.configurationKeys == null) {
                struct.set("configuration_keys", null);
            } else {
                String[] nestedObjects = new String[this.configurationKeys.size()];
                int i = 0;
                for (String element : this.configurationKeys) {
                    nestedObjects[i++] = element;
                }
                struct.set("configuration_keys", (Object)nestedObjects);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            ++size;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.resourceName);
            if (this.configurationKeys == null) {
                size += 4;
            } else {
                size += 4;
                for (String element : this.configurationKeys) {
                    size += 2;
                    size += MessageUtil.serializedUtf8Length(element);
                }
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeConfigsResource)) {
                return false;
            }
            DescribeConfigsResource other = (DescribeConfigsResource)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            return !(this.configurationKeys == null ? other.configurationKeys != null : !this.configurationKeys.equals(other.configurationKeys));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + (this.configurationKeys == null ? 0 : this.configurationKeys.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeConfigsResource(resourceType=" + this.resourceType + ", resourceName='" + this.resourceName + "', configurationKeys=" + (this.configurationKeys == null ? "null" : MessageUtil.deepToString(this.configurationKeys.iterator())) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public List<String> configurationKeys() {
            return this.configurationKeys;
        }

        public DescribeConfigsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DescribeConfigsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DescribeConfigsResource setConfigurationKeys(List<String> v) {
            this.configurationKeys = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configuration_keys", ArrayOf.nullable(Type.STRING), "The configuration keys to list, or null to list all configuration keys.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

