/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafkaesque.common.utils.ImplicitLinkedHashMultiCollection;

public class ApiVersionsResponseData
implements ApiMessage {
    private short errorCode;
    private ApiVersionsResponseKeyCollection apiKeys;
    private int throttleTimeMs;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("api_keys", new ArrayOf(ApiVersionsResponseKey.SCHEMA_0), "The APIs supported by the broker."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public ApiVersionsResponseData(Readable readable, short version) {
        this.apiKeys = new ApiVersionsResponseKeyCollection(0);
        this.read(readable, version);
    }

    public ApiVersionsResponseData(Struct struct, short version) {
        this.apiKeys = new ApiVersionsResponseKeyCollection(0);
        this.fromStruct(struct, version);
    }

    public ApiVersionsResponseData() {
        this.errorCode = 0;
        this.apiKeys = new ApiVersionsResponseKeyCollection(0);
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 18;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.apiKeys = null;
        } else {
            this.apiKeys.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.apiKeys.add(new ApiVersionsResponseKey(readable, version));
            }
        }
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeInt(this.apiKeys.size());
        for (ApiVersionsResponseKey element : this.apiKeys) {
            element.write(writable, version);
        }
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        Object[] nestedObjects = struct.getArray("api_keys");
        this.apiKeys = new ApiVersionsResponseKeyCollection(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.apiKeys.add(new ApiVersionsResponseKey((Struct)nestedObject, version));
        }
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] nestedObjects = new Struct[this.apiKeys.size()];
        int i = 0;
        for (ApiVersionsResponseKey element : this.apiKeys) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("api_keys", (Object)nestedObjects);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 4;
        for (ApiVersionsResponseKey element : this.apiKeys) {
            size += element.size(version);
        }
        if (version >= 1) {
            size += 4;
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ApiVersionsResponseData)) {
            return false;
        }
        ApiVersionsResponseData other = (ApiVersionsResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.apiKeys == null ? other.apiKeys != null : !this.apiKeys.equals(other.apiKeys)) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.apiKeys == null ? 0 : this.apiKeys.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public String toString() {
        return "ApiVersionsResponseData(errorCode=" + this.errorCode + ", apiKeys=" + MessageUtil.deepToString(this.apiKeys.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public ApiVersionsResponseKeyCollection apiKeys() {
        return this.apiKeys;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public ApiVersionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ApiVersionsResponseData setApiKeys(ApiVersionsResponseKeyCollection v) {
        this.apiKeys = v;
        return this;
    }

    public ApiVersionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("api_keys", new ArrayOf(ApiVersionsResponseKey.SCHEMA_0), "The APIs supported by the broker."), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class ApiVersionsResponseKeyCollection
    extends ImplicitLinkedHashMultiCollection<ApiVersionsResponseKey> {
        public ApiVersionsResponseKeyCollection() {
        }

        public ApiVersionsResponseKeyCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public ApiVersionsResponseKeyCollection(Iterator<ApiVersionsResponseKey> iterator) {
            super(iterator);
        }

        @Override
        public ApiVersionsResponseKey find(short index) {
            ApiVersionsResponseKey key = new ApiVersionsResponseKey();
            key.setIndex(index);
            return this.find(key);
        }

        @Override
        public List<ApiVersionsResponseKey> findAll(short index) {
            ApiVersionsResponseKey key = new ApiVersionsResponseKey();
            key.setIndex(index);
            return this.findAll(key);
        }
    }

    public static class ApiVersionsResponseKey
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private short index;
        private short minVersion;
        private short maxVersion;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public ApiVersionsResponseKey(Readable readable, short version) {
            this.read(readable, version);
        }

        public ApiVersionsResponseKey(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public ApiVersionsResponseKey() {
            this.index = 0;
            this.minVersion = 0;
            this.maxVersion = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.index = readable.readShort();
            this.minVersion = readable.readShort();
            this.maxVersion = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeShort(this.index);
            writable.writeShort(this.minVersion);
            writable.writeShort(this.maxVersion);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.index = struct.getShort("index");
            this.minVersion = struct.getShort("min_version");
            this.maxVersion = struct.getShort("max_version");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("index", (Object)this.index);
            struct.set("min_version", (Object)this.minVersion);
            struct.set("max_version", (Object)this.maxVersion);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ApiVersionsResponseKey)) {
                return false;
            }
            ApiVersionsResponseKey other = (ApiVersionsResponseKey)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.index;
            return hashCode;
        }

        public String toString() {
            return "ApiVersionsResponseKey(index=" + this.index + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ")";
        }

        public short index() {
            return this.index;
        }

        public short minVersion() {
            return this.minVersion;
        }

        public short maxVersion() {
            return this.maxVersion;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public ApiVersionsResponseKey setIndex(short v) {
            this.index = v;
            return this;
        }

        public ApiVersionsResponseKey setMinVersion(short v) {
            this.minVersion = v;
            return this;
        }

        public ApiVersionsResponseKey setMaxVersion(short v) {
            this.maxVersion = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("index", Type.INT16, "The API index."), new Field("min_version", Type.INT16, "The minimum supported version, inclusive."), new Field("max_version", Type.INT16, "The maximum supported version, inclusive.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

