/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;

public class AddOffsetsToTxnResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AddOffsetsToTxnResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public AddOffsetsToTxnResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public AddOffsetsToTxnResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
    }

    @Override
    public short apiKey() {
        return 25;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        this.errorCode = readable.readShort();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeShort(this.errorCode);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        return size += 2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddOffsetsToTxnResponseData)) {
            return false;
        }
        AddOffsetsToTxnResponseData other = (AddOffsetsToTxnResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return this.errorCode == other.errorCode;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        return hashCode;
    }

    public String toString() {
        return "AddOffsetsToTxnResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public AddOffsetsToTxnResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AddOffsetsToTxnResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The response error code, or 0 if there was no error."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

