/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients.producer.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafkaesque.clients.ApiVersions;
import org.apache.kafkaesque.clients.ClientRequest;
import org.apache.kafkaesque.clients.ClientResponse;
import org.apache.kafkaesque.clients.KafkaClient;
import org.apache.kafkaesque.clients.Metadata;
import org.apache.kafkaesque.clients.NetworkClientUtils;
import org.apache.kafkaesque.clients.RequestCompletionHandler;
import org.apache.kafkaesque.clients.producer.internals.ProducerBatch;
import org.apache.kafkaesque.clients.producer.internals.ProducerIdAndEpoch;
import org.apache.kafkaesque.clients.producer.internals.ProducerMetadata;
import org.apache.kafkaesque.clients.producer.internals.RecordAccumulator;
import org.apache.kafkaesque.clients.producer.internals.SenderMetricsRegistry;
import org.apache.kafkaesque.clients.producer.internals.TransactionManager;
import org.apache.kafkaesque.common.Cluster;
import org.apache.kafkaesque.common.KafkaException;
import org.apache.kafkaesque.common.MetricName;
import org.apache.kafkaesque.common.Node;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.errors.ApiException;
import org.apache.kafkaesque.common.errors.AuthenticationException;
import org.apache.kafkaesque.common.errors.ClusterAuthorizationException;
import org.apache.kafkaesque.common.errors.InvalidMetadataException;
import org.apache.kafkaesque.common.errors.OutOfOrderSequenceException;
import org.apache.kafkaesque.common.errors.RetriableException;
import org.apache.kafkaesque.common.errors.TimeoutException;
import org.apache.kafkaesque.common.errors.TopicAuthorizationException;
import org.apache.kafkaesque.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.message.InitProducerIdRequestData;
import org.apache.kafkaesque.common.metrics.Sensor;
import org.apache.kafkaesque.common.metrics.stats.Avg;
import org.apache.kafkaesque.common.metrics.stats.Max;
import org.apache.kafkaesque.common.metrics.stats.Meter;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.record.MemoryRecords;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.InitProducerIdRequest;
import org.apache.kafkaesque.common.requests.InitProducerIdResponse;
import org.apache.kafkaesque.common.requests.ProduceRequest;
import org.apache.kafkaesque.common.requests.ProduceResponse;
import org.apache.kafkaesque.common.requests.RequestHeader;
import org.apache.kafkaesque.common.utils.LogContext;
import org.apache.kafkaesque.common.utils.Time;
import org.apache.kafkaesque.common.utils.Utils;
import org.slf4j.Logger;

public class Sender
implements Runnable {
    private final Logger log;
    private final KafkaClient client;
    private final RecordAccumulator accumulator;
    private final ProducerMetadata metadata;
    private final boolean guaranteeMessageOrder;
    private final int maxRequestSize;
    private final short acks;
    private final int retries;
    private final Time time;
    private volatile boolean running;
    private volatile boolean forceClose;
    private final SenderMetrics sensors;
    private final int requestTimeoutMs;
    private final long retryBackoffMs;
    private final ApiVersions apiVersions;
    private final TransactionManager transactionManager;
    private final Map<TopicPartition, List<ProducerBatch>> inFlightBatches;

    public Sender(LogContext logContext, KafkaClient client, ProducerMetadata metadata, RecordAccumulator accumulator, boolean guaranteeMessageOrder, int maxRequestSize, short acks, int retries, SenderMetricsRegistry metricsRegistry, Time time, int requestTimeoutMs, long retryBackoffMs, TransactionManager transactionManager, ApiVersions apiVersions) {
        this.log = logContext.logger(Sender.class);
        this.client = client;
        this.accumulator = accumulator;
        this.metadata = metadata;
        this.guaranteeMessageOrder = guaranteeMessageOrder;
        this.maxRequestSize = maxRequestSize;
        this.running = true;
        this.acks = acks;
        this.retries = retries;
        this.time = time;
        this.sensors = new SenderMetrics(metricsRegistry, metadata, client, time);
        this.requestTimeoutMs = requestTimeoutMs;
        this.retryBackoffMs = retryBackoffMs;
        this.apiVersions = apiVersions;
        this.transactionManager = transactionManager;
        this.inFlightBatches = new HashMap<TopicPartition, List<ProducerBatch>>();
    }

    public List<ProducerBatch> inFlightBatches(TopicPartition tp) {
        return this.inFlightBatches.containsKey(tp) ? this.inFlightBatches.get(tp) : new ArrayList<ProducerBatch>();
    }

    public void maybeRemoveFromInflightBatches(ProducerBatch batch) {
        List<ProducerBatch> batches = this.inFlightBatches.get(batch.topicPartition);
        if (batches != null) {
            batches.remove(batch);
            if (batches.isEmpty()) {
                this.inFlightBatches.remove(batch.topicPartition);
            }
        }
    }

    private List<ProducerBatch> getExpiredInflightBatches(long now) {
        ArrayList<ProducerBatch> expiredBatches = new ArrayList<ProducerBatch>();
        Iterator<Map.Entry<TopicPartition, List<ProducerBatch>>> batchIt = this.inFlightBatches.entrySet().iterator();
        while (batchIt.hasNext()) {
            Map.Entry<TopicPartition, List<ProducerBatch>> entry = batchIt.next();
            List<ProducerBatch> partitionInFlightBatches = entry.getValue();
            if (partitionInFlightBatches == null) continue;
            Iterator<ProducerBatch> iter = partitionInFlightBatches.iterator();
            while (iter.hasNext()) {
                ProducerBatch batch = iter.next();
                if (batch.hasReachedDeliveryTimeout(this.accumulator.getDeliveryTimeoutMs(), now)) {
                    iter.remove();
                    if (!batch.isDone()) {
                        expiredBatches.add(batch);
                        continue;
                    }
                    throw new IllegalStateException(batch.topicPartition + " batch created at " + batch.createdMs + " gets unexpected final state " + (Object)((Object)batch.finalState()));
                }
                this.accumulator.maybeUpdateNextBatchExpiryTime(batch);
                break;
            }
            if (!partitionInFlightBatches.isEmpty()) continue;
            batchIt.remove();
        }
        return expiredBatches;
    }

    private void addToInflightBatches(List<ProducerBatch> batches) {
        for (ProducerBatch batch : batches) {
            List<ProducerBatch> inflightBatchList = this.inFlightBatches.get(batch.topicPartition);
            if (inflightBatchList == null) {
                inflightBatchList = new ArrayList<ProducerBatch>();
                this.inFlightBatches.put(batch.topicPartition, inflightBatchList);
            }
            inflightBatchList.add(batch);
        }
    }

    public void addToInflightBatches(Map<Integer, List<ProducerBatch>> batches) {
        for (List<ProducerBatch> batchList : batches.values()) {
            this.addToInflightBatches(batchList);
        }
    }

    private boolean hasPendingTransactionalRequests() {
        return this.transactionManager != null && this.transactionManager.hasPendingRequests() && this.transactionManager.hasOngoingTransaction();
    }

    @Override
    public void run() {
        this.log.debug("Starting Kafka producer I/O thread.");
        while (this.running) {
            try {
                this.runOnce();
            }
            catch (Exception e) {
                this.log.error("Uncaught error in kafka producer I/O thread: ", (Throwable)e);
            }
        }
        this.log.debug("Beginning shutdown of Kafka producer I/O thread, sending remaining records.");
        while (!this.forceClose && (this.accumulator.hasUndrained() || this.client.inFlightRequestCount() > 0 || this.hasPendingTransactionalRequests())) {
            try {
                this.runOnce();
            }
            catch (Exception e) {
                this.log.error("Uncaught error in kafka producer I/O thread: ", (Throwable)e);
            }
        }
        while (!this.forceClose && this.transactionManager != null && this.transactionManager.hasOngoingTransaction()) {
            if (!this.transactionManager.isCompleting()) {
                this.log.info("Aborting incomplete transaction due to shutdown");
                this.transactionManager.beginAbort();
            }
            try {
                this.runOnce();
            }
            catch (Exception e) {
                this.log.error("Uncaught error in kafka producer I/O thread: ", (Throwable)e);
            }
        }
        if (this.forceClose) {
            if (this.transactionManager != null) {
                this.log.debug("Aborting incomplete transactional requests due to forced shutdown");
                this.transactionManager.close();
            }
            this.log.debug("Aborting incomplete batches due to forced shutdown");
            this.accumulator.abortIncompleteBatches();
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            this.log.error("Failed to close network client", (Throwable)e);
        }
        this.log.debug("Shutdown of Kafka producer I/O thread has completed.");
    }

    void runOnce() {
        if (this.transactionManager != null) {
            try {
                this.transactionManager.resetProducerIdIfNeeded();
                if (!this.transactionManager.isTransactional()) {
                    this.maybeWaitForProducerId();
                } else if (this.transactionManager.hasUnresolvedSequences() && !this.transactionManager.hasFatalError()) {
                    this.transactionManager.transitionToFatalError(new KafkaException("The client hasn't received acknowledgment for some previously sent messages and can no longer retry them. It isn't safe to continue."));
                } else if (this.transactionManager.hasInFlightTransactionalRequest() || this.maybeSendTransactionalRequest()) {
                    this.client.poll(this.retryBackoffMs, this.time.milliseconds());
                    return;
                }
                if (this.transactionManager.hasFatalError() || !this.transactionManager.hasProducerId()) {
                    RuntimeException lastError = this.transactionManager.lastError();
                    if (lastError != null) {
                        this.maybeAbortBatches(lastError);
                    }
                    this.client.poll(this.retryBackoffMs, this.time.milliseconds());
                    return;
                }
                if (this.transactionManager.hasAbortableError()) {
                    this.accumulator.abortUndrainedBatches(this.transactionManager.lastError());
                }
            }
            catch (AuthenticationException e) {
                this.log.trace("Authentication exception while processing transactional request: {}", (Throwable)e);
                this.transactionManager.authenticationFailed(e);
            }
        }
        long currentTimeMs = this.time.milliseconds();
        long pollTimeout = this.sendProducerData(currentTimeMs);
        this.client.poll(pollTimeout, currentTimeMs);
    }

    private long sendProducerData(long now) {
        Cluster cluster = this.metadata.fetch();
        RecordAccumulator.ReadyCheckResult result = this.accumulator.ready(cluster, now);
        if (!result.unknownLeaderTopics.isEmpty()) {
            for (String topic : result.unknownLeaderTopics) {
                this.metadata.add(topic);
            }
            this.log.debug("Requesting metadata update due to unknown leader topics from the batched records: {}", result.unknownLeaderTopics);
            this.metadata.requestUpdate();
        }
        Iterator<Node> iter = result.readyNodes.iterator();
        long notReadyTimeout = Long.MAX_VALUE;
        while (iter.hasNext()) {
            Node node = iter.next();
            if (this.client.ready(node, now)) continue;
            iter.remove();
            notReadyTimeout = Math.min(notReadyTimeout, this.client.pollDelayMs(node, now));
        }
        Map<Integer, List<ProducerBatch>> batches = this.accumulator.drain(cluster, result.readyNodes, this.maxRequestSize, now);
        this.addToInflightBatches(batches);
        if (this.guaranteeMessageOrder) {
            for (List<ProducerBatch> batchList : batches.values()) {
                for (ProducerBatch batch : batchList) {
                    this.accumulator.mutePartition(batch.topicPartition);
                }
            }
        }
        this.accumulator.resetNextBatchExpiryTime();
        List<ProducerBatch> expiredInflightBatches = this.getExpiredInflightBatches(now);
        List<ProducerBatch> expiredBatches = this.accumulator.expiredBatches(now);
        expiredBatches.addAll(expiredInflightBatches);
        if (!expiredBatches.isEmpty()) {
            this.log.trace("Expired {} batches in accumulator", (Object)expiredBatches.size());
        }
        for (ProducerBatch expiredBatch : expiredBatches) {
            String errorMessage = "Expiring " + expiredBatch.recordCount + " record(s) for " + expiredBatch.topicPartition + ":" + (now - expiredBatch.createdMs) + " ms has passed since batch creation";
            this.failBatch(expiredBatch, -1L, -1L, new TimeoutException(errorMessage), false);
            if (this.transactionManager == null || !expiredBatch.inRetry()) continue;
            this.transactionManager.markSequenceUnresolved(expiredBatch.topicPartition);
        }
        this.sensors.updateProduceRequestMetrics(batches);
        long pollTimeout = Math.min(result.nextReadyCheckDelayMs, notReadyTimeout);
        pollTimeout = Math.min(pollTimeout, this.accumulator.nextExpiryTimeMs() - now);
        pollTimeout = Math.max(pollTimeout, 0L);
        if (!result.readyNodes.isEmpty()) {
            this.log.trace("Nodes with data ready to send: {}", result.readyNodes);
            pollTimeout = 0L;
        }
        this.sendProduceRequests(batches, now);
        return pollTimeout;
    }

    private boolean maybeSendTransactionalRequest() {
        TransactionManager.TxnRequestHandler nextRequestHandler;
        if (this.transactionManager.isCompleting() && this.accumulator.hasIncomplete()) {
            if (this.transactionManager.isAborting()) {
                this.accumulator.abortUndrainedBatches(new KafkaException("Failing batch since transaction was aborted"));
            }
            if (!this.accumulator.flushInProgress()) {
                this.accumulator.beginFlush();
            }
        }
        if ((nextRequestHandler = this.transactionManager.nextRequestHandler(this.accumulator.hasIncomplete())) == null) {
            return false;
        }
        AbstractRequest.Builder<?> requestBuilder = nextRequestHandler.requestBuilder();
        while (!this.forceClose) {
            block13: {
                Node targetNode = null;
                try {
                    if (nextRequestHandler.needsCoordinator()) {
                        targetNode = this.transactionManager.coordinator(nextRequestHandler.coordinatorType());
                        if (targetNode == null) {
                            this.transactionManager.lookupCoordinator(nextRequestHandler);
                            break;
                        }
                        if (!NetworkClientUtils.awaitReady(this.client, targetNode, this.time, this.requestTimeoutMs)) {
                            this.transactionManager.lookupCoordinator(nextRequestHandler);
                            break;
                        }
                    } else {
                        targetNode = this.awaitLeastLoadedNodeReady(this.requestTimeoutMs);
                    }
                    if (targetNode != null) {
                        if (nextRequestHandler.isRetry()) {
                            this.time.sleep(nextRequestHandler.retryBackoffMs());
                        }
                        long currentTimeMs = this.time.milliseconds();
                        ClientRequest clientRequest = this.client.newClientRequest(targetNode.idString(), requestBuilder, currentTimeMs, true, this.requestTimeoutMs, nextRequestHandler);
                        this.log.debug("Sending transactional request {} to node {}", requestBuilder, (Object)targetNode);
                        this.client.send(clientRequest, currentTimeMs);
                        this.transactionManager.setInFlightCorrelationId(clientRequest.correlationId());
                        return true;
                    }
                }
                catch (IOException e) {
                    this.log.debug("Disconnect from {} while trying to send request {}. Going to back off and retry.", new Object[]{targetNode, requestBuilder, e});
                    if (!nextRequestHandler.needsCoordinator()) break block13;
                    this.transactionManager.lookupCoordinator(nextRequestHandler);
                    break;
                }
            }
            this.time.sleep(this.retryBackoffMs);
            this.metadata.requestUpdate();
        }
        this.transactionManager.retry(nextRequestHandler);
        return true;
    }

    private void maybeAbortBatches(RuntimeException exception) {
        if (this.accumulator.hasIncomplete()) {
            this.log.error("Aborting producer batches due to fatal error", (Throwable)exception);
            this.accumulator.abortBatches(exception);
        }
    }

    public void initiateClose() {
        this.accumulator.close();
        this.running = false;
        this.wakeup();
    }

    public void forceClose() {
        this.forceClose = true;
        this.initiateClose();
    }

    public boolean isRunning() {
        return this.running;
    }

    private ClientResponse sendAndAwaitInitProducerIdRequest(Node node) throws IOException {
        String nodeId = node.idString();
        InitProducerIdRequestData requestData = new InitProducerIdRequestData().setTransactionalId(null).setTransactionTimeoutMs(Integer.MAX_VALUE);
        InitProducerIdRequest.Builder builder = new InitProducerIdRequest.Builder(requestData);
        ClientRequest request = this.client.newClientRequest(nodeId, builder, this.time.milliseconds(), true, this.requestTimeoutMs, null);
        return NetworkClientUtils.sendAndReceive(this.client, request, this.time);
    }

    private Node awaitLeastLoadedNodeReady(long remainingTimeMs) throws IOException {
        Node node = this.client.leastLoadedNode(this.time.milliseconds());
        if (node != null && NetworkClientUtils.awaitReady(this.client, node, this.time, remainingTimeMs)) {
            return node;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void maybeWaitForProducerId() {
        while (!this.forceClose) {
            if (this.transactionManager.hasProducerId()) return;
            if (this.transactionManager.hasError()) return;
            Node node = null;
            try {
                node = this.awaitLeastLoadedNodeReady(this.requestTimeoutMs);
                if (node != null) {
                    ClientResponse response = this.sendAndAwaitInitProducerIdRequest(node);
                    InitProducerIdResponse initProducerIdResponse = (InitProducerIdResponse)response.responseBody();
                    Errors error = initProducerIdResponse.error();
                    if (error == Errors.NONE) {
                        ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(initProducerIdResponse.data.producerId(), initProducerIdResponse.data.producerEpoch());
                        this.transactionManager.setProducerIdAndEpoch(producerIdAndEpoch);
                        return;
                    }
                    if (!(error.exception() instanceof RetriableException)) {
                        this.transactionManager.transitionToFatalError(error.exception());
                        return;
                    }
                    this.log.debug("Retriable error from InitProducerId response", (Object)error.message());
                } else {
                    this.log.debug("Could not find an available broker to send InitProducerIdRequest to. Will back off and retry.");
                }
            }
            catch (UnsupportedVersionException e) {
                this.transactionManager.transitionToFatalError(e);
                return;
            }
            catch (IOException e) {
                this.log.debug("Broker {} disconnected while awaiting InitProducerId response", (Object)node, (Object)e);
            }
            this.log.trace("Retry InitProducerIdRequest in {}ms.", (Object)this.retryBackoffMs);
            this.time.sleep(this.retryBackoffMs);
            this.metadata.requestUpdate();
        }
    }

    private void handleProduceResponse(ClientResponse response, Map<TopicPartition, ProducerBatch> batches, long now) {
        RequestHeader requestHeader = response.requestHeader();
        long receivedTimeMs = response.receivedTimeMs();
        int correlationId = requestHeader.correlationId();
        if (response.wasDisconnected()) {
            this.log.trace("Cancelled request with header {} due to node {} being disconnected", (Object)requestHeader, (Object)response.destination());
            for (ProducerBatch batch : batches.values()) {
                this.completeBatch(batch, new ProduceResponse.PartitionResponse(Errors.NETWORK_EXCEPTION), correlationId, now, 0L);
            }
        } else if (response.versionMismatch() != null) {
            this.log.warn("Cancelled request {} due to a version mismatch with node {}", new Object[]{response, response.destination(), response.versionMismatch()});
            for (ProducerBatch batch : batches.values()) {
                this.completeBatch(batch, new ProduceResponse.PartitionResponse(Errors.UNSUPPORTED_VERSION), correlationId, now, 0L);
            }
        } else {
            this.log.trace("Received produce response from node {} with correlation id {}", (Object)response.destination(), (Object)correlationId);
            if (response.hasResponse()) {
                ProduceResponse produceResponse = (ProduceResponse)response.responseBody();
                for (Map.Entry<TopicPartition, ProduceResponse.PartitionResponse> entry : produceResponse.responses().entrySet()) {
                    TopicPartition tp = entry.getKey();
                    ProduceResponse.PartitionResponse partResp = entry.getValue();
                    ProducerBatch batch = batches.get(tp);
                    this.completeBatch(batch, partResp, correlationId, now, receivedTimeMs + (long)produceResponse.throttleTimeMs());
                }
                this.sensors.recordLatency(response.destination(), response.requestLatencyMs());
            } else {
                for (ProducerBatch batch : batches.values()) {
                    this.completeBatch(batch, new ProduceResponse.PartitionResponse(Errors.NONE), correlationId, now, 0L);
                }
            }
        }
    }

    private void completeBatch(ProducerBatch batch, ProduceResponse.PartitionResponse response, long correlationId, long now, long throttleUntilTimeMs) {
        Errors error = response.error;
        if (error == Errors.MESSAGE_TOO_LARGE && batch.recordCount > 1 && !batch.isDone() && (batch.magic() >= 2 || batch.isCompressed())) {
            this.log.warn("Got error produce response in correlation id {} on topic-partition {}, splitting and retrying ({} attempts left). Error: {}", new Object[]{correlationId, batch.topicPartition, this.retries - batch.attempts(), error});
            if (this.transactionManager != null) {
                this.transactionManager.removeInFlightBatch(batch);
            }
            this.accumulator.splitAndReenqueue(batch);
            this.accumulator.deallocate(batch);
            this.sensors.recordBatchSplit();
        } else if (error != Errors.NONE) {
            if (this.canRetry(batch, response, now)) {
                this.log.warn("Got error produce response with correlation id {} on topic-partition {}, retrying ({} attempts left). Error: {}", new Object[]{correlationId, batch.topicPartition, this.retries - batch.attempts() - 1, error});
                if (this.transactionManager == null) {
                    this.reenqueueBatch(batch, now);
                } else if (this.transactionManager.hasProducerIdAndEpoch(batch.producerId(), batch.producerEpoch())) {
                    this.log.debug("Retrying batch to topic-partition {}. ProducerId: {}; Sequence number : {}", new Object[]{batch.topicPartition, batch.producerId(), batch.baseSequence()});
                    this.reenqueueBatch(batch, now);
                } else {
                    this.failBatch(batch, response, new OutOfOrderSequenceException("Attempted to retry sending a batch but the producer id changed from " + batch.producerId() + " to " + this.transactionManager.producerIdAndEpoch().producerId + " in the mean time. This batch will be dropped."), false);
                }
            } else if (error == Errors.DUPLICATE_SEQUENCE_NUMBER) {
                this.completeBatch(batch, response);
            } else {
                ApiException exception = error == Errors.TOPIC_AUTHORIZATION_FAILED ? new TopicAuthorizationException(batch.topicPartition.topic()) : (error == Errors.CLUSTER_AUTHORIZATION_FAILED ? new ClusterAuthorizationException("The producer is not authorized to do idempotent sends") : error.exception());
                this.failBatch(batch, response, exception, batch.attempts() < this.retries);
            }
            if (error.exception() instanceof InvalidMetadataException) {
                if (error.exception() instanceof UnknownTopicOrPartitionException) {
                    this.log.warn("Received unknown topic or partition error in produce request on partition {}. The topic-partition may not exist or the user may not have Describe access to it", (Object)batch.topicPartition);
                } else {
                    this.log.warn("Received invalid metadata error in produce request on partition {} due to {}. Going to request metadata update now", (Object)batch.topicPartition, (Object)error.exception().toString());
                }
                this.metadata.requestUpdate();
            }
        } else {
            this.completeBatch(batch, response);
        }
        if (this.guaranteeMessageOrder) {
            this.accumulator.unmutePartition(batch.topicPartition, throttleUntilTimeMs);
        }
    }

    private void reenqueueBatch(ProducerBatch batch, long currentTimeMs) {
        this.accumulator.reenqueue(batch, currentTimeMs);
        this.maybeRemoveFromInflightBatches(batch);
        this.sensors.recordRetries(batch.topicPartition.topic(), batch.recordCount);
    }

    private void completeBatch(ProducerBatch batch, ProduceResponse.PartitionResponse response) {
        if (this.transactionManager != null) {
            this.transactionManager.handleCompletedBatch(batch, response);
        }
        if (batch.done(response.baseOffset, response.logAppendTime, null)) {
            this.maybeRemoveFromInflightBatches(batch);
            this.accumulator.deallocate(batch);
        }
    }

    private void failBatch(ProducerBatch batch, ProduceResponse.PartitionResponse response, RuntimeException exception, boolean adjustSequenceNumbers) {
        this.failBatch(batch, response.baseOffset, response.logAppendTime, exception, adjustSequenceNumbers);
    }

    private void failBatch(ProducerBatch batch, long baseOffset, long logAppendTime, RuntimeException exception, boolean adjustSequenceNumbers) {
        if (this.transactionManager != null) {
            this.transactionManager.handleFailedBatch(batch, exception, adjustSequenceNumbers);
        }
        this.sensors.recordErrors(batch.topicPartition.topic(), batch.recordCount);
        if (batch.done(baseOffset, logAppendTime, exception)) {
            this.maybeRemoveFromInflightBatches(batch);
            this.accumulator.deallocate(batch);
        }
    }

    private boolean canRetry(ProducerBatch batch, ProduceResponse.PartitionResponse response, long now) {
        return !batch.hasReachedDeliveryTimeout(this.accumulator.getDeliveryTimeoutMs(), now) && batch.attempts() < this.retries && !batch.isDone() && (response.error.exception() instanceof RetriableException || this.transactionManager != null && this.transactionManager.canRetry(response, batch));
    }

    private void sendProduceRequests(Map<Integer, List<ProducerBatch>> collated, long now) {
        for (Map.Entry<Integer, List<ProducerBatch>> entry : collated.entrySet()) {
            this.sendProduceRequest(now, entry.getKey(), this.acks, this.requestTimeoutMs, entry.getValue());
        }
    }

    private void sendProduceRequest(long now, int destination, short acks, int timeout, List<ProducerBatch> batches) {
        if (batches.isEmpty()) {
            return;
        }
        HashMap<TopicPartition, MemoryRecords> produceRecordsByPartition = new HashMap<TopicPartition, MemoryRecords>(batches.size());
        final HashMap<TopicPartition, ProducerBatch> recordsByPartition = new HashMap<TopicPartition, ProducerBatch>(batches.size());
        byte minUsedMagic = this.apiVersions.maxUsableProduceMagic();
        for (ProducerBatch batch : batches) {
            if (batch.magic() >= minUsedMagic) continue;
            minUsedMagic = batch.magic();
        }
        for (ProducerBatch batch : batches) {
            TopicPartition tp = batch.topicPartition;
            MemoryRecords records = batch.records();
            if (!records.hasMatchingMagic(minUsedMagic)) {
                records = batch.records().downConvert(minUsedMagic, 0L, this.time).records();
            }
            produceRecordsByPartition.put(tp, records);
            recordsByPartition.put(tp, batch);
        }
        String transactionalId = null;
        if (this.transactionManager != null && this.transactionManager.isTransactional()) {
            transactionalId = this.transactionManager.transactionalId();
        }
        ProduceRequest.Builder requestBuilder = ProduceRequest.Builder.forMagic(minUsedMagic, acks, timeout, produceRecordsByPartition, transactionalId);
        RequestCompletionHandler callback = new RequestCompletionHandler(){

            @Override
            public void onComplete(ClientResponse response) {
                Sender.this.handleProduceResponse(response, recordsByPartition, Sender.this.time.milliseconds());
            }
        };
        String nodeId = Integer.toString(destination);
        ClientRequest clientRequest = this.client.newClientRequest(nodeId, requestBuilder, now, acks != 0, this.requestTimeoutMs, callback);
        this.client.send(clientRequest, now);
        this.log.trace("Sent produce request to {}: {}", (Object)nodeId, (Object)requestBuilder);
    }

    public void wakeup() {
        this.client.wakeup();
    }

    public static Sensor throttleTimeSensor(SenderMetricsRegistry metrics) {
        Sensor produceThrottleTimeSensor = metrics.sensor("produce-throttle-time");
        produceThrottleTimeSensor.add(metrics.produceThrottleTimeAvg, new Avg());
        produceThrottleTimeSensor.add(metrics.produceThrottleTimeMax, new Max());
        return produceThrottleTimeSensor;
    }

    private static class SenderMetrics {
        public final Sensor retrySensor;
        public final Sensor errorSensor;
        public final Sensor queueTimeSensor;
        public final Sensor requestTimeSensor;
        public final Sensor recordsPerRequestSensor;
        public final Sensor batchSizeSensor;
        public final Sensor compressionRateSensor;
        public final Sensor maxRecordSizeSensor;
        public final Sensor batchSplitSensor;
        private final SenderMetricsRegistry metrics;
        private final Time time;

        public SenderMetrics(SenderMetricsRegistry metrics, Metadata metadata, KafkaClient client, Time time) {
            this.metrics = metrics;
            this.time = time;
            this.batchSizeSensor = metrics.sensor("batch-size");
            this.batchSizeSensor.add(metrics.batchSizeAvg, new Avg());
            this.batchSizeSensor.add(metrics.batchSizeMax, new Max());
            this.compressionRateSensor = metrics.sensor("compression-rate");
            this.compressionRateSensor.add(metrics.compressionRateAvg, new Avg());
            this.queueTimeSensor = metrics.sensor("queue-time");
            this.queueTimeSensor.add(metrics.recordQueueTimeAvg, new Avg());
            this.queueTimeSensor.add(metrics.recordQueueTimeMax, new Max());
            this.requestTimeSensor = metrics.sensor("request-time");
            this.requestTimeSensor.add(metrics.requestLatencyAvg, new Avg());
            this.requestTimeSensor.add(metrics.requestLatencyMax, new Max());
            this.recordsPerRequestSensor = metrics.sensor("records-per-request");
            this.recordsPerRequestSensor.add(new Meter(metrics.recordSendRate, metrics.recordSendTotal));
            this.recordsPerRequestSensor.add(metrics.recordsPerRequestAvg, new Avg());
            this.retrySensor = metrics.sensor("record-retries");
            this.retrySensor.add(new Meter(metrics.recordRetryRate, metrics.recordRetryTotal));
            this.errorSensor = metrics.sensor("errors");
            this.errorSensor.add(new Meter(metrics.recordErrorRate, metrics.recordErrorTotal));
            this.maxRecordSizeSensor = metrics.sensor("record-size");
            this.maxRecordSizeSensor.add(metrics.recordSizeMax, new Max());
            this.maxRecordSizeSensor.add(metrics.recordSizeAvg, new Avg());
            this.metrics.addMetric(metrics.requestsInFlight, (config, now) -> client.inFlightRequestCount());
            this.metrics.addMetric(metrics.metadataAge, (config, now) -> (double)(now - metadata.lastSuccessfulUpdate()) / 1000.0);
            this.batchSplitSensor = metrics.sensor("batch-split-rate");
            this.batchSplitSensor.add(new Meter(metrics.batchSplitRate, metrics.batchSplitTotal));
        }

        private void maybeRegisterTopicMetrics(String topic) {
            String topicRecordsCountName = "topic." + topic + ".records-per-batch";
            Sensor topicRecordCount = this.metrics.getSensor(topicRecordsCountName);
            if (topicRecordCount == null) {
                Map<String, String> metricTags = Collections.singletonMap("topic", topic);
                topicRecordCount = this.metrics.sensor(topicRecordsCountName);
                MetricName rateMetricName = this.metrics.topicRecordSendRate(metricTags);
                MetricName totalMetricName = this.metrics.topicRecordSendTotal(metricTags);
                topicRecordCount.add(new Meter(rateMetricName, totalMetricName));
                String topicByteRateName = "topic." + topic + ".bytes";
                Sensor topicByteRate = this.metrics.sensor(topicByteRateName);
                rateMetricName = this.metrics.topicByteRate(metricTags);
                totalMetricName = this.metrics.topicByteTotal(metricTags);
                topicByteRate.add(new Meter(rateMetricName, totalMetricName));
                String topicCompressionRateName = "topic." + topic + ".compression-rate";
                Sensor topicCompressionRate = this.metrics.sensor(topicCompressionRateName);
                MetricName m = this.metrics.topicCompressionRate(metricTags);
                topicCompressionRate.add(m, new Avg());
                String topicRetryName = "topic." + topic + ".record-retries";
                Sensor topicRetrySensor = this.metrics.sensor(topicRetryName);
                rateMetricName = this.metrics.topicRecordRetryRate(metricTags);
                totalMetricName = this.metrics.topicRecordRetryTotal(metricTags);
                topicRetrySensor.add(new Meter(rateMetricName, totalMetricName));
                String topicErrorName = "topic." + topic + ".record-errors";
                Sensor topicErrorSensor = this.metrics.sensor(topicErrorName);
                rateMetricName = this.metrics.topicRecordErrorRate(metricTags);
                totalMetricName = this.metrics.topicRecordErrorTotal(metricTags);
                topicErrorSensor.add(new Meter(rateMetricName, totalMetricName));
            }
        }

        public void updateProduceRequestMetrics(Map<Integer, List<ProducerBatch>> batches) {
            long now = this.time.milliseconds();
            for (List<ProducerBatch> nodeBatch : batches.values()) {
                int records = 0;
                for (ProducerBatch batch : nodeBatch) {
                    String topic = batch.topicPartition.topic();
                    this.maybeRegisterTopicMetrics(topic);
                    String topicRecordsCountName = "topic." + topic + ".records-per-batch";
                    Sensor topicRecordCount = Utils.notNull(this.metrics.getSensor(topicRecordsCountName));
                    topicRecordCount.record(batch.recordCount);
                    String topicByteRateName = "topic." + topic + ".bytes";
                    Sensor topicByteRate = Utils.notNull(this.metrics.getSensor(topicByteRateName));
                    topicByteRate.record(batch.estimatedSizeInBytes());
                    String topicCompressionRateName = "topic." + topic + ".compression-rate";
                    Sensor topicCompressionRate = Utils.notNull(this.metrics.getSensor(topicCompressionRateName));
                    topicCompressionRate.record(batch.compressionRatio());
                    this.batchSizeSensor.record(batch.estimatedSizeInBytes(), now);
                    this.queueTimeSensor.record(batch.queueTimeMs(), now);
                    this.compressionRateSensor.record(batch.compressionRatio());
                    this.maxRecordSizeSensor.record(batch.maxRecordSize, now);
                    records += batch.recordCount;
                }
                this.recordsPerRequestSensor.record(records, now);
            }
        }

        public void recordRetries(String topic, int count) {
            long now = this.time.milliseconds();
            this.retrySensor.record(count, now);
            String topicRetryName = "topic." + topic + ".record-retries";
            Sensor topicRetrySensor = this.metrics.getSensor(topicRetryName);
            if (topicRetrySensor != null) {
                topicRetrySensor.record(count, now);
            }
        }

        public void recordErrors(String topic, int count) {
            long now = this.time.milliseconds();
            this.errorSensor.record(count, now);
            String topicErrorName = "topic." + topic + ".record-errors";
            Sensor topicErrorSensor = this.metrics.getSensor(topicErrorName);
            if (topicErrorSensor != null) {
                topicErrorSensor.record(count, now);
            }
        }

        public void recordLatency(String node, long latency) {
            String nodeTimeName;
            Sensor nodeRequestTime;
            long now = this.time.milliseconds();
            this.requestTimeSensor.record(latency, now);
            if (!node.isEmpty() && (nodeRequestTime = this.metrics.getSensor(nodeTimeName = "node-" + node + ".latency")) != null) {
                nodeRequestTime.record(latency, now);
            }
        }

        void recordBatchSplit() {
            this.batchSplitSensor.record();
        }
    }
}

