/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients.consumer;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafkaesque.clients.ApiVersions;
import org.apache.kafkaesque.clients.ClientDnsLookup;
import org.apache.kafkaesque.clients.ClientUtils;
import org.apache.kafkaesque.clients.Metadata;
import org.apache.kafkaesque.clients.NetworkClient;
import org.apache.kafkaesque.clients.consumer.Consumer;
import org.apache.kafkaesque.clients.consumer.ConsumerConfig;
import org.apache.kafkaesque.clients.consumer.ConsumerInterceptor;
import org.apache.kafkaesque.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafkaesque.clients.consumer.ConsumerRecord;
import org.apache.kafkaesque.clients.consumer.ConsumerRecords;
import org.apache.kafkaesque.clients.consumer.OffsetAndMetadata;
import org.apache.kafkaesque.clients.consumer.OffsetAndTimestamp;
import org.apache.kafkaesque.clients.consumer.OffsetCommitCallback;
import org.apache.kafkaesque.clients.consumer.OffsetResetStrategy;
import org.apache.kafkaesque.clients.consumer.internals.ConsumerCoordinator;
import org.apache.kafkaesque.clients.consumer.internals.ConsumerInterceptors;
import org.apache.kafkaesque.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafkaesque.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafkaesque.clients.consumer.internals.Fetcher;
import org.apache.kafkaesque.clients.consumer.internals.FetcherMetricsRegistry;
import org.apache.kafkaesque.clients.consumer.internals.Heartbeat;
import org.apache.kafkaesque.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafkaesque.clients.consumer.internals.PartitionAssignor;
import org.apache.kafkaesque.clients.consumer.internals.SubscriptionState;
import org.apache.kafkaesque.common.Cluster;
import org.apache.kafkaesque.common.KafkaException;
import org.apache.kafkaesque.common.Metric;
import org.apache.kafkaesque.common.MetricName;
import org.apache.kafkaesque.common.PartitionInfo;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.errors.InterruptException;
import org.apache.kafkaesque.common.errors.InvalidConfigurationException;
import org.apache.kafkaesque.common.errors.InvalidGroupIdException;
import org.apache.kafkaesque.common.errors.TimeoutException;
import org.apache.kafkaesque.common.internals.ClusterResourceListeners;
import org.apache.kafkaesque.common.metrics.JmxReporter;
import org.apache.kafkaesque.common.metrics.MetricConfig;
import org.apache.kafkaesque.common.metrics.Metrics;
import org.apache.kafkaesque.common.metrics.MetricsReporter;
import org.apache.kafkaesque.common.metrics.Sensor;
import org.apache.kafkaesque.common.network.ChannelBuilder;
import org.apache.kafkaesque.common.network.Selector;
import org.apache.kafkaesque.common.requests.IsolationLevel;
import org.apache.kafkaesque.common.requests.JoinGroupRequest;
import org.apache.kafkaesque.common.requests.MetadataRequest;
import org.apache.kafkaesque.common.serialization.Deserializer;
import org.apache.kafkaesque.common.utils.AppInfoParser;
import org.apache.kafkaesque.common.utils.LogContext;
import org.apache.kafkaesque.common.utils.Time;
import org.apache.kafkaesque.common.utils.Timer;
import org.apache.kafkaesque.common.utils.Utils;
import org.slf4j.Logger;

public class KafkaConsumer<K, V>
implements Consumer<K, V> {
    private static final String CLIENT_ID_METRIC_TAG = "client-id";
    private static final long NO_CURRENT_THREAD = -1L;
    private static final AtomicInteger CONSUMER_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.consumer";
    static final long DEFAULT_CLOSE_TIMEOUT_MS = 30000L;
    final Metrics metrics;
    private final Logger log;
    private final String clientId;
    private String groupId;
    private Optional<String> groupInstanceId;
    private final ConsumerCoordinator coordinator;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private final Fetcher<K, V> fetcher;
    private final ConsumerInterceptors<K, V> interceptors;
    private final Time time;
    private final ConsumerNetworkClient client;
    private final SubscriptionState subscriptions;
    private final ConsumerMetadata metadata;
    private final long retryBackoffMs;
    private final long requestTimeoutMs;
    private final int defaultApiTimeoutMs;
    private volatile boolean closed = false;
    private List<PartitionAssignor> assignors;
    private final AtomicLong currentThread = new AtomicLong(-1L);
    private final AtomicInteger refcount = new AtomicInteger(0);
    private boolean cachedSubscriptionHashAllFetchPositions;

    public KafkaConsumer(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public KafkaConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.addDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    public KafkaConsumer(Properties properties) {
        this(properties, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    public KafkaConsumer(Properties properties, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        this(new ConsumerConfig(ConsumerConfig.addDeserializerToConfig(properties, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    private KafkaConsumer(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        try {
            LogContext logContext;
            String clientId = config.getString("client.id");
            if (clientId.isEmpty()) {
                clientId = "consumer-" + CONSUMER_CLIENT_ID_SEQUENCE.getAndIncrement();
            }
            this.clientId = clientId;
            this.groupId = config.getString("group.id");
            String groupInstanceId = config.getString("group.instance.id");
            if (groupInstanceId != null) {
                JoinGroupRequest.validateGroupInstanceId(groupInstanceId);
                this.groupInstanceId = Optional.of(groupInstanceId);
                logContext = new LogContext("[Consumer instanceId=" + groupInstanceId + ", clientId=" + clientId + ", groupId=" + this.groupId + "] ");
            } else {
                this.groupInstanceId = Optional.empty();
                logContext = new LogContext("[Consumer clientId=" + clientId + ", groupId=" + this.groupId + "] ");
            }
            this.log = logContext.logger(this.getClass());
            boolean enableAutoCommit = config.getBoolean("enable.auto.commit");
            if (this.groupId == null) {
                if (!config.originals().containsKey("enable.auto.commit")) {
                    enableAutoCommit = false;
                } else if (enableAutoCommit) {
                    throw new InvalidConfigurationException("enable.auto.commit cannot be set to true when default group id (null) is used.");
                }
            } else if (this.groupId.isEmpty()) {
                this.log.warn("Support for using the empty group id by consumers is deprecated and will be removed in the next major release.");
            }
            this.log.debug("Initializing the Kafka consumer");
            this.requestTimeoutMs = config.getInt("request.timeout.ms").intValue();
            this.defaultApiTimeoutMs = config.getInt("default.api.timeout.ms");
            this.time = Time.SYSTEM;
            this.metrics = KafkaConsumer.buildMetrics(config, this.time, clientId);
            this.retryBackoffMs = config.getLong("retry.backoff.ms");
            Map<String, Object> userProvidedConfigs = config.originals();
            userProvidedConfigs.put("client.id", clientId);
            List interceptorList = new ConsumerConfig(userProvidedConfigs, false).getConfiguredInstances("interceptor.classes", ConsumerInterceptor.class);
            this.interceptors = new ConsumerInterceptors(interceptorList);
            if (keyDeserializer == null) {
                this.keyDeserializer = config.getConfiguredInstance("key.deserializer", Deserializer.class);
                this.keyDeserializer.configure(config.originals(), true);
            } else {
                config.ignore("key.deserializer");
                this.keyDeserializer = keyDeserializer;
            }
            if (valueDeserializer == null) {
                this.valueDeserializer = config.getConfiguredInstance("value.deserializer", Deserializer.class);
                this.valueDeserializer.configure(config.originals(), false);
            } else {
                config.ignore("value.deserializer");
                this.valueDeserializer = valueDeserializer;
            }
            OffsetResetStrategy offsetResetStrategy = OffsetResetStrategy.valueOf(config.getString("auto.offset.reset").toUpperCase(Locale.ROOT));
            this.subscriptions = new SubscriptionState(logContext, offsetResetStrategy);
            ClusterResourceListeners clusterResourceListeners = this.configureClusterResourceListeners(keyDeserializer, valueDeserializer, this.metrics.reporters(), interceptorList);
            this.metadata = new ConsumerMetadata(this.retryBackoffMs, config.getLong("metadata.max.age.ms"), config.getBoolean("exclude.internal.topics") == false, config.getBoolean("allow.auto.create.topics"), this.subscriptions, logContext, clusterResourceListeners);
            List<InetSocketAddress> addresses = ClientUtils.parseAndValidateAddresses(config.getList("bootstrap.servers"), config.getString("client.dns.lookup"));
            this.metadata.bootstrap(addresses, this.time.milliseconds());
            String metricGrpPrefix = "consumer";
            FetcherMetricsRegistry metricsRegistry = new FetcherMetricsRegistry(Collections.singleton(CLIENT_ID_METRIC_TAG), metricGrpPrefix);
            ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(config, this.time);
            IsolationLevel isolationLevel = IsolationLevel.valueOf(config.getString("isolation.level").toUpperCase(Locale.ROOT));
            Sensor throttleTimeSensor = Fetcher.throttleTimeSensor(this.metrics, metricsRegistry);
            int heartbeatIntervalMs = config.getInt("heartbeat.interval.ms");
            ApiVersions apiVersions = new ApiVersions();
            NetworkClient netClient = new NetworkClient(new Selector(config.getLong("connections.max.idle.ms"), this.metrics, this.time, metricGrpPrefix, channelBuilder, logContext), this.metadata, clientId, 100, config.getLong("reconnect.backoff.ms"), config.getLong("reconnect.backoff.max.ms"), config.getInt("send.buffer.bytes"), config.getInt("receive.buffer.bytes"), config.getInt("request.timeout.ms"), ClientDnsLookup.forConfig(config.getString("client.dns.lookup")), this.time, true, apiVersions, throttleTimeSensor, logContext);
            this.client = new ConsumerNetworkClient(logContext, netClient, this.metadata, this.time, this.retryBackoffMs, config.getInt("request.timeout.ms"), heartbeatIntervalMs);
            this.assignors = config.getConfiguredInstances("partition.assignment.strategy", PartitionAssignor.class);
            int maxPollIntervalMs = config.getInt("max.poll.interval.ms");
            int sessionTimeoutMs = config.getInt("session.timeout.ms");
            this.coordinator = this.groupId == null ? null : new ConsumerCoordinator(logContext, this.client, this.groupId, this.groupInstanceId, maxPollIntervalMs, sessionTimeoutMs, new Heartbeat(this.time, sessionTimeoutMs, heartbeatIntervalMs, maxPollIntervalMs, this.retryBackoffMs), this.assignors, this.metadata, this.subscriptions, this.metrics, metricGrpPrefix, this.time, this.retryBackoffMs, enableAutoCommit, config.getInt("auto.commit.interval.ms"), this.interceptors, config.getBoolean("internal.leave.group.on.close"));
            this.fetcher = new Fetcher<K, V>(logContext, this.client, config.getInt("fetch.min.bytes"), config.getInt("fetch.max.bytes"), config.getInt("fetch.max.wait.ms"), config.getInt("max.partition.fetch.bytes"), config.getInt("max.poll.records"), config.getBoolean("check.crcs"), config.getString("client.rack"), this.keyDeserializer, this.valueDeserializer, this.metadata, this.subscriptions, this.metrics, metricsRegistry, this.time, this.retryBackoffMs, this.requestTimeoutMs, isolationLevel, apiVersions);
            config.logUnused();
            AppInfoParser.registerAppInfo(JMX_PREFIX, clientId, this.metrics, this.time.milliseconds());
            this.log.debug("Kafka consumer initialized");
        }
        catch (Throwable t) {
            this.close(0L, true);
            throw new KafkaException("Failed to construct kafka consumer", t);
        }
    }

    KafkaConsumer(LogContext logContext, String clientId, ConsumerCoordinator coordinator, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Fetcher<K, V> fetcher, ConsumerInterceptors<K, V> interceptors, Time time, ConsumerNetworkClient client, Metrics metrics, SubscriptionState subscriptions, ConsumerMetadata metadata, long retryBackoffMs, long requestTimeoutMs, int defaultApiTimeoutMs, List<PartitionAssignor> assignors, String groupId) {
        this.log = logContext.logger(this.getClass());
        this.clientId = clientId;
        this.coordinator = coordinator;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.fetcher = fetcher;
        this.interceptors = Objects.requireNonNull(interceptors);
        this.time = time;
        this.client = client;
        this.metrics = metrics;
        this.subscriptions = subscriptions;
        this.metadata = metadata;
        this.retryBackoffMs = retryBackoffMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.defaultApiTimeoutMs = defaultApiTimeoutMs;
        this.assignors = assignors;
        this.groupId = groupId;
    }

    private static Metrics buildMetrics(ConsumerConfig config, Time time, String clientId) {
        Map<String, String> metricsTags = Collections.singletonMap(CLIENT_ID_METRIC_TAG, clientId);
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples")).timeWindow(config.getLong("metrics.sample.window.ms"), TimeUnit.MILLISECONDS).recordLevel(Sensor.RecordingLevel.forName(config.getString("metrics.recording.level"))).tags(metricsTags);
        List<MetricsReporter> reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class, Collections.singletonMap("client.id", clientId));
        reporters.add(new JmxReporter(JMX_PREFIX));
        return new Metrics(metricConfig, reporters, time);
    }

    @Override
    public Set<TopicPartition> assignment() {
        this.acquireAndEnsureOpen();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(this.subscriptions.assignedPartitions());
            return set;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Set<String> subscription() {
        this.acquireAndEnsureOpen();
        try {
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.subscriptions.subscription()));
            return set;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            if (topics == null) {
                throw new IllegalArgumentException("Topic collection to subscribe to cannot be null");
            }
            if (topics.isEmpty()) {
                this.unsubscribe();
            } else {
                for (String topic : topics) {
                    if (topic != null && !topic.trim().isEmpty()) continue;
                    throw new IllegalArgumentException("Topic collection to subscribe to cannot contain null or empty topic");
                }
                this.throwIfNoAssignorsConfigured();
                this.fetcher.clearBufferedDataForUnassignedTopics(topics);
                this.log.info("Subscribed to topic(s): {}", (Object)Utils.join(topics, ", "));
                if (this.subscriptions.subscribe(new HashSet<String>(topics), listener)) {
                    this.metadata.requestUpdateForNewTopics();
                }
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void subscribe(Collection<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.maybeThrowInvalidGroupIdException();
        if (pattern == null) {
            throw new IllegalArgumentException("Topic pattern to subscribe to cannot be null");
        }
        this.acquireAndEnsureOpen();
        try {
            this.throwIfNoAssignorsConfigured();
            this.log.info("Subscribed to pattern: '{}'", (Object)pattern);
            this.subscriptions.subscribe(pattern, listener);
            this.coordinator.updatePatternSubscription(this.metadata.fetch());
            this.metadata.requestUpdateForNewTopics();
        }
        finally {
            this.release();
        }
    }

    @Override
    public void subscribe(Pattern pattern) {
        this.subscribe(pattern, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void unsubscribe() {
        this.acquireAndEnsureOpen();
        try {
            this.fetcher.clearBufferedDataForUnassignedPartitions(Collections.emptySet());
            this.subscriptions.unsubscribe();
            if (this.coordinator != null) {
                this.coordinator.maybeLeaveGroup();
            }
            this.log.info("Unsubscribed all topics or patterns and assigned partitions");
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assign(Collection<TopicPartition> partitions) {
        this.acquireAndEnsureOpen();
        try {
            if (partitions == null) {
                throw new IllegalArgumentException("Topic partition collection to assign to cannot be null");
            }
            if (partitions.isEmpty()) {
                this.unsubscribe();
            } else {
                for (TopicPartition tp : partitions) {
                    String topic;
                    String string = topic = tp != null ? tp.topic() : null;
                    if (topic != null && !topic.trim().isEmpty()) continue;
                    throw new IllegalArgumentException("Topic partitions to assign to cannot have null or empty topic");
                }
                this.fetcher.clearBufferedDataForUnassignedPartitions(partitions);
                if (this.coordinator != null) {
                    this.coordinator.maybeAutoCommitOffsetsAsync(this.time.milliseconds());
                }
                this.log.info("Subscribed to partition(s): {}", (Object)Utils.join(partitions, ", "));
                if (this.subscriptions.assignFromUser(new HashSet<TopicPartition>(partitions))) {
                    this.metadata.requestUpdateForNewTopics();
                }
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    @Deprecated
    public ConsumerRecords<K, V> poll(long timeoutMs) {
        return this.poll(this.time.timer(timeoutMs), false);
    }

    @Override
    public ConsumerRecords<K, V> poll(Duration timeout) {
        return this.poll(this.time.timer(timeout), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerRecords<K, V> poll(Timer timer, boolean includeMetadataInTimeout) {
        this.acquireAndEnsureOpen();
        try {
            ConsumerRecords consumerRecords;
            if (this.subscriptions.hasNoSubscriptionOrUserAssignment()) {
                throw new IllegalStateException("Consumer is not subscribed to any topics or assigned any partitions");
            }
            do {
                Map<TopicPartition, List<ConsumerRecord<K, V>>> records;
                this.client.maybeTriggerWakeup();
                if (includeMetadataInTimeout) {
                    if (!this.updateAssignmentMetadataIfNeeded(timer)) {
                        consumerRecords = ConsumerRecords.empty();
                        return consumerRecords;
                    }
                } else {
                    while (!this.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE))) {
                        this.log.warn("Still waiting for metadata");
                    }
                }
                if ((records = this.pollForFetches(timer)).isEmpty()) continue;
                if (this.fetcher.sendFetches() > 0 || this.client.hasPendingRequests()) {
                    this.client.pollNoWakeup();
                }
                ConsumerRecords<K, V> consumerRecords2 = this.interceptors.onConsume(new ConsumerRecords<K, V>(records));
                return consumerRecords2;
            } while (timer.notExpired());
            consumerRecords = ConsumerRecords.empty();
            return consumerRecords;
        }
        finally {
            this.release();
        }
    }

    boolean updateAssignmentMetadataIfNeeded(Timer timer) {
        if (this.coordinator != null && !this.coordinator.poll(timer)) {
            return false;
        }
        return this.updateFetchPositions(timer);
    }

    private Map<TopicPartition, List<ConsumerRecord<K, V>>> pollForFetches(Timer timer) {
        long pollTimeout = this.coordinator == null ? timer.remainingMs() : Math.min(this.coordinator.timeToNextPoll(timer.currentTimeMs()), timer.remainingMs());
        Map<TopicPartition, List<ConsumerRecord<K, V>>> records = this.fetcher.fetchedRecords();
        if (!records.isEmpty()) {
            return records;
        }
        this.fetcher.sendFetches();
        if (!this.cachedSubscriptionHashAllFetchPositions && pollTimeout > this.retryBackoffMs) {
            pollTimeout = this.retryBackoffMs;
        }
        Timer pollTimer = this.time.timer(pollTimeout);
        this.client.poll(pollTimer, () -> !this.fetcher.hasCompletedFetches());
        timer.update(pollTimer.currentTimeMs());
        if (this.coordinator != null && this.coordinator.rejoinNeededOrPending()) {
            return Collections.emptyMap();
        }
        return this.fetcher.fetchedRecords();
    }

    @Override
    public void commitSync() {
        this.commitSync(Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public void commitSync(Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            if (!this.coordinator.commitOffsetsSync(this.subscriptions.allConsumed(), this.time.timer(timeout))) {
                throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before successfully committing the current consumed offsets");
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.commitSync(offsets, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            offsets.forEach(this::updateLastSeenEpochIfNewer);
            if (!this.coordinator.commitOffsetsSync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), this.time.timer(timeout))) {
                throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before successfully committing offsets " + offsets);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void commitAsync() {
        this.commitAsync(null);
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        this.commitAsync(this.subscriptions.allConsumed(), callback);
    }

    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            this.log.debug("Committing offsets: {}", offsets);
            offsets.forEach(this::updateLastSeenEpochIfNewer);
            this.coordinator.commitOffsetsAsync(new HashMap<TopicPartition, OffsetAndMetadata>(offsets), callback);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(TopicPartition partition, long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("seek offset must not be a negative number");
        }
        this.acquireAndEnsureOpen();
        try {
            this.log.info("Seeking to offset {} for partition {}", (Object)offset, (Object)partition);
            SubscriptionState.FetchPosition newPosition = new SubscriptionState.FetchPosition(offset, Optional.empty(), this.metadata.leaderAndEpoch(partition));
            this.subscriptions.seekUnvalidated(partition, newPosition);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        long offset = offsetAndMetadata.offset();
        if (offset < 0L) {
            throw new IllegalArgumentException("seek offset must not be a negative number");
        }
        this.acquireAndEnsureOpen();
        try {
            if (offsetAndMetadata.leaderEpoch().isPresent()) {
                this.log.info("Seeking to offset {} for partition {} with epoch {}", new Object[]{offset, partition, offsetAndMetadata.leaderEpoch().get()});
            } else {
                this.log.info("Seeking to offset {} for partition {}", (Object)offset, (Object)partition);
            }
            Metadata.LeaderAndEpoch currentLeaderAndEpoch = this.metadata.leaderAndEpoch(partition);
            SubscriptionState.FetchPosition newPosition = new SubscriptionState.FetchPosition(offsetAndMetadata.offset(), offsetAndMetadata.leaderEpoch(), currentLeaderAndEpoch);
            this.updateLastSeenEpochIfNewer(partition, offsetAndMetadata);
            this.subscriptions.seekUnvalidated(partition, newPosition);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        if (partitions == null) {
            throw new IllegalArgumentException("Partitions collection cannot be null");
        }
        this.acquireAndEnsureOpen();
        try {
            Collection<TopicPartition> parts = partitions.size() == 0 ? this.subscriptions.assignedPartitions() : partitions;
            this.subscriptions.requestOffsetReset(parts, OffsetResetStrategy.EARLIEST);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        if (partitions == null) {
            throw new IllegalArgumentException("Partitions collection cannot be null");
        }
        this.acquireAndEnsureOpen();
        try {
            Collection<TopicPartition> parts = partitions.size() == 0 ? this.subscriptions.assignedPartitions() : partitions;
            this.subscriptions.requestOffsetReset(parts, OffsetResetStrategy.LATEST);
        }
        finally {
            this.release();
        }
    }

    @Override
    public long position(TopicPartition partition) {
        return this.position(partition, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public long position(TopicPartition partition, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            if (!this.subscriptions.isAssigned(partition)) {
                throw new IllegalStateException("You can only check the position for partitions assigned to this consumer.");
            }
            Timer timer = this.time.timer(timeout);
            do {
                SubscriptionState.FetchPosition position;
                if ((position = this.subscriptions.validPosition(partition)) != null) {
                    long l = position.offset;
                    return l;
                }
                this.updateFetchPositions(timer);
                this.client.poll(timer);
            } while (timer.notExpired());
            throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before the position for partition " + partition + " could be determined");
        }
        finally {
            this.release();
        }
    }

    @Override
    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.committed(partition, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OffsetAndMetadata committed(TopicPartition partition, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            this.maybeThrowInvalidGroupIdException();
            Map<TopicPartition, OffsetAndMetadata> offsets = this.coordinator.fetchCommittedOffsets(Collections.singleton(partition), this.time.timer(timeout));
            if (offsets == null) {
                throw new TimeoutException("Timeout of " + timeout.toMillis() + "ms expired before the last committed offset for partition " + partition + " could be determined");
            }
            offsets.forEach(this::updateLastSeenEpochIfNewer);
            OffsetAndMetadata offsetAndMetadata = offsets.get(partition);
            return offsetAndMetadata;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return Collections.unmodifiableMap(this.metrics.metrics());
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.partitionsFor(topic, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Cluster cluster = this.metadata.fetch();
            List<PartitionInfo> parts = cluster.partitionsForTopic(topic);
            if (!parts.isEmpty()) {
                List<PartitionInfo> list = parts;
                return list;
            }
            Timer timer = this.time.timer(timeout);
            Map<String, List<PartitionInfo>> topicMetadata = this.fetcher.getTopicMetadata(new MetadataRequest.Builder(Collections.singletonList(topic), this.metadata.allowAutoTopicCreation()), timer);
            List<PartitionInfo> list = topicMetadata.get(topic);
            return list;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        return this.listTopics(Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Map<String, List<PartitionInfo>> map = this.fetcher.getAllTopicMetadata(this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(Collection<TopicPartition> partitions) {
        this.acquireAndEnsureOpen();
        try {
            this.log.debug("Pausing partitions {}", partitions);
            for (TopicPartition partition : partitions) {
                this.subscriptions.pause(partition);
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(Collection<TopicPartition> partitions) {
        this.acquireAndEnsureOpen();
        try {
            this.log.debug("Resuming partitions {}", partitions);
            for (TopicPartition partition : partitions) {
                this.subscriptions.resume(partition);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public Set<TopicPartition> paused() {
        this.acquireAndEnsureOpen();
        try {
            Set<TopicPartition> set = Collections.unmodifiableSet(this.subscriptions.pausedPartitions());
            return set;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.offsetsForTimes(timestampsToSearch, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            for (Map.Entry<TopicPartition, Long> entry : timestampsToSearch.entrySet()) {
                if (entry.getValue() >= 0L) continue;
                throw new IllegalArgumentException("The target time for partition " + entry.getKey() + " is " + entry.getValue() + ". The target time cannot be negative.");
            }
            Map<TopicPartition, OffsetAndTimestamp> map = this.fetcher.offsetsForTimes(timestampsToSearch, this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.beginningOffsets(partitions, Duration.ofMillis(this.defaultApiTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, Long> map = this.fetcher.beginningOffsets(partitions, this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.endOffsets(partitions, Duration.ofMillis(this.requestTimeoutMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        this.acquireAndEnsureOpen();
        try {
            Map<TopicPartition, Long> map = this.fetcher.endOffsets(partitions, this.time.timer(timeout));
            return map;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void close() {
        this.close(Duration.ofMillis(30000L));
    }

    @Override
    @Deprecated
    public void close(long timeout, TimeUnit timeUnit) {
        this.close(Duration.ofMillis(timeUnit.toMillis(timeout)));
    }

    @Override
    public void close(Duration timeout) {
        if (timeout.toMillis() < 0L) {
            throw new IllegalArgumentException("The timeout cannot be negative.");
        }
        this.acquire();
        try {
            if (!this.closed) {
                this.closed = true;
                this.close(timeout.toMillis(), false);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void wakeup() {
        this.client.wakeup();
    }

    private ClusterResourceListeners configureClusterResourceListeners(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, List<?> ... candidateLists) {
        ClusterResourceListeners clusterResourceListeners = new ClusterResourceListeners();
        for (List<?> candidateList : candidateLists) {
            clusterResourceListeners.maybeAddAll(candidateList);
        }
        clusterResourceListeners.maybeAdd(keyDeserializer);
        clusterResourceListeners.maybeAdd(valueDeserializer);
        return clusterResourceListeners;
    }

    private void close(long timeoutMs, boolean swallowException) {
        this.log.trace("Closing the Kafka consumer");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        try {
            if (this.coordinator != null) {
                this.coordinator.close(this.time.timer(Math.min(timeoutMs, this.requestTimeoutMs)));
            }
        }
        catch (Throwable t) {
            firstException.compareAndSet(null, t);
            this.log.error("Failed to close coordinator", t);
        }
        Utils.closeQuietly(this.fetcher, "fetcher", firstException);
        Utils.closeQuietly(this.interceptors, "consumer interceptors", firstException);
        Utils.closeQuietly(this.metrics, "consumer metrics", firstException);
        Utils.closeQuietly(this.client, "consumer network client", firstException);
        Utils.closeQuietly(this.keyDeserializer, "consumer key deserializer", firstException);
        Utils.closeQuietly(this.valueDeserializer, "consumer value deserializer", firstException);
        AppInfoParser.unregisterAppInfo(JMX_PREFIX, this.clientId, this.metrics);
        this.log.debug("Kafka consumer has been closed");
        Throwable exception = firstException.get();
        if (exception != null && !swallowException) {
            if (exception instanceof InterruptException) {
                throw (InterruptException)exception;
            }
            throw new KafkaException("Failed to close kafka consumer", exception);
        }
    }

    private boolean updateFetchPositions(Timer timer) {
        this.fetcher.validateOffsetsIfNeeded();
        this.cachedSubscriptionHashAllFetchPositions = this.subscriptions.hasAllFetchPositions();
        if (this.cachedSubscriptionHashAllFetchPositions) {
            return true;
        }
        if (this.coordinator != null && !this.coordinator.refreshCommittedOffsetsIfNeeded(timer)) {
            return false;
        }
        this.subscriptions.resetMissingPositions();
        this.fetcher.resetOffsetsIfNeeded();
        return true;
    }

    private void acquireAndEnsureOpen() {
        this.acquire();
        if (this.closed) {
            this.release();
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }

    private void acquire() {
        long threadId = Thread.currentThread().getId();
        if (threadId != this.currentThread.get() && !this.currentThread.compareAndSet(-1L, threadId)) {
            throw new ConcurrentModificationException("KafkaConsumer is not safe for multi-threaded access");
        }
        this.refcount.incrementAndGet();
    }

    private void release() {
        if (this.refcount.decrementAndGet() == 0) {
            this.currentThread.set(-1L);
        }
    }

    private void throwIfNoAssignorsConfigured() {
        if (this.assignors.isEmpty()) {
            throw new IllegalStateException("Must configure at least one partition assigner class name to partition.assignment.strategy configuration property");
        }
    }

    private void maybeThrowInvalidGroupIdException() {
        if (this.groupId == null) {
            throw new InvalidGroupIdException("To use the group management or offset commit APIs, you must provide a valid group.id in the consumer configuration.");
        }
    }

    private void updateLastSeenEpochIfNewer(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        offsetAndMetadata.leaderEpoch().ifPresent(epoch -> this.metadata.updateLastSeenEpochIfNewer(topicPartition, (int)epoch));
    }

    String getClientId() {
        return this.clientId;
    }
}

