/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.kafkaesque.clients.MetadataCache;
import org.apache.kafkaesque.common.Cluster;
import org.apache.kafkaesque.common.KafkaException;
import org.apache.kafkaesque.common.Node;
import org.apache.kafkaesque.common.PartitionInfo;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.errors.InvalidMetadataException;
import org.apache.kafkaesque.common.errors.InvalidTopicException;
import org.apache.kafkaesque.common.errors.TopicAuthorizationException;
import org.apache.kafkaesque.common.internals.ClusterResourceListeners;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.requests.MetadataRequest;
import org.apache.kafkaesque.common.requests.MetadataResponse;
import org.apache.kafkaesque.common.utils.LogContext;
import org.slf4j.Logger;

public class Metadata
implements Closeable {
    private final Logger log;
    private final long refreshBackoffMs;
    private final long metadataExpireMs;
    private int updateVersion;
    private int requestVersion;
    private long lastRefreshMs;
    private long lastSuccessfulRefreshMs;
    private KafkaException fatalException;
    private KafkaException recoverableException;
    private MetadataCache cache = MetadataCache.empty();
    private boolean needUpdate;
    private final ClusterResourceListeners clusterResourceListeners;
    private boolean isClosed;
    private final Map<TopicPartition, Integer> lastSeenLeaderEpochs;

    public Metadata(long refreshBackoffMs, long metadataExpireMs, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        this.log = logContext.logger(Metadata.class);
        this.refreshBackoffMs = refreshBackoffMs;
        this.metadataExpireMs = metadataExpireMs;
        this.lastRefreshMs = 0L;
        this.lastSuccessfulRefreshMs = 0L;
        this.requestVersion = 0;
        this.updateVersion = 0;
        this.needUpdate = false;
        this.clusterResourceListeners = clusterResourceListeners;
        this.isClosed = false;
        this.lastSeenLeaderEpochs = new HashMap<TopicPartition, Integer>();
    }

    public synchronized Cluster fetch() {
        return this.cache.cluster();
    }

    public synchronized long timeToAllowUpdate(long nowMs) {
        return Math.max(this.lastRefreshMs + this.refreshBackoffMs - nowMs, 0L);
    }

    public synchronized long timeToNextUpdate(long nowMs) {
        long timeToExpire = this.needUpdate ? 0L : Math.max(this.lastSuccessfulRefreshMs + this.metadataExpireMs - nowMs, 0L);
        return Math.max(timeToExpire, this.timeToAllowUpdate(nowMs));
    }

    public long metadataExpireMs() {
        return this.metadataExpireMs;
    }

    public synchronized int requestUpdate() {
        this.needUpdate = true;
        return this.updateVersion;
    }

    public synchronized boolean updateLastSeenEpochIfNewer(TopicPartition topicPartition, int leaderEpoch) {
        Objects.requireNonNull(topicPartition, "TopicPartition cannot be null");
        return this.updateLastSeenEpoch(topicPartition, leaderEpoch, oldEpoch -> leaderEpoch > oldEpoch, true);
    }

    public Optional<Integer> lastSeenLeaderEpoch(TopicPartition topicPartition) {
        return Optional.ofNullable(this.lastSeenLeaderEpochs.get(topicPartition));
    }

    private synchronized boolean updateLastSeenEpoch(TopicPartition topicPartition, int epoch, Predicate<Integer> epochTest, boolean setRequestUpdateFlag) {
        Integer oldEpoch = this.lastSeenLeaderEpochs.get(topicPartition);
        this.log.trace("Determining if we should replace existing epoch {} with new epoch {}", (Object)oldEpoch, (Object)epoch);
        if (oldEpoch == null || epochTest.test(oldEpoch)) {
            this.log.debug("Updating last seen epoch from {} to {} for partition {}", new Object[]{oldEpoch, epoch, topicPartition});
            this.lastSeenLeaderEpochs.put(topicPartition, epoch);
            if (setRequestUpdateFlag) {
                this.needUpdate = true;
            }
            return true;
        }
        this.log.debug("Not replacing existing epoch {} with new epoch {}", (Object)oldEpoch, (Object)epoch);
        return false;
    }

    public synchronized boolean updateRequested() {
        return this.needUpdate;
    }

    public synchronized Optional<MetadataCache.PartitionInfoAndEpoch> partitionInfoIfCurrent(TopicPartition topicPartition) {
        Integer epoch = this.lastSeenLeaderEpochs.get(topicPartition);
        if (epoch == null) {
            return this.cache.getPartitionInfo(topicPartition);
        }
        return this.cache.getPartitionInfoHavingEpoch(topicPartition, epoch);
    }

    public synchronized KafkaException getAndClearMetadataException() {
        KafkaException metadataException = Optional.ofNullable(this.fatalException).orElse(this.recoverableException);
        this.fatalException = null;
        this.recoverableException = null;
        return metadataException;
    }

    public synchronized void bootstrap(List<InetSocketAddress> addresses, long now) {
        this.needUpdate = true;
        this.lastRefreshMs = now;
        this.lastSuccessfulRefreshMs = now;
        ++this.updateVersion;
        this.cache = MetadataCache.bootstrap(addresses);
    }

    public synchronized void update(MetadataResponse response, long now) {
        this.update(this.requestVersion, response, now);
    }

    public synchronized void update(int requestVersion, MetadataResponse response, long now) {
        Objects.requireNonNull(response, "Metadata response cannot be null");
        if (this.isClosed()) {
            throw new IllegalStateException("Update requested after metadata close");
        }
        if (requestVersion == this.requestVersion) {
            this.needUpdate = false;
        } else {
            this.requestUpdate();
        }
        this.lastRefreshMs = now;
        this.lastSuccessfulRefreshMs = now;
        ++this.updateVersion;
        String previousClusterId = this.cache.cluster().clusterResource().clusterId();
        this.cache = this.handleMetadataResponse(response, topic -> this.retainTopic(topic.topic(), topic.isInternal(), now));
        Cluster cluster = this.cache.cluster();
        this.maybeSetMetadataError(cluster);
        this.lastSeenLeaderEpochs.keySet().removeIf(tp -> !this.retainTopic(tp.topic(), false, now));
        String newClusterId = this.cache.cluster().clusterResource().clusterId();
        if (!Objects.equals(previousClusterId, newClusterId)) {
            this.log.info("Cluster ID: {}", (Object)newClusterId);
        }
        this.clusterResourceListeners.onUpdate(this.cache.cluster().clusterResource());
        this.log.debug("Updated cluster metadata updateVersion {} to {}", (Object)this.updateVersion, (Object)this.cache);
    }

    private void maybeSetMetadataError(Cluster cluster) {
        this.recoverableException = null;
        this.checkInvalidTopics(cluster);
        this.checkUnauthorizedTopics(cluster);
    }

    private void checkInvalidTopics(Cluster cluster) {
        if (!cluster.invalidTopics().isEmpty()) {
            this.log.error("Metadata response reported invalid topics {}", cluster.invalidTopics());
            this.recoverableException = new InvalidTopicException(cluster.invalidTopics());
        }
    }

    private void checkUnauthorizedTopics(Cluster cluster) {
        if (!cluster.unauthorizedTopics().isEmpty()) {
            this.log.error("Topic authorization failed for topics {}", cluster.unauthorizedTopics());
            this.recoverableException = new TopicAuthorizationException(new HashSet<String>(cluster.unauthorizedTopics()));
        }
    }

    private MetadataCache handleMetadataResponse(MetadataResponse metadataResponse, Predicate<MetadataResponse.TopicMetadata> topicsToRetain) {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<MetadataCache.PartitionInfoAndEpoch> partitions = new ArrayList<MetadataCache.PartitionInfoAndEpoch>();
        for (MetadataResponse.TopicMetadata metadata : metadataResponse.topicMetadata()) {
            if (!topicsToRetain.test(metadata)) continue;
            if (metadata.error() == Errors.NONE) {
                if (metadata.isInternal()) {
                    internalTopics.add(metadata.topic());
                }
                for (MetadataResponse.PartitionMetadata partitionMetadata : metadata.partitionMetadata()) {
                    this.updatePartitionInfo(metadata.topic(), partitionMetadata, partitionInfo -> {
                        int epoch = partitionMetadata.leaderEpoch().orElse(-1);
                        partitions.add(new MetadataCache.PartitionInfoAndEpoch((PartitionInfo)partitionInfo, epoch));
                    });
                    if (!(partitionMetadata.error().exception() instanceof InvalidMetadataException)) continue;
                    this.log.debug("Requesting metadata update for partition {} due to error {}", (Object)new TopicPartition(metadata.topic(), partitionMetadata.partition()), (Object)partitionMetadata.error());
                    this.requestUpdate();
                }
                continue;
            }
            if (!(metadata.error().exception() instanceof InvalidMetadataException)) continue;
            this.log.debug("Requesting metadata update for topic {} due to error {}", (Object)metadata.topic(), (Object)metadata.error());
            this.requestUpdate();
        }
        return new MetadataCache(metadataResponse.clusterId(), new ArrayList<Node>(metadataResponse.brokers()), partitions, metadataResponse.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), metadataResponse.topicsByError(Errors.INVALID_TOPIC_EXCEPTION), internalTopics, metadataResponse.controller());
    }

    private void updatePartitionInfo(String topic, MetadataResponse.PartitionMetadata partitionMetadata, Consumer<PartitionInfo> partitionInfoConsumer) {
        TopicPartition tp = new TopicPartition(topic, partitionMetadata.partition());
        if (partitionMetadata.leaderEpoch().isPresent()) {
            int newEpoch = partitionMetadata.leaderEpoch().get();
            if (this.updateLastSeenEpoch(tp, newEpoch, oldEpoch -> newEpoch >= oldEpoch, false)) {
                partitionInfoConsumer.accept(MetadataResponse.partitionMetaToInfo(topic, partitionMetadata));
            } else {
                PartitionInfo previousInfo = this.cache.cluster().partition(tp);
                if (previousInfo != null) {
                    partitionInfoConsumer.accept(previousInfo);
                }
            }
        } else {
            this.lastSeenLeaderEpochs.remove(tp);
            partitionInfoConsumer.accept(MetadataResponse.partitionMetaToInfo(topic, partitionMetadata));
        }
    }

    public synchronized void maybeThrowException() {
        KafkaException metadataException = this.getAndClearMetadataException();
        if (metadataException != null) {
            throw metadataException;
        }
    }

    public synchronized void failedUpdate(long now, KafkaException fatalException) {
        this.lastRefreshMs = now;
        this.fatalException = fatalException;
    }

    public synchronized int updateVersion() {
        return this.updateVersion;
    }

    public synchronized long lastSuccessfulUpdate() {
        return this.lastSuccessfulRefreshMs;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void requestUpdateForNewTopics() {
        this.lastRefreshMs = 0L;
        ++this.requestVersion;
        this.requestUpdate();
    }

    public synchronized MetadataRequestAndVersion newMetadataRequestAndVersion() {
        return new MetadataRequestAndVersion(this.newMetadataRequestBuilder(), this.requestVersion);
    }

    protected MetadataRequest.Builder newMetadataRequestBuilder() {
        return MetadataRequest.Builder.allTopics();
    }

    protected boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        return true;
    }

    public synchronized LeaderAndEpoch leaderAndEpoch(TopicPartition tp) {
        return this.partitionInfoIfCurrent(tp).map(infoAndEpoch -> {
            Node leader = infoAndEpoch.partitionInfo().leader();
            return new LeaderAndEpoch(leader == null ? Node.noNode() : leader, Optional.of(infoAndEpoch.epoch()));
        }).orElse(new LeaderAndEpoch(Node.noNode(), this.lastSeenLeaderEpoch(tp)));
    }

    public static class LeaderAndEpoch {
        public static final LeaderAndEpoch NO_LEADER_OR_EPOCH = new LeaderAndEpoch(Node.noNode(), Optional.empty());
        public final Node leader;
        public final Optional<Integer> epoch;

        public LeaderAndEpoch(Node leader, Optional<Integer> epoch) {
            this.leader = Objects.requireNonNull(leader);
            this.epoch = Objects.requireNonNull(epoch);
        }

        public static LeaderAndEpoch noLeaderOrEpoch() {
            return NO_LEADER_OR_EPOCH;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeaderAndEpoch that = (LeaderAndEpoch)o;
            if (!this.leader.equals(that.leader)) {
                return false;
            }
            return this.epoch.equals(that.epoch);
        }

        public int hashCode() {
            int result = this.leader.hashCode();
            result = 31 * result + this.epoch.hashCode();
            return result;
        }

        public String toString() {
            return "LeaderAndEpoch{leader=" + this.leader + ", epoch=" + this.epoch.map(Object::toString).orElse("absent") + '}';
        }
    }

    public static class MetadataRequestAndVersion {
        public final MetadataRequest.Builder requestBuilder;
        public final int requestVersion;

        private MetadataRequestAndVersion(MetadataRequest.Builder requestBuilder, int requestVersion) {
            this.requestBuilder = requestBuilder;
            this.requestVersion = requestVersion;
        }
    }
}

