/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import org.apache.hadoop.hive.kafka.KafkaOutputFormat;
import org.apache.hadoop.hive.serde2.JsonSerDe;

enum KafkaTableProperties {
    HIVE_KAFKA_TOPIC("kafka.topic", null),
    HIVE_KAFKA_BOOTSTRAP_SERVERS("kafka.bootstrap.servers", null),
    SERDE_CLASS_NAME("kafka.serde.class", JsonSerDe.class.getName()),
    KAFKA_POLL_TIMEOUT("hive.kafka.poll.timeout.ms", "5000"),
    MAX_RETRIES("hive.kafka.max.retries", "6"),
    KAFKA_FETCH_METADATA_TIMEOUT("hive.kafka.metadata.poll.timeout.ms", "30000"),
    WRITE_SEMANTIC_PROPERTY("kafka.write.semantic", KafkaOutputFormat.WriteSemantic.AT_LEAST_ONCE.name()),
    HIVE_KAFKA_OPTIMISTIC_COMMIT("hive.kafka.optimistic.commit", "false");

    private final String name;
    private final String defaultValue;
    private final boolean mandatory;

    private KafkaTableProperties(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.mandatory = defaultValue == null;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }
}

