/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.kafka.HiveKafkaProducer;
import org.apache.hadoop.hive.kafka.KafkaInputFormat;
import org.apache.hadoop.hive.kafka.KafkaOutputFormat;
import org.apache.hadoop.hive.kafka.KafkaSerDe;
import org.apache.hadoop.hive.kafka.KafkaStorageHandlerInfo;
import org.apache.hadoop.hive.kafka.KafkaTableProperties;
import org.apache.hadoop.hive.kafka.KafkaUtils;
import org.apache.hadoop.hive.kafka.RetryUtils;
import org.apache.hadoop.hive.kafka.TransactionalKafkaWriter;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kafkaesque.clients.consumer.OffsetAndMetadata;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.errors.ProducerFencedException;
import org.apache.kafkaesque.common.serialization.ByteArrayDeserializer;
import org.apache.kafkaesque.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStorageHandler
extends DefaultHiveMetaHook
implements HiveStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaStorageHandler.class);
    private static final String KAFKA_STORAGE_HANDLER = "org.apache.hadoop.hive.kafka.KafkaStorageHandler";
    private Configuration configuration;

    public Class<? extends InputFormat> getInputFormatClass() {
        return KafkaInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return KafkaOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return KafkaSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return new DefaultHiveAuthorizationProvider();
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureCommonProperties(tableDesc, jobProperties);
    }

    private void configureCommonProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        String topic = tableDesc.getProperties().getProperty(KafkaTableProperties.HIVE_KAFKA_TOPIC.getName(), "");
        if (topic.isEmpty()) {
            throw new IllegalArgumentException("Kafka topic missing set table property->" + KafkaTableProperties.HIVE_KAFKA_TOPIC.getName());
        }
        jobProperties.put(KafkaTableProperties.HIVE_KAFKA_TOPIC.getName(), topic);
        String brokerString = tableDesc.getProperties().getProperty(KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName(), "");
        if (brokerString.isEmpty()) {
            throw new IllegalArgumentException("Broker address missing set table property->" + KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName());
        }
        jobProperties.put(KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName(), brokerString);
        Arrays.stream(KafkaTableProperties.values()).filter(tableProperty -> !tableProperty.isMandatory()).forEach(tableProperty -> jobProperties.put(tableProperty.getName(), tableDesc.getProperties().getProperty(tableProperty.getName())));
        if (jobProperties.get(KafkaTableProperties.WRITE_SEMANTIC_PROPERTY.getName()).equals(KafkaOutputFormat.WriteSemantic.EXACTLY_ONCE.name())) {
            jobProperties.put("kafka.consumer.isolation.level", "read_committed");
        }
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureCommonProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureInputJobProperties(tableDesc, jobProperties);
        this.configureOutputJobProperties(tableDesc, jobProperties);
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.configureInputJobProperties(tableDesc, properties);
        this.configureOutputJobProperties(tableDesc, properties);
        properties.forEach((arg_0, arg_1) -> ((JobConf)jobConf).set(arg_0, arg_1));
        try {
            KafkaUtils.copyDependencyJars((Configuration)jobConf, KafkaStorageHandler.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public String toString() {
        return KAFKA_STORAGE_HANDLER;
    }

    public StorageHandlerInfo getStorageHandlerInfo(Table table) throws MetaException {
        String topic = (String)table.getParameters().get(KafkaTableProperties.HIVE_KAFKA_TOPIC.getName());
        if (topic == null || topic.isEmpty()) {
            throw new MetaException("topic is null or empty");
        }
        String brokers = (String)table.getParameters().get(KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName());
        if (brokers == null || brokers.isEmpty()) {
            throw new MetaException("kafka brokers string is null or empty");
        }
        Properties properties = new Properties();
        properties.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.setProperty("bootstrap.servers", brokers);
        properties.setProperty("client.id", Utilities.getTaskId((Configuration)this.getConf()));
        if (UserGroupInformation.isSecurityEnabled()) {
            KafkaUtils.addKerberosJaasConf(this.getConf(), properties);
        }
        table.getParameters().entrySet().stream().filter(objectObjectEntry -> ((String)objectObjectEntry.getKey()).toLowerCase().startsWith("kafka.consumer")).forEach(entry -> {
            String key = ((String)entry.getKey()).substring("kafka.consumer".length() + 1);
            if (KafkaUtils.FORBIDDEN_PROPERTIES.contains(key)) {
                throw new IllegalArgumentException("Not suppose to set Kafka Property " + key);
            }
            properties.put(key, entry.getValue());
        });
        return new KafkaStorageHandlerInfo(topic, properties);
    }

    private Properties buildProducerProperties(Table table) {
        String brokers = (String)table.getParameters().get(KafkaTableProperties.HIVE_KAFKA_BOOTSTRAP_SERVERS.getName());
        if (brokers == null || brokers.isEmpty()) {
            throw new RuntimeException("kafka brokers string is null or empty");
        }
        Properties properties = new Properties();
        properties.setProperty("key.serializer", ByteArraySerializer.class.getName());
        properties.setProperty("value.serializer", ByteArraySerializer.class.getName());
        properties.setProperty("bootstrap.servers", brokers);
        if (UserGroupInformation.isSecurityEnabled()) {
            KafkaUtils.addKerberosJaasConf(this.getConf(), properties);
        }
        table.getParameters().entrySet().stream().filter(objectObjectEntry -> ((String)objectObjectEntry.getKey()).toLowerCase().startsWith("kafka.producer")).forEach(entry -> {
            String key = ((String)entry.getKey()).substring("kafka.producer".length() + 1);
            if (KafkaUtils.FORBIDDEN_PROPERTIES.contains(key)) {
                throw new IllegalArgumentException("Not suppose to set Kafka Property " + key);
            }
            properties.put(key, entry.getValue());
        });
        return properties;
    }

    public LockType getLockType(WriteEntity writeEntity) {
        if (writeEntity.getWriteType().equals((Object)WriteEntity.WriteType.INSERT)) {
            return LockType.SHARED_READ;
        }
        return LockType.SHARED_WRITE;
    }

    private String getQueryId() {
        return HiveConf.getVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID);
    }

    public void commitInsertTable(Table table, boolean overwrite) throws MetaException {
        Map<String, Pair<Long, Short>> transactionsMap;
        boolean isTwoPhaseCommit;
        boolean isExactlyOnce = ((String)table.getParameters().get(KafkaTableProperties.WRITE_SEMANTIC_PROPERTY.getName())).equals(KafkaOutputFormat.WriteSemantic.EXACTLY_ONCE.name());
        String optimiticCommitVal = (String)table.getParameters().get(KafkaTableProperties.HIVE_KAFKA_OPTIMISTIC_COMMIT.getName());
        boolean bl = isTwoPhaseCommit = !Boolean.parseBoolean(optimiticCommitVal);
        if (!isExactlyOnce || !isTwoPhaseCommit) {
            return;
        }
        final Path queryWorkingDir = this.getQueryWorkingDir(table);
        int maxTries = Integer.parseInt((String)table.getParameters().get(KafkaTableProperties.MAX_RETRIES.getName()));
        RetryUtils.Task<Map<String, Pair<Long, Short>>> fetchTransactionStates = new RetryUtils.Task<Map<String, Pair<Long, Short>>>(){

            @Override
            public Map<String, Pair<Long, Short>> perform() throws Exception {
                return TransactionalKafkaWriter.getTransactionsState(FileSystem.get((Configuration)KafkaStorageHandler.this.getConf()), queryWorkingDir);
            }
        };
        try {
            transactionsMap = RetryUtils.retry(fetchTransactionStates, error -> error instanceof IOException, maxTries);
        }
        catch (Exception e) {
            LOG.error("Can not fetch Transaction states due [{}]", (Object)e.getMessage());
            throw new MetaException(e.getMessage());
        }
        final Properties baseProducerPros = this.buildProducerProperties(table);
        final HashMap<String, HiveKafkaProducer> producersMap = new HashMap<String, HiveKafkaProducer>();
        RetryUtils.Task<Void> buildProducersTask = new RetryUtils.Task<Void>(){

            @Override
            public Void perform() throws Exception {
                assert (producersMap.size() == 0);
                transactionsMap.forEach((key, value) -> {
                    baseProducerPros.setProperty("transactional.id", (String)key);
                    HiveKafkaProducer producer = new HiveKafkaProducer(baseProducerPros);
                    producer.resumeTransaction((Long)value.getLeft(), (Short)value.getRight());
                    producer.sendOffsetsToTransaction((Map<TopicPartition, OffsetAndMetadata>)ImmutableMap.of(), "__dry_run");
                    producersMap.put(key, producer);
                });
                return null;
            }
        };
        RetryUtils.CleanupAfterFailure cleanUpTheMap = new RetryUtils.CleanupAfterFailure(){

            @Override
            public void cleanup() {
                producersMap.forEach((s, producer) -> producer.close(0L, TimeUnit.MILLISECONDS));
                producersMap.clear();
            }
        };
        Predicate<Throwable> isRetrayable = error -> !KafkaUtils.exceptionIsFatal(error) && !(error instanceof ProducerFencedException);
        try {
            RetryUtils.retry(buildProducersTask, isRetrayable, cleanUpTheMap, maxTries, "Error while Builing Producers");
        }
        catch (Exception e) {
            LOG.error("Can not fetch build produces due [{}]", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        final HashSet committedTx = new HashSet();
        RetryUtils.Task commitTask = new RetryUtils.Task(){

            public Object perform() throws Exception {
                producersMap.forEach((key, producer) -> {
                    if (!committedTx.contains(key)) {
                        producer.commitTransaction();
                        committedTx.add(key);
                        producer.close();
                        LOG.info("Committed Transaction [{}]", key);
                    }
                });
                return null;
            }
        };
        try {
            RetryUtils.retry(commitTask, isRetrayable, maxTries);
        }
        catch (Exception e) {
            producersMap.forEach((key, producer) -> producer.close(0L, TimeUnit.MILLISECONDS));
            LOG.error("Commit transaction failed", (Throwable)e);
            if (committedTx.size() > 0) {
                LOG.error("Partial Data Got Commited Some actions need to be Done");
                committedTx.stream().forEach(key -> LOG.error("Transaction [{}] is an orphen commit", key));
            }
            throw new MetaException(e.getMessage());
        }
        RetryUtils.Task<Void> cleanQueryDirTask = new RetryUtils.Task<Void>(){

            @Override
            public Void perform() throws Exception {
                KafkaStorageHandler.this.cleanWorkingDirectory(queryWorkingDir);
                return null;
            }
        };
        try {
            RetryUtils.retry(cleanQueryDirTask, error -> error instanceof IOException, maxTries);
        }
        catch (Exception e) {
            LOG.error("Faild to clean Query Working Directory [{}] due to [{}]", (Object)queryWorkingDir, (Object)e.getMessage());
        }
    }

    public void preInsertTable(Table table, boolean overwrite) throws MetaException {
        if (overwrite) {
            throw new MetaException("Kafa Table does not support the overwite SQL Smentic");
        }
    }

    public void rollbackInsertTable(Table table, boolean overwrite) throws MetaException {
    }

    public void preCreateTable(Table table) throws MetaException {
        if (!table.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
            throw new MetaException("org.apache.hadoop.hive.kafka.KafkaStorageHandler supports only " + TableType.EXTERNAL_TABLE);
        }
        Arrays.stream(KafkaTableProperties.values()).filter(KafkaTableProperties::isMandatory).forEach(key -> {
            String cfr_ignored_0 = (String)Preconditions.checkNotNull(table.getParameters().get(key.getName()), (Object)("Set Table property " + key.getName()));
        });
        Arrays.stream(KafkaTableProperties.values()).forEach(key -> {
            if (table.getParameters().get(key.getName()) == null) {
                table.putToParameters(key.getName(), key.getDefaultValue());
            }
        });
    }

    public void rollbackCreateTable(Table table) throws MetaException {
    }

    public void commitCreateTable(Table table) throws MetaException {
        this.commitInsertTable(table, false);
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean deleteData) throws MetaException {
    }

    private Path getQueryWorkingDir(Table table) {
        return new Path(table.getSd().getLocation(), this.getQueryId());
    }

    private void cleanWorkingDirectory(Path queryWorkingDir) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        fs.delete(queryWorkingDir, true);
    }
}

