/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaJsonSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaJsonSerDe.class);
    private static final ThreadLocal<DateTimeFormatter> TS_PARSER = ThreadLocal.withInitial(KafkaJsonSerDe::createAutoParser);
    private static final Function<TypeInfo, ObjectInspector> TYPEINFO_TO_OI = typeInfo -> PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)typeInfo.getTypeName()));
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private ObjectInspector inspector;
    private final ObjectMapper mapper = new ObjectMapper();
    private long rowCount = 0L;
    private long rawDataSize = 0L;

    KafkaJsonSerDe() {
    }

    public void initialize(@Nullable Configuration conf, Properties tbl) {
        String columnNameDelimiter;
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String string = columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        if (!columnNameProperty.isEmpty()) {
            this.columnNames = Arrays.asList(columnNameProperty.split(columnNameDelimiter));
        }
        if (!columnTypeProperty.isEmpty()) {
            this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("columns: {}, {}", (Object)columnNameProperty, this.columnNames);
            LOG.debug("types: {}, {} ", (Object)columnTypeProperty, this.columnTypes);
        }
        List inspectors = this.columnTypes.stream().map(TYPEINFO_TO_OI).collect(Collectors.toList());
        this.inspector = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, inspectors);
    }

    public Class<? extends Writable> getSerializedClass() {
        return BytesRefWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new SerDeException("unimplemented");
    }

    public SerDeStats getSerDeStats() {
        SerDeStats serDeStats = new SerDeStats();
        serDeStats.setRawDataSize(this.rawDataSize);
        serDeStats.setRowCount(this.rowCount);
        return serDeStats;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        Map<String, JsonNode> payload;
        BytesWritable record = (BytesWritable)blob;
        try {
            payload = this.parseAsJson(record.getBytes());
            ++this.rowCount;
            this.rawDataSize += (long)record.getLength();
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        ArrayList<Object> output = new ArrayList<Object>(this.columnNames.size());
        block5: for (int i = 0; i < this.columnNames.size(); ++i) {
            String name = this.columnNames.get(i);
            TypeInfo typeInfo = this.columnTypes.get(i);
            JsonNode value = payload.get(name);
            if (value == null) {
                output.add(null);
                continue;
            }
            switch (this.columnTypes.get(i).getCategory()) {
                case PRIMITIVE: {
                    output.add(this.parseAsPrimitive(value, typeInfo));
                    continue block5;
                }
                default: {
                    throw new SerDeException("not supported yet");
                }
            }
        }
        return output;
    }

    private Object parseAsPrimitive(JsonNode value, TypeInfo typeInfo) throws SerDeException {
        switch (TypeInfoFactory.getPrimitiveTypeInfo((String)typeInfo.getTypeName()).getPrimitiveCategory()) {
            case TIMESTAMP: {
                TimestampWritable timestampWritable = new TimestampWritable();
                timestampWritable.setTime(TS_PARSER.get().parseMillis(value.textValue()));
                return timestampWritable;
            }
            case TIMESTAMPLOCALTZ: {
                long numberOfMillis = TS_PARSER.get().parseMillis(value.textValue());
                return new TimestampLocalTZWritable(new TimestampTZ(ZonedDateTime.ofInstant(Instant.ofEpochMilli(numberOfMillis), ((TimestampLocalTZTypeInfo)typeInfo).timeZone())));
            }
            case BYTE: {
                return new ByteWritable((byte)value.intValue());
            }
            case SHORT: {
                return new ShortWritable(value.shortValue());
            }
            case INT: {
                return new IntWritable(value.intValue());
            }
            case LONG: {
                return new LongWritable(value.longValue());
            }
            case FLOAT: {
                return new FloatWritable(value.floatValue());
            }
            case DOUBLE: {
                return new DoubleWritable(value.doubleValue());
            }
            case DECIMAL: {
                return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)value.decimalValue()));
            }
            case CHAR: {
                return new HiveCharWritable(new HiveChar(value.textValue(), ((CharTypeInfo)typeInfo).getLength()));
            }
            case VARCHAR: {
                return new HiveVarcharWritable(new HiveVarchar(value.textValue(), ((CharTypeInfo)typeInfo).getLength()));
            }
            case STRING: {
                return new Text(value.textValue());
            }
            case BOOLEAN: {
                return new BooleanWritable(value.isBoolean() ? value.booleanValue() : Boolean.valueOf(value.textValue()).booleanValue());
            }
        }
        throw new SerDeException("Unknown type: " + typeInfo.getTypeName());
    }

    private Map<String, JsonNode> parseAsJson(byte[] value) throws IOException {
        JsonNode document = (JsonNode)this.mapper.readValue(value, JsonNode.class);
        TreeMap documentMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        document.fields().forEachRemaining(field -> {
            JsonNode cfr_ignored_0 = (JsonNode)documentMap.put(((String)field.getKey()).toLowerCase(), field.getValue());
        });
        return documentMap;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        if (this.inspector == null) {
            throw new SerDeException("null inspector ??");
        }
        return this.inspector;
    }

    private static DateTimeFormatter createAutoParser() {
        DateTimeFormatter offsetElement = new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
        DateTimeParser timeOrOffset = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('T').toParser(), new DateTimeFormatterBuilder().appendLiteral(' ').toParser()}).appendOptional(ISODateTimeFormat.timeElementParser().getParser()).appendOptional(offsetElement.getParser()).toParser();
        return new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendOptional(timeOrOffset).toFormatter();
    }
}

