/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSHLogProvider
extends AbstractFSWALProvider<FSHLog> {
    private static final Log LOG = LogFactory.getLog(FSHLogProvider.class);

    public static Writer createWriter(Configuration conf, FileSystem fs, Path path, boolean overwritable) throws IOException {
        Class logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, Writer.class);
        Writer writer = null;
        try {
            writer = (Writer)logWriterClass.newInstance();
            writer.init(fs, path, conf, overwritable);
            return writer;
        }
        catch (Exception e) {
            LOG.debug((Object)"Error instantiating log writer.", (Throwable)e);
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ee) {
                    LOG.error((Object)"cannot close log writer", (Throwable)ee);
                }
            }
            throw new IOException("cannot get log writer", e);
        }
    }

    @Override
    protected FSHLog createWAL() throws IOException {
        return new FSHLog(FSUtils.getWALFileSystem(this.conf), FSUtils.getWALRootDir(this.conf), FSHLogProvider.getWALDirectoryName(this.factory.factoryId), FSHLogProvider.getWALArchiveDirectoryName(this.conf, this.factory.factoryId), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? META_WAL_PROVIDER_ID : null);
    }

    @Override
    protected void doInit(Configuration conf) throws IOException {
    }

    public static interface Writer
    extends WALProvider.Writer {
        public void init(FileSystem var1, Path var2, Configuration var3, boolean var4) throws IOException;
    }
}

