/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorServiceBackwardCompatiblity;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerCoprocessorHost
extends CoprocessorHost<RegionServerCoprocessor, RegionServerCoprocessorEnvironment> {
    private static final Log LOG = LogFactory.getLog(RegionServerCoprocessorHost.class);
    private RegionServerServices rsServices;
    private CoprocessorHost.ObserverGetter<RegionServerCoprocessor, RegionServerObserver> rsObserverGetter = RegionServerCoprocessor::getRegionServerObserver;

    public RegionServerCoprocessorHost(RegionServerServices rsServices, Configuration conf) {
        super(rsServices);
        this.rsServices = rsServices;
        this.conf = conf;
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        boolean tableCoprocessorsEnabled = conf.getBoolean("hbase.coprocessor.user.enabled", true);
        LOG.info((Object)("System coprocessor loading is " + (coprocessorsEnabled ? "enabled" : "disabled")));
        LOG.info((Object)("Table coprocessor loading is " + (coprocessorsEnabled && tableCoprocessorsEnabled ? "enabled" : "disabled")));
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.regionserver.classes");
    }

    @Override
    public RegionServerEnvironment createEnvironment(RegionServerCoprocessor instance, int priority, int sequence, Configuration conf) {
        return instance.getClass().isAnnotationPresent(CoreCoprocessor.class) ? new RegionServerEnvironmentForCoreCoprocessors(instance, priority, sequence, conf, this.rsServices) : new RegionServerEnvironment(instance, priority, sequence, conf, this.rsServices);
    }

    @Override
    public RegionServerCoprocessor checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
        if (RegionServerCoprocessor.class.isAssignableFrom(implClass)) {
            return (RegionServerCoprocessor)implClass.newInstance();
        }
        if (SingletonCoprocessorService.class.isAssignableFrom(implClass)) {
            return new CoprocessorServiceBackwardCompatiblity.RegionServerCoprocessorService((SingletonCoprocessorService)implClass.newInstance());
        }
        LOG.error((Object)(implClass.getName() + " is not of type RegionServerCoprocessor. Check the configuration " + "hbase.coprocessor.regionserver.classes"));
        return null;
    }

    public void preStop(String message, User user) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execShutdown(new RegionServerObserverOperation(user){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preStopRegionServer(this);
            }

            @Override
            public void postEnvCall() {
                RegionServerCoprocessorHost.this.shutdown(this.getEnvironment());
            }
        });
    }

    public void preRollWALWriterRequest() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preRollWALWriterRequest(this);
            }
        });
    }

    public void postRollWALWriterRequest() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postRollWALWriterRequest(this);
            }
        });
    }

    public void preReplicateLogEntries() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preReplicateLogEntries(this);
            }
        });
    }

    public void postReplicateLogEntries() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postReplicateLogEntries(this);
            }
        });
    }

    public ReplicationEndpoint postCreateReplicationEndPoint(ReplicationEndpoint endpoint) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return endpoint;
        }
        return this.execOperationWithResult(new CoprocessorHost.ObserverOperationWithResult<RegionServerObserver, ReplicationEndpoint>(this.rsObserverGetter, endpoint){

            @Override
            public ReplicationEndpoint call(RegionServerObserver observer) throws IOException {
                return observer.postCreateReplicationEndPoint(this, (ReplicationEndpoint)this.getResult());
            }
        });
    }

    public void preClearCompactionQueues() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.preClearCompactionQueues(this);
            }
        });
    }

    public void postClearCompactionQueues() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new RegionServerObserverOperation(){

            @Override
            public void call(RegionServerObserver observer) throws IOException {
                observer.postClearCompactionQueues(this);
            }
        });
    }

    private static class RegionServerEnvironmentForCoreCoprocessors
    extends RegionServerEnvironment
    implements HasRegionServerServices {
        final RegionServerServices regionServerServices;

        public RegionServerEnvironmentForCoreCoprocessors(RegionServerCoprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf, services);
            this.regionServerServices = services;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.regionServerServices;
        }
    }

    private static class RegionServerEnvironment
    extends BaseEnvironment<RegionServerCoprocessor>
    implements RegionServerCoprocessorEnvironment {
        private final MetricRegistry metricRegistry;
        private final Connection connection;
        private final ServerName serverName;
        private final OnlineRegions onlineRegions;

        @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Intentional; FB has trouble detecting isAssignableFrom")
        public RegionServerEnvironment(RegionServerCoprocessor impl, int priority, int seq, Configuration conf, RegionServerServices services) {
            super(impl, priority, seq, conf);
            for (Service service : impl.getServices()) {
                services.registerService(service);
            }
            this.onlineRegions = services;
            this.connection = services.getConnection();
            this.serverName = services.getServerName();
            this.metricRegistry = MetricsCoprocessor.createRegistryForRSCoprocessor(impl.getClass().getName());
        }

        @Override
        public OnlineRegions getOnlineRegions() {
            return this.onlineRegions;
        }

        @Override
        public ServerName getServerName() {
            return this.serverName;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public MetricRegistry getMetricRegistryForRegionServer() {
            return this.metricRegistry;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }
    }

    abstract class RegionServerObserverOperation
    extends CoprocessorHost.ObserverOperationWithoutResult<RegionServerObserver> {
        public RegionServerObserverOperation() {
            super(RegionServerCoprocessorHost.this, RegionServerCoprocessorHost.this.rsObserverGetter);
        }

        public RegionServerObserverOperation(User user) {
            super((CoprocessorHost)RegionServerCoprocessorHost.this, RegionServerCoprocessorHost.this.rsObserverGetter, user);
        }
    }
}

