/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.hadoop.hbase.shaded.io.netty.channel.Channel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandler;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.protobuf.ProtobufDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.timeout.IdleState;
import org.apache.hadoop.hbase.shaded.io.netty.handler.timeout.IdleStateEvent;
import org.apache.hadoop.hbase.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.Promise;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.PromiseCombiner;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.protocol.datatransfer.PipelineAck;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.util.DataChecksum;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FanOutOneBlockAsyncDFSOutput
implements AsyncFSOutput {
    private static final int MAX_DATA_LEN = 0xC00000;
    private final Configuration conf;
    private final FSUtils fsUtils;
    private final DistributedFileSystem dfs;
    private final DFSClient client;
    private final ClientProtocol namenode;
    private final String clientName;
    private final String src;
    private final long fileId;
    private final LocatedBlock locatedBlock;
    private final Encryptor encryptor;
    private final EventLoop eventLoop;
    private final List<Channel> datanodeList;
    private final DataChecksum summer;
    private final int maxDataLen;
    private final ByteBufAllocator alloc;
    private final Deque<Callback> waitingAckQueue = new ArrayDeque<Callback>();
    private long nextPacketOffsetInBlock = 0L;
    private long nextPacketSeqno = 0L;
    private ByteBuf buf;
    private int capacity = 4096;
    private static final int LIMIT = 0x8000000;
    private State state;

    private void completed(Channel channel) {
        if (this.waitingAckQueue.isEmpty()) {
            return;
        }
        for (Callback c : this.waitingAckQueue) {
            if (!c.unfinishedReplicas.remove(channel)) continue;
            if (c.unfinishedReplicas.isEmpty()) {
                Callback cb;
                c.promise.trySuccess(null);
                this.waitingAckQueue.removeFirst();
                while ((cb = this.waitingAckQueue.peekFirst()) != null && cb.ackedLength == c.ackedLength) {
                    cb.promise.trySuccess(null);
                    this.waitingAckQueue.removeFirst();
                }
            }
            return;
        }
    }

    private void failed(Channel channel, Supplier<Throwable> errorSupplier) {
        Callback c2;
        if (this.state == State.BROKEN || this.state == State.CLOSED) {
            return;
        }
        if (!(this.state != State.CLOSING || (c2 = this.waitingAckQueue.peekFirst()) != null && c2.unfinishedReplicas.contains(channel))) {
            return;
        }
        this.state = State.BROKEN;
        Throwable error = errorSupplier.get();
        this.waitingAckQueue.stream().forEach(c -> ((Callback)c).promise.tryFailure(error));
        this.waitingAckQueue.clear();
        this.datanodeList.forEach(ch -> ch.close());
    }

    private void setupReceiver(int timeoutMs) {
        AckHandler ackHandler = new AckHandler(timeoutMs);
        for (Channel ch : this.datanodeList) {
            ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler((long)timeoutMs, (long)(timeoutMs / 2), 0L, TimeUnit.MILLISECONDS), new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)DataTransferProtos.PipelineAckProto.getDefaultInstance()), ackHandler});
            ch.config().setAutoRead(true);
        }
    }

    FanOutOneBlockAsyncDFSOutput(Configuration conf, FSUtils fsUtils, DistributedFileSystem dfs, DFSClient client, ClientProtocol namenode, String clientName, String src, long fileId, LocatedBlock locatedBlock, Encryptor encryptor, EventLoop eventLoop, List<Channel> datanodeList, DataChecksum summer, ByteBufAllocator alloc) {
        this.conf = conf;
        this.fsUtils = fsUtils;
        this.dfs = dfs;
        this.client = client;
        this.namenode = namenode;
        this.fileId = fileId;
        this.clientName = clientName;
        this.src = src;
        this.locatedBlock = locatedBlock;
        this.encryptor = encryptor;
        this.eventLoop = eventLoop;
        this.datanodeList = datanodeList;
        this.summer = summer;
        this.maxDataLen = 0xC00000 - 0xC00000 % summer.getBytesPerChecksum();
        this.alloc = alloc;
        this.buf = alloc.directBuffer(this.capacity);
        this.state = State.STREAMING;
        this.setupReceiver(conf.getInt("dfs.client.socket-timeout", 60000));
    }

    private void writeInt0(int i) {
        this.buf.ensureWritable(4);
        this.buf.writeInt(i);
    }

    @Override
    public void writeInt(int i) {
        if (this.eventLoop.inEventLoop()) {
            this.writeInt0(i);
        } else {
            this.eventLoop.submit(() -> this.writeInt0(i));
        }
    }

    private void write0(ByteBuffer bb) {
        this.buf.ensureWritable(bb.remaining());
        this.buf.writeBytes(bb);
    }

    @Override
    public void write(ByteBuffer bb) {
        if (this.eventLoop.inEventLoop()) {
            this.write0(bb);
        } else {
            this.eventLoop.submit(() -> this.write0(bb));
        }
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    private void write0(byte[] b, int off, int len) {
        this.buf.ensureWritable(len);
        this.buf.writeBytes(b, off, len);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.eventLoop.inEventLoop()) {
            this.write0(b, off, len);
        } else {
            this.eventLoop.submit(() -> this.write0(b, off, len)).syncUninterruptibly();
        }
    }

    @Override
    public int buffered() {
        if (this.eventLoop.inEventLoop()) {
            return this.buf.readableBytes();
        }
        return (Integer)this.eventLoop.submit(() -> this.buf.readableBytes()).syncUninterruptibly().getNow();
    }

    @Override
    public DatanodeInfo[] getPipeline() {
        return this.locatedBlock.getLocations();
    }

    private Promise<Void> flushBuffer(ByteBuf dataBuf, long nextPacketOffsetInBlock, boolean syncBlock) {
        int dataLen = dataBuf.readableBytes();
        int chunkLen = this.summer.getBytesPerChecksum();
        int trailingPartialChunkLen = dataLen % chunkLen;
        int numChecks = dataLen / chunkLen + (trailingPartialChunkLen != 0 ? 1 : 0);
        int checksumLen = numChecks * this.summer.getChecksumSize();
        ByteBuf checksumBuf = this.alloc.directBuffer(checksumLen);
        this.summer.calculateChunkedSums(dataBuf.nioBuffer(), checksumBuf.nioBuffer(0, checksumLen));
        checksumBuf.writerIndex(checksumLen);
        PacketHeader header = new PacketHeader(4 + checksumLen + dataLen, nextPacketOffsetInBlock, this.nextPacketSeqno, false, dataLen, syncBlock);
        int headerLen = header.getSerializedSize();
        ByteBuf headerBuf = this.alloc.buffer(headerLen);
        header.putInBuffer(headerBuf.nioBuffer(0, headerLen));
        headerBuf.writerIndex(headerLen);
        long ackedLength = nextPacketOffsetInBlock + (long)dataLen;
        Promise promise = this.eventLoop.newPromise().addListener(future -> {
            if (future.isSuccess()) {
                this.locatedBlock.getBlock().setNumBytes(ackedLength);
            }
        });
        this.waitingAckQueue.addLast(new Callback((Promise<Void>)promise, ackedLength, this.datanodeList));
        for (Channel ch : this.datanodeList) {
            ch.write((Object)headerBuf.duplicate().retain());
            ch.write((Object)checksumBuf.duplicate().retain());
            ch.writeAndFlush((Object)dataBuf.duplicate().retain());
        }
        checksumBuf.release();
        headerBuf.release();
        dataBuf.release();
        ++this.nextPacketSeqno;
        return promise;
    }

    private void flush0(CompletableFuture<Long> future, boolean syncBlock) {
        Promise promise;
        long lengthAfterFlush;
        if (this.state != State.STREAMING) {
            future.completeExceptionally(new IOException("stream already broken"));
            return;
        }
        int dataLen = this.buf.readableBytes();
        if (this.encryptor != null) {
            ByteBuf encryptBuf = this.alloc.directBuffer(dataLen);
            try {
                this.encryptor.encrypt(this.buf.nioBuffer(this.buf.readerIndex(), dataLen), encryptBuf.nioBuffer(0, dataLen));
            }
            catch (IOException e) {
                encryptBuf.release();
                future.completeExceptionally(e);
                return;
            }
            encryptBuf.writerIndex(dataLen);
            this.buf.release();
            this.buf = encryptBuf;
        }
        if ((lengthAfterFlush = this.nextPacketOffsetInBlock + (long)dataLen) == this.locatedBlock.getBlock().getNumBytes()) {
            future.complete(this.locatedBlock.getBlock().getNumBytes());
            return;
        }
        Callback c = this.waitingAckQueue.peekLast();
        if (c != null && lengthAfterFlush == c.ackedLength) {
            this.waitingAckQueue.addLast(new Callback((Promise<Void>)this.eventLoop.newPromise().addListener(f -> {
                if (f.isSuccess()) {
                    future.complete(lengthAfterFlush);
                } else {
                    future.completeExceptionally(f.cause());
                }
            }), lengthAfterFlush, Collections.emptyList()));
            return;
        }
        if (dataLen > this.maxDataLen) {
            int toWriteDataLen;
            PromiseCombiner combiner = new PromiseCombiner();
            long nextSubPacketOffsetInBlock = this.nextPacketOffsetInBlock;
            for (int remaining = dataLen; remaining > 0; remaining -= toWriteDataLen) {
                toWriteDataLen = Math.min(remaining, this.maxDataLen);
                combiner.add(this.flushBuffer(this.buf.readRetainedSlice(toWriteDataLen), nextSubPacketOffsetInBlock, syncBlock));
                nextSubPacketOffsetInBlock += (long)toWriteDataLen;
            }
            promise = this.eventLoop.newPromise();
            combiner.finish(promise);
        } else {
            promise = this.flushBuffer(this.buf.retain(), this.nextPacketOffsetInBlock, syncBlock);
        }
        promise.addListener(f -> {
            if (f.isSuccess()) {
                future.complete(lengthAfterFlush);
            } else {
                future.completeExceptionally(f.cause());
            }
        });
        int trailingPartialChunkLen = dataLen % this.summer.getBytesPerChecksum();
        ByteBuf newBuf = this.alloc.directBuffer(this.guess(dataLen)).ensureWritable(trailingPartialChunkLen);
        if (trailingPartialChunkLen != 0) {
            this.buf.readerIndex(dataLen - trailingPartialChunkLen).readBytes(newBuf, trailingPartialChunkLen);
        }
        this.buf.release();
        this.buf = newBuf;
        this.nextPacketOffsetInBlock += (long)(dataLen - trailingPartialChunkLen);
    }

    @Override
    public CompletableFuture<Long> flush(boolean syncBlock) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        if (this.eventLoop.inEventLoop()) {
            this.flush0(future, syncBlock);
        } else {
            this.eventLoop.execute(() -> this.flush0(future, syncBlock));
        }
        return future;
    }

    private void endBlock(Promise<Void> promise, long size) {
        if (this.state != State.STREAMING) {
            promise.tryFailure((Throwable)new IOException("stream already broken"));
            return;
        }
        if (!this.waitingAckQueue.isEmpty()) {
            promise.tryFailure((Throwable)new IllegalStateException("should call flush first before calling close"));
            return;
        }
        this.state = State.CLOSING;
        PacketHeader header = new PacketHeader(4, size, this.nextPacketSeqno, true, 0, false);
        this.buf.release();
        this.buf = null;
        int headerLen = header.getSerializedSize();
        ByteBuf headerBuf = this.alloc.directBuffer(headerLen);
        header.putInBuffer(headerBuf.nioBuffer(0, headerLen));
        headerBuf.writerIndex(headerLen);
        this.waitingAckQueue.add(new Callback(promise, size, this.datanodeList));
        this.datanodeList.forEach(ch -> ch.writeAndFlush((Object)headerBuf.duplicate().retain()));
        headerBuf.release();
    }

    @Override
    public void recoverAndClose(CancelableProgressable reporter) throws IOException {
        assert (!this.eventLoop.inEventLoop());
        this.datanodeList.forEach(ch -> ch.closeFuture().awaitUninterruptibly());
        FanOutOneBlockAsyncDFSOutputHelper.endFileLease(this.client, this.fileId);
        this.fsUtils.recoverFileLease((FileSystem)this.dfs, new Path(this.src), this.conf, reporter == null ? new FanOutOneBlockAsyncDFSOutputHelper.CancelOnClose(this.client) : reporter);
    }

    @Override
    public void close() throws IOException {
        assert (!this.eventLoop.inEventLoop());
        Promise promise = this.eventLoop.newPromise();
        this.eventLoop.execute(() -> this.endBlock((Promise<Void>)promise, this.nextPacketOffsetInBlock + (long)this.buf.readableBytes()));
        promise.addListener(f -> this.datanodeList.forEach(ch -> ch.close())).syncUninterruptibly();
        this.datanodeList.forEach(ch -> ch.closeFuture().awaitUninterruptibly());
        FanOutOneBlockAsyncDFSOutputHelper.completeFile(this.client, this.namenode, this.src, this.clientName, this.locatedBlock.getBlock(), this.fileId);
    }

    @VisibleForTesting
    int guess(int bytesWritten) {
        if (bytesWritten > this.capacity) {
            if (this.capacity << 1 <= 0x8000000) {
                this.capacity <<= 1;
            }
        } else if (this.capacity >> 1 >= bytesWritten) {
            this.capacity >>= 1;
        }
        return this.capacity;
    }

    @ChannelHandler.Sharable
    private final class AckHandler
    extends SimpleChannelInboundHandler<DataTransferProtos.PipelineAckProto> {
        private final int timeoutMs;

        public AckHandler(int timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        protected void channelRead0(ChannelHandlerContext ctx, DataTransferProtos.PipelineAckProto ack) throws Exception {
            DataTransferProtos.Status reply = FanOutOneBlockAsyncDFSOutputHelper.getStatus(ack);
            if (reply != DataTransferProtos.Status.SUCCESS) {
                FanOutOneBlockAsyncDFSOutput.this.failed(ctx.channel(), () -> new IOException("Bad response " + reply + " for block " + FanOutOneBlockAsyncDFSOutput.this.locatedBlock.getBlock() + " from datanode " + ctx.channel().remoteAddress()));
                return;
            }
            if (PipelineAck.isRestartOOBStatus((DataTransferProtos.Status)reply)) {
                FanOutOneBlockAsyncDFSOutput.this.failed(ctx.channel(), () -> new IOException("Restart response " + reply + " for block " + FanOutOneBlockAsyncDFSOutput.this.locatedBlock.getBlock() + " from datanode " + ctx.channel().remoteAddress()));
                return;
            }
            if (ack.getSeqno() == -1L) {
                return;
            }
            FanOutOneBlockAsyncDFSOutput.this.completed(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            FanOutOneBlockAsyncDFSOutput.this.failed(ctx.channel(), () -> new IOException("Connection to " + ctx.channel().remoteAddress() + " closed"));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            FanOutOneBlockAsyncDFSOutput.this.failed(ctx.channel(), () -> cause);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent e = (IdleStateEvent)evt;
                if (e.state() == IdleState.READER_IDLE) {
                    FanOutOneBlockAsyncDFSOutput.this.failed(ctx.channel(), () -> new IOException("Timeout(" + this.timeoutMs + "ms) waiting for response"));
                } else if (e.state() == IdleState.WRITER_IDLE) {
                    PacketHeader heartbeat = new PacketHeader(4, 0L, -1L, false, 0, false);
                    int len = heartbeat.getSerializedSize();
                    ByteBuf buf = FanOutOneBlockAsyncDFSOutput.this.alloc.buffer(len);
                    heartbeat.putInBuffer(buf.nioBuffer(0, len));
                    buf.writerIndex(len);
                    ctx.channel().writeAndFlush((Object)buf);
                }
                return;
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    private static enum State {
        STREAMING,
        CLOSING,
        BROKEN,
        CLOSED;

    }

    private static final class Callback {
        private final Promise<Void> promise;
        private final long ackedLength;
        private final Set<Channel> unfinishedReplicas;

        public Callback(Promise<Void> promise, long ackedLength, Collection<Channel> replicas) {
            this.promise = promise;
            this.ackedLength = ackedLength;
            if (replicas.isEmpty()) {
                this.unfinishedReplicas = Collections.emptySet();
            } else {
                this.unfinishedReplicas = Collections.newSetFromMap(new IdentityHashMap(replicas.size()));
                this.unfinishedReplicas.addAll(replicas);
            }
        }
    }
}

