/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ObserverContextImpl<E extends CoprocessorEnvironment>
implements ObserverContext<E> {
    private E env;
    private boolean bypass;
    private final boolean bypassable;
    private boolean complete;
    private final boolean completable;
    private final User caller;

    public ObserverContextImpl(User caller) {
        this(caller, false, false);
    }

    public ObserverContextImpl(User caller, boolean bypassable, boolean completable) {
        this.caller = caller;
        this.bypassable = bypassable;
        this.completable = completable;
    }

    @Override
    public E getEnvironment() {
        return this.env;
    }

    public void prepare(E env) {
        this.env = env;
    }

    public boolean isBypassable() {
        return this.bypassable;
    }

    @Override
    public void bypass() {
        if (!this.bypassable) {
            throw new UnsupportedOperationException("This method does not support 'bypass'.");
        }
        this.bypass = true;
    }

    public boolean isCompleable() {
        return this.completable;
    }

    @Override
    public void complete() {
        if (!this.completable) {
            throw new UnsupportedOperationException("This method does not support 'complete'.");
        }
        this.complete = true;
    }

    public boolean shouldBypass() {
        if (!this.isBypassable()) {
            return false;
        }
        if (this.bypass) {
            this.bypass = false;
            return true;
        }
        return false;
    }

    public boolean shouldComplete() {
        if (!this.isCompleable()) {
            return false;
        }
        if (this.complete) {
            this.complete = false;
            return true;
        }
        return false;
    }

    @Override
    public Optional<User> getCaller() {
        return Optional.ofNullable(this.caller);
    }

    @Deprecated
    @VisibleForTesting
    public static <E extends CoprocessorEnvironment> ObserverContext<E> createAndPrepare(E env) {
        ObserverContextImpl<E> ctx = new ObserverContextImpl<E>(RpcServer.getRequestUser().orElse(null));
        ctx.prepare(env);
        return ctx;
    }
}

