/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.common.io.encoded.MemoryBufferOrBuffers;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapIoDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.MemoryManager;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileEstimateErrors;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;

public class MetadataCache
implements LlapIoDebugDump,
FileMetadataCache {
    private final ConcurrentHashMap<Object, LlapBufferOrBuffers> metadata = new ConcurrentHashMap();
    private final ConcurrentHashMap<Object, OrcFileEstimateErrors> estimateErrors;
    private final MemoryManager memoryManager;
    private final LowLevelCachePolicy policy;
    private final BuddyAllocator allocator;
    private final LlapDaemonCacheMetrics metrics;

    public MetadataCache(BuddyAllocator allocator, MemoryManager memoryManager, LowLevelCachePolicy policy, boolean useEstimateCache, LlapDaemonCacheMetrics metrics) {
        this.memoryManager = memoryManager;
        this.allocator = allocator;
        this.policy = policy;
        this.metrics = metrics;
        this.estimateErrors = useEstimateCache ? new ConcurrentHashMap() : null;
    }

    public void putIncompleteCbs(Object fileKey, DiskRange[] ranges, long baseOffset, AtomicBoolean isStopped) {
        if (this.estimateErrors == null) {
            return;
        }
        OrcFileEstimateErrors errorData = this.estimateErrors.get(fileKey);
        boolean isNew = false;
        if (errorData == null) {
            errorData = new OrcFileEstimateErrors(fileKey);
            for (DiskRange range : ranges) {
                errorData.addError(range.getOffset(), range.getLength(), baseOffset);
            }
            long memUsage = errorData.estimateMemoryUsage();
            this.memoryManager.reserveMemory(memUsage, isStopped);
            OrcFileEstimateErrors old = this.estimateErrors.putIfAbsent(fileKey, errorData);
            if (old != null) {
                errorData = old;
                this.memoryManager.releaseMemory(memUsage);
                this.policy.notifyLock(errorData);
            } else {
                isNew = true;
                this.policy.cache(errorData, LowLevelCache.Priority.NORMAL);
            }
        } else {
            this.policy.notifyLock(errorData);
        }
        if (!isNew) {
            for (DiskRange range : ranges) {
                errorData.addError(range.getOffset(), range.getLength(), baseOffset);
            }
        }
        this.policy.notifyUnlock(errorData);
    }

    public DiskRangeList getIncompleteCbs(Object fileKey, DiskRangeList ranges, long baseOffset, DataCache.BooleanRef gotAllData) {
        if (this.estimateErrors == null) {
            return ranges;
        }
        OrcFileEstimateErrors errors = this.estimateErrors.get(fileKey);
        if (errors == null) {
            return ranges;
        }
        this.policy.notifyLock(errors);
        this.policy.notifyUnlock(errors);
        return errors.getIncompleteCbs(ranges, baseOffset, gotAllData);
    }

    public void notifyEvicted(LlapMetadataBuffer<?> buffer) {
        LlapBufferOrBuffers removed = this.metadata.remove(buffer.getKey());
        if (removed == null) {
            return;
        }
        if (removed.getSingleBuffer() != null) {
            assert (removed.getSingleBuffer() == buffer);
            return;
        }
        this.discardMultiBuffer(removed);
    }

    public void notifyEvicted(OrcFileEstimateErrors buffer) {
        this.estimateErrors.remove(buffer.getFileKey());
    }

    @Override
    public void debugDumpShort(StringBuilder sb) {
        sb.append("\nMetadata cache state: ").append(this.metadata.size()).append(" files and stripes, ").append(this.metadata.values().parallelStream().mapToLong(value -> {
            if (value.getSingleLlapBuffer() != null) {
                return value.getSingleLlapBuffer().allocSize;
            }
            long sum = 0L;
            for (LlapAllocatorBuffer llapMetadataBuffer : value.getMultipleLlapBuffers()) {
                sum += (long)llapMetadataBuffer.allocSize;
            }
            return sum;
        }).sum()).append(" total used bytes, ").append(this.estimateErrors.size()).append(" files w/ORC estimate");
    }

    public LlapBufferOrBuffers getFileMetadata(Object fileKey) {
        return this.getInternal(fileKey);
    }

    public LlapBufferOrBuffers getStripeTail(OrcBatchKey stripeKey) {
        return this.getInternal(new StripeKey(stripeKey.fileKey, stripeKey.stripeIx));
    }

    private LlapBufferOrBuffers getInternal(Object key) {
        LlapBufferOrBuffers result = this.metadata.get(key);
        if (result == null) {
            return null;
        }
        if (!this.lockBuffer(result, true)) {
            this.metadata.remove(key, result);
            return null;
        }
        return result;
    }

    public MemoryBufferOrBuffers putFileMetadata(Object fileKey, ByteBuffer tailBuffer) {
        return this.putInternal(fileKey, tailBuffer, null, null);
    }

    public MemoryBufferOrBuffers putFileMetadata(Object fileKey, ByteBuffer tailBuffer, CacheTag tag) {
        return this.putInternal(fileKey, tailBuffer, tag, null);
    }

    public MemoryBufferOrBuffers putFileMetadata(Object fileKey, int length, InputStream is) throws IOException {
        return this.putFileMetadata(fileKey, length, is, null, null);
    }

    public LlapBufferOrBuffers putStripeTail(OrcBatchKey stripeKey, ByteBuffer tailBuffer, CacheTag tag, AtomicBoolean isStopped) {
        return this.putInternal(new StripeKey(stripeKey.fileKey, stripeKey.stripeIx), tailBuffer, tag, isStopped);
    }

    public MemoryBufferOrBuffers putFileMetadata(Object fileKey, int length, InputStream is, CacheTag tag) throws IOException {
        return this.putFileMetadata(fileKey, length, is, tag, null);
    }

    public LlapBufferOrBuffers putFileMetadata(Object fileKey, ByteBuffer tailBuffer, CacheTag tag, AtomicBoolean isStopped) {
        return this.putInternal(fileKey, tailBuffer, tag, isStopped);
    }

    public LlapBufferOrBuffers putFileMetadata(Object fileKey, int length, InputStream is, CacheTag tag, AtomicBoolean isStopped) throws IOException {
        LlapBufferOrBuffers result = null;
        while (true) {
            LlapBufferOrBuffers oldVal;
            if ((oldVal = this.metadata.get(fileKey)) == null) {
                if (!this.lockBuffer(result = this.wrapBbForFile(result, fileKey, length, is, tag, isStopped), false)) {
                    throw new AssertionError((Object)("Cannot lock a newly created value " + result));
                }
                oldVal = this.metadata.putIfAbsent(fileKey, result);
                if (oldVal == null) {
                    this.cacheInPolicy(result);
                    return result;
                }
            }
            if (this.lockOldVal(fileKey, result, oldVal)) {
                return oldVal;
            }
            this.metadata.remove(fileKey, oldVal);
        }
    }

    private LlapBufferOrBuffers wrapBbForFile(LlapBufferOrBuffers result, Object fileKey, int length, InputStream stream, CacheTag tag, AtomicBoolean isStopped) throws IOException {
        int smallSize;
        if (result != null) {
            return result;
        }
        int maxAlloc = this.allocator.getMaxAllocation();
        MemoryBuffer[] largeBuffers = null;
        if (maxAlloc < length) {
            int i;
            largeBuffers = new LlapMetadataBuffer[length / maxAlloc];
            for (i = 0; i < largeBuffers.length; ++i) {
                largeBuffers[i] = new LlapMetadataBuffer<Object>(fileKey, tag);
            }
            this.allocator.allocateMultiple(largeBuffers, maxAlloc, null, isStopped);
            for (i = 0; i < largeBuffers.length; ++i) {
                MetadataCache.readIntoCacheBuffer(stream, maxAlloc, largeBuffers[i]);
            }
        }
        if ((smallSize = length % maxAlloc) == 0) {
            return new LlapMetadataBuffers((LlapMetadataBuffer<T>[])largeBuffers);
        }
        MemoryBuffer[] smallBuffer = new LlapMetadataBuffer[]{new LlapMetadataBuffer<Object>(fileKey, tag)};
        this.allocator.allocateMultiple(smallBuffer, length, null, isStopped);
        MetadataCache.readIntoCacheBuffer(stream, smallSize, smallBuffer[0]);
        if (largeBuffers == null) {
            return smallBuffer[0];
        }
        LlapMetadataBuffer[] cacheData = new LlapMetadataBuffer[largeBuffers.length + 1];
        System.arraycopy(largeBuffers, 0, cacheData, 0, largeBuffers.length);
        cacheData[largeBuffers.length] = smallBuffer[0];
        return new LlapMetadataBuffers(cacheData);
    }

    private static void readIntoCacheBuffer(InputStream stream, int length, MemoryBuffer dest) throws IOException {
        ByteBuffer bb = dest.getByteBufferRaw();
        int pos = bb.position();
        bb.limit(pos + length);
        FileUtils.readFully((InputStream)stream, (int)length, (ByteBuffer)bb);
        bb.position(pos);
    }

    private <T> LlapBufferOrBuffers putInternal(T key, ByteBuffer tailBuffer, CacheTag tag, AtomicBoolean isStopped) {
        LlapBufferOrBuffers result = null;
        while (true) {
            LlapBufferOrBuffers oldVal;
            if ((oldVal = this.metadata.get(key)) == null && (oldVal = this.metadata.putIfAbsent(key, result = this.wrapBb(result, key, tailBuffer, tag, isStopped))) == null) {
                this.cacheInPolicy(result);
                return result;
            }
            if (this.lockOldVal(key, result, oldVal)) {
                return oldVal;
            }
            this.metadata.remove(key, oldVal);
        }
    }

    private void cacheInPolicy(LlapBufferOrBuffers buffers) {
        LlapAllocatorBuffer singleBuffer = buffers.getSingleLlapBuffer();
        if (singleBuffer != null) {
            this.policy.cache(singleBuffer, LowLevelCache.Priority.HIGH);
            return;
        }
        for (LlapAllocatorBuffer buffer : buffers.getMultipleLlapBuffers()) {
            this.policy.cache(buffer, LowLevelCache.Priority.HIGH);
        }
    }

    private <T extends LlapBufferOrBuffers> boolean lockOldVal(Object key, T newVal, T oldVal) {
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Trying to cache when metadata is already cached for {}; old {}, new {}", new Object[]{key, oldVal, newVal});
        }
        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOCKING_LOGGER.trace("Locking {} due to cache collision", oldVal);
        }
        if (this.lockBuffer(oldVal, true)) {
            if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} due to cache collision with {}", newVal, oldVal);
            }
            if (newVal != null) {
                this.unlockBuffer(newVal, false);
            }
            return true;
        }
        return false;
    }

    public void decRefBuffer(MemoryBufferOrBuffers buffer) {
        if (!(buffer instanceof LlapBufferOrBuffers)) {
            throw new AssertionError(buffer.getClass());
        }
        this.unlockBuffer((LlapBufferOrBuffers)buffer, true);
    }

    private <T> LlapBufferOrBuffers wrapBb(LlapBufferOrBuffers result, T key, ByteBuffer tailBuffer, CacheTag tag, AtomicBoolean isStopped) {
        if (result != null) {
            return result;
        }
        if (tailBuffer.remaining() <= this.allocator.getMaxAllocation()) {
            return this.wrapSmallBb(new LlapMetadataBuffer<T>(key, tag), tailBuffer, isStopped);
        }
        int allocCount = this.determineAllocCount(tailBuffer);
        LlapAllocatorBuffer[] results = new LlapMetadataBuffer[allocCount];
        for (int i = 0; i < allocCount; ++i) {
            results[i] = new LlapMetadataBuffer<T>(key, tag);
        }
        this.wrapLargeBb(results, tailBuffer, isStopped);
        return new LlapMetadataBuffers((LlapMetadataBuffer<T>[])results);
    }

    private <T extends LlapAllocatorBuffer> T wrapSmallBb(T result, ByteBuffer tailBuffer, AtomicBoolean isStopped) {
        this.allocator.allocateMultiple(new MemoryBuffer[]{result}, tailBuffer.remaining(), null, isStopped);
        return this.putBufferToDest(tailBuffer.duplicate(), result);
    }

    private <T extends LlapAllocatorBuffer> void wrapLargeBb(T[] results, ByteBuffer tailBuffer, AtomicBoolean isStopped) {
        this.allocator.allocateMultiple((MemoryBuffer[])results, this.allocator.getMaxAllocation(), null, isStopped);
        ByteBuffer src = tailBuffer.duplicate();
        int pos = src.position();
        int remaining = src.remaining();
        for (int i = 0; i < results.length; ++i) {
            T result = results[i];
            int toPut = Math.min(remaining, ((LlapAllocatorBuffer)result).getByteBufferRaw().remaining());
            assert (toPut > 0);
            src.position(pos);
            src.limit(pos + toPut);
            pos += toPut;
            remaining -= toPut;
            this.putBufferToDest(src, result);
        }
    }

    private <T extends LlapAllocatorBuffer> T putBufferToDest(ByteBuffer src, T result) {
        ByteBuffer dest = result.getByteBufferRaw();
        int startPos = dest.position();
        dest.put(src);
        int newPos = dest.position();
        dest.position(startPos);
        dest.limit(newPos);
        boolean canLock = this.lockOneBuffer(result, false);
        assert (canLock);
        return result;
    }

    public int determineAllocCount(ByteBuffer tailBuffer) {
        int total = tailBuffer.remaining();
        int maxAlloc = this.allocator.getMaxAllocation();
        return total / maxAlloc + (total % maxAlloc > 0 ? 1 : 0);
    }

    private boolean lockBuffer(LlapBufferOrBuffers buffers, boolean doNotifyPolicy) {
        LlapAllocatorBuffer buffer = buffers.getSingleLlapBuffer();
        if (buffer != null) {
            return this.lockOneBuffer(buffer, doNotifyPolicy);
        }
        LlapAllocatorBuffer[] bufferArray = buffers.getMultipleLlapBuffers();
        for (int i = 0; i < bufferArray.length; ++i) {
            if (this.lockOneBuffer(bufferArray[i], doNotifyPolicy)) continue;
            for (int j = 0; j < i; ++j) {
                this.unlockSingleBuffer(buffer, true);
            }
            this.discardMultiBuffer(buffers);
            return false;
        }
        return true;
    }

    private void discardMultiBuffer(LlapBufferOrBuffers removed) {
        long memoryFreed = 0L;
        block5: for (LlapAllocatorBuffer buf : removed.getMultipleLlapBuffers()) {
            long memUsage = buf.getMemoryUsage();
            int result = buf.invalidate();
            switch (result) {
                case 2: {
                    continue block5;
                }
                case 1: {
                    continue block5;
                }
                case 0: {
                    memoryFreed += memUsage;
                    this.allocator.deallocateEvicted(buf);
                    continue block5;
                }
                default: {
                    throw new AssertionError(result);
                }
            }
        }
        this.memoryManager.releaseMemory(memoryFreed);
    }

    public boolean lockOneBuffer(LlapAllocatorBuffer buffer, boolean doNotifyPolicy) {
        int rc = buffer.incRef();
        if (rc > 0) {
            this.metrics.incrCacheNumLockedBuffers();
        }
        if (doNotifyPolicy && rc == 1) {
            this.policy.notifyLock(buffer);
        }
        return rc > 0;
    }

    private void unlockBuffer(LlapBufferOrBuffers buffers, boolean isCached) {
        LlapAllocatorBuffer singleBuffer = buffers.getSingleLlapBuffer();
        if (singleBuffer != null) {
            this.unlockSingleBuffer(singleBuffer, isCached);
            return;
        }
        for (LlapAllocatorBuffer buffer : buffers.getMultipleLlapBuffers()) {
            this.unlockSingleBuffer(buffer, isCached);
        }
    }

    private void unlockSingleBuffer(LlapAllocatorBuffer buffer, boolean isCached) {
        boolean isLastDecref;
        boolean bl = isLastDecref = buffer.decRef() == 0;
        if (isLastDecref) {
            if (isCached) {
                this.policy.notifyUnlock(buffer);
            } else {
                this.allocator.deallocate(buffer);
            }
        }
        this.metrics.decrCacheNumLockedBuffers();
    }

    public static final class LlapMetadataBuffers<T>
    implements LlapBufferOrBuffers {
        private final LlapMetadataBuffer<T>[] buffers;

        public LlapMetadataBuffers(LlapMetadataBuffer<T>[] buffers) {
            this.buffers = buffers;
        }

        public LlapAllocatorBuffer getSingleBuffer() {
            return null;
        }

        public LlapAllocatorBuffer[] getMultipleBuffers() {
            return this.buffers;
        }

        @Override
        public LlapAllocatorBuffer getSingleLlapBuffer() {
            return null;
        }

        @Override
        public LlapAllocatorBuffer[] getMultipleLlapBuffers() {
            return this.buffers;
        }
    }

    public static final class LlapMetadataBuffer<T>
    extends LlapAllocatorBuffer
    implements LlapBufferOrBuffers {
        private final T key;
        private CacheTag tag;

        public LlapMetadataBuffer(T key, CacheTag tag) {
            this.key = key;
            this.tag = tag;
        }

        @Override
        public void notifyEvicted(EvictionDispatcher evictionDispatcher) {
            evictionDispatcher.notifyEvicted(this);
        }

        public T getKey() {
            return this.key;
        }

        public LlapAllocatorBuffer getSingleBuffer() {
            return this;
        }

        public LlapAllocatorBuffer[] getMultipleBuffers() {
            return null;
        }

        @Override
        public LlapAllocatorBuffer getSingleLlapBuffer() {
            return this;
        }

        @Override
        public LlapAllocatorBuffer[] getMultipleLlapBuffers() {
            return null;
        }

        @Override
        public CacheTag getTag() {
            return this.tag;
        }
    }

    public static interface LlapBufferOrBuffers
    extends MemoryBufferOrBuffers {
        public LlapAllocatorBuffer getSingleLlapBuffer();

        public LlapAllocatorBuffer[] getMultipleLlapBuffers();
    }

    private static final class StripeKey {
        private final Object fileKey;
        private final int stripeIx;

        public StripeKey(Object fileKey, int stripeIx) {
            this.fileKey = fileKey;
            this.stripeIx = stripeIx;
        }

        public int hashCode() {
            int prime = 31;
            return (31 + (this.fileKey == null ? 0 : this.fileKey.hashCode())) * 31 + this.stripeIx;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StripeKey)) {
                return false;
            }
            StripeKey other = (StripeKey)obj;
            return this.fileKey == null == (other.fileKey == null) && (this.fileKey == null || this.fileKey.equals(other.fileKey)) && this.stripeIx == other.stripeIx;
        }
    }
}

