/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.metadata.MetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;

public final class LowLevelLrfuCachePolicy
implements LowLevelCachePolicy {
    private final double lambda;
    private static final double F0 = 1.0;
    private final AtomicLong timer = new AtomicLong(0L);
    private LlapCacheableBuffer[] heap;
    private final ReentrantLock heapLock = new ReentrantLock();
    private final ReentrantLock listLock = new ReentrantLock();
    private LlapCacheableBuffer listHead;
    private LlapCacheableBuffer listTail;
    private int heapSize = 0;
    private final int maxHeapSize;
    private EvictionListener evictionListener;
    private final PolicyMetrics metrics;
    private final ThreadLocal<LlapCacheableBuffer[]> threadLocalBuffers;
    private final ThreadLocal<Integer> threadLocalCount;
    private final int maxQueueSize;

    private double f(long x) {
        return Math.pow(0.5, this.lambda * (double)x);
    }

    private double touchPriority(long time, long lastAccess, double previous) {
        return 1.0 + this.f(time - lastAccess) * previous;
    }

    private double expirePriority(long time, long lastAccess, double previous) {
        return this.f(time - lastAccess) * previous;
    }

    public LowLevelLrfuCachePolicy(int minBufferSize, long maxSize, Configuration conf) {
        this.maxQueueSize = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LRFU_BP_WRAPPER_SIZE);
        this.lambda = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_LRFU_LAMBDA);
        int maxBuffers = (int)Math.ceil((double)maxSize * 1.0 / (double)minBufferSize);
        if (this.lambda == 0.0) {
            this.maxHeapSize = maxBuffers;
        } else {
            int lrfuThreshold = (int)(Math.log(1.0 - Math.pow(0.5, this.lambda)) / Math.log(0.5) / this.lambda);
            this.maxHeapSize = Math.min(lrfuThreshold, maxBuffers);
        }
        LlapIoImpl.LOG.info("LRFU cache policy with min buffer size {} and lambda {} (heap size {})", new Object[]{minBufferSize, this.lambda, this.maxHeapSize});
        this.heap = new LlapCacheableBuffer[this.maxHeapSize];
        this.listHead = null;
        this.listTail = null;
        String sessID = conf.get("llap.daemon.metrics.sessionid");
        if (null == sessID) {
            sessID = "<unknown>";
        }
        this.metrics = new PolicyMetrics(sessID);
        LlapMetricsSystem.instance().register("LowLevelLrfuCachePolicy-" + MetricsUtils.getHostName(), null, (Object)this.metrics);
        this.threadLocalBuffers = ThreadLocal.withInitial(() -> new LlapCacheableBuffer[this.maxQueueSize]);
        this.threadLocalCount = ThreadLocal.withInitial(() -> 0);
    }

    @Override
    public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority priority) {
        assert (buffer.lastUpdate == -1L);
        long time = this.timer.incrementAndGet();
        buffer.priority = 1.0;
        buffer.lastUpdate = time;
        if (priority == LowLevelCache.Priority.HIGH) {
            buffer.priority *= 3.0;
        } else assert (priority == LowLevelCache.Priority.NORMAL);
    }

    @Override
    public void notifyLock(LlapCacheableBuffer buffer) {
        if (buffer.indexInHeap != -2 || !this.listLock.tryLock()) {
            return;
        }
        this.removeFromListAndUnlock(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyUnlock(LlapCacheableBuffer buffer) {
        int count = this.threadLocalCount.get();
        LlapCacheableBuffer[] cacheableBuffers = this.threadLocalBuffers.get();
        if (count < this.maxQueueSize) {
            cacheableBuffers[count] = buffer;
            this.threadLocalCount.set(++count);
        }
        if (count <= this.maxQueueSize / 2) {
            return;
        }
        if (count == this.maxQueueSize) {
            this.heapLock.lock();
            try {
                this.doNotifyUnderHeapLock(count, cacheableBuffers);
            }
            finally {
                this.threadLocalCount.set(0);
                this.heapLock.unlock();
            }
            return;
        }
        if (this.heapLock.tryLock()) {
            try {
                this.doNotifyUnderHeapLock(count, cacheableBuffers);
            }
            finally {
                this.threadLocalCount.set(0);
                this.heapLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotifyUnderHeapLock(int count, LlapCacheableBuffer[] cacheableBuffers) {
        for (int i = 0; i < count; ++i) {
            LlapCacheableBuffer buffer = cacheableBuffers[i];
            long time = this.timer.incrementAndGet();
            if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                LlapIoImpl.CACHE_LOGGER.trace("Touching {} at {}", (Object)buffer, (Object)time);
            }
            buffer.priority = buffer.lastUpdate == -1L ? 1.0 : this.touchPriority(time, buffer.lastUpdate, buffer.priority);
            buffer.lastUpdate = time;
            if (buffer.indexInHeap == -2) {
                this.listLock.lock();
                this.removeFromListAndUnlock(buffer);
            }
            if (buffer.indexInHeap >= 0) {
                this.heapifyDownUnderLock(buffer, time);
                continue;
            }
            if (this.heapSize == this.heap.length) {
                LlapCacheableBuffer demoted = this.heap[0];
                this.listLock.lock();
                try {
                    assert (demoted.indexInHeap == 0);
                    demoted.indexInHeap = -2;
                    demoted.prev = null;
                    if (this.listHead != null) {
                        demoted.next = this.listHead;
                        this.listHead.prev = demoted;
                        this.listHead = demoted;
                    } else {
                        this.listHead = demoted;
                        this.listTail = demoted;
                        demoted.next = null;
                    }
                }
                finally {
                    this.listLock.unlock();
                }
                buffer.indexInHeap = 0;
                this.heapifyDownUnderLock(buffer, time);
                continue;
            }
            assert (this.heapSize < this.heap.length) : this.heap.length + " < " + this.heapSize;
            buffer.indexInHeap = this.heapSize++;
            this.heapifyUpUnderLock(buffer, time);
        }
    }

    @Override
    public void setEvictionListener(EvictionListener listener) {
        this.evictionListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purge() {
        int oldHeapSize;
        LlapCacheableBuffer[] oldHeap;
        LlapCacheableBuffer oldTail;
        long evicted = 0L;
        this.listLock.lock();
        try {
            LlapCacheableBuffer current = this.listTail;
            oldTail = this.listTail;
            while (current != null) {
                boolean canEvict = 0 == current.invalidate();
                current.indexInHeap = -1;
                if (canEvict) {
                    current = current.prev;
                    continue;
                }
                LlapCacheableBuffer newCurrent = current.prev;
                oldTail = LowLevelLrfuCachePolicy.removeFromLocalList(oldTail, current);
                current = newCurrent;
            }
            this.listHead = null;
            this.listTail = null;
        }
        finally {
            this.listLock.unlock();
        }
        this.heapLock.lock();
        try {
            oldHeap = this.heap;
            oldHeapSize = this.heapSize;
            this.heap = new LlapCacheableBuffer[this.maxHeapSize];
            this.heapSize = 0;
            for (int i = 0; i < oldHeapSize; ++i) {
                LlapCacheableBuffer result = oldHeap[i];
                result.indexInHeap = -1;
                int invalidateResult = result.invalidate();
                if (invalidateResult == 0) continue;
                oldHeap[i] = null;
            }
        }
        finally {
            this.heapLock.unlock();
        }
        LlapCacheableBuffer current = oldTail;
        while (current != null) {
            evicted += current.getMemoryUsage();
            this.evictionListener.notifyEvicted(current);
            current = current.prev;
        }
        for (int i = 0; i < oldHeapSize; ++i) {
            current = oldHeap[i];
            if (current == null) continue;
            evicted += current.getMemoryUsage();
            this.evictionListener.notifyEvicted(current);
        }
        LlapIoImpl.LOG.info("PURGE: evicted {} from LRFU policy", (Object)LlapUtil.humanReadableByteCount((long)evicted));
        return evicted;
    }

    private static LlapCacheableBuffer removeFromLocalList(LlapCacheableBuffer tail, LlapCacheableBuffer current) {
        if (current == tail) {
            tail = current.prev;
        } else {
            current.next.prev = current.prev;
        }
        if (current.prev != null) {
            current.prev.next = current.next;
        }
        current.prev = null;
        current.next = null;
        return tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evictSomeBlocks(long memoryToReserve) {
        long evicted = this.evictFromList(memoryToReserve);
        if (evicted >= memoryToReserve) {
            return evicted;
        }
        long time = this.timer.get();
        while (evicted < memoryToReserve) {
            LlapCacheableBuffer buffer;
            this.heapLock.lock();
            try {
                buffer = this.evictFromHeapUnderLock(time);
            }
            finally {
                this.heapLock.unlock();
            }
            if (buffer == null) {
                return evicted;
            }
            evicted += buffer.getMemoryUsage();
            this.evictionListener.notifyEvicted(buffer);
        }
        return evicted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictFromList(long memoryToReserve) {
        LlapCacheableBuffer firstCandidate;
        LlapCacheableBuffer nextCandidate;
        long evicted = 0L;
        this.listLock.lock();
        try {
            nextCandidate = this.listTail;
            firstCandidate = this.listTail;
            while (evicted < memoryToReserve && nextCandidate != null) {
                if (0 != nextCandidate.invalidate()) {
                    LlapCacheableBuffer lockedBuffer = nextCandidate;
                    if (firstCandidate == nextCandidate) {
                        firstCandidate = nextCandidate.prev;
                    }
                    nextCandidate = nextCandidate.prev;
                    this.removeFromListUnderLock(lockedBuffer);
                    continue;
                }
                nextCandidate.indexInHeap = -1;
                evicted += nextCandidate.getMemoryUsage();
                nextCandidate = nextCandidate.prev;
            }
            if (firstCandidate != nextCandidate) {
                if (nextCandidate == null) {
                    this.listHead = null;
                    this.listTail = null;
                } else {
                    this.removeFromListUnderLockNoStateUpdate(nextCandidate.next, firstCandidate);
                }
            }
        }
        finally {
            this.listLock.unlock();
        }
        while (firstCandidate != nextCandidate) {
            this.evictionListener.notifyEvicted(firstCandidate);
            firstCandidate = firstCandidate.prev;
        }
        return evicted;
    }

    private LlapCacheableBuffer evictFromHeapUnderLock(long time) {
        LlapCacheableBuffer result;
        do {
            if (this.heapSize != 0) continue;
            return null;
        } while ((result = this.evictHeapElementUnderLock(time, 0)) == null);
        return result;
    }

    private void heapifyUpUnderLock(LlapCacheableBuffer buffer, long time) {
        int parentIx;
        LlapCacheableBuffer parent;
        double parentPri;
        int ix = buffer.indexInHeap;
        double priority = buffer.priority;
        while (ix != 0 && !(priority >= (parentPri = this.getHeapifyPriority(parent = this.heap[parentIx = ix - 1 >>> 1], time)))) {
            this.heap[ix] = parent;
            parent.indexInHeap = ix;
            ix = parentIx;
        }
        buffer.indexInHeap = ix;
        this.heap[ix] = buffer;
    }

    private LlapCacheableBuffer evictHeapElementUnderLock(long time, int ix) {
        boolean canEvict;
        LlapCacheableBuffer result = this.heap[ix];
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Evicting {} at {}", (Object)result, (Object)time);
        }
        result.indexInHeap = -1;
        --this.heapSize;
        int invalidateResult = result.invalidate();
        boolean bl = canEvict = invalidateResult == 0;
        if (this.heapSize > 0) {
            LlapCacheableBuffer newRoot = this.heap[this.heapSize];
            newRoot.indexInHeap = ix;
            if (newRoot.lastUpdate != time) {
                newRoot.priority = this.expirePriority(time, newRoot.lastUpdate, newRoot.priority);
                newRoot.lastUpdate = time;
            }
            this.heapifyDownUnderLock(newRoot, time);
        }
        return canEvict ? result : null;
    }

    private void heapifyDownUnderLock(LlapCacheableBuffer buffer, long time) {
        int newIx;
        int ix = buffer.indexInHeap;
        double priority = buffer.priority;
        while ((newIx = this.moveMinChildUp(ix, time, priority)) != -1) {
            ix = newIx;
        }
        buffer.indexInHeap = ix;
        this.heap[ix] = buffer;
    }

    private int moveMinChildUp(int targetPos, long time, double comparePri) {
        int leftIx = (targetPos << 1) + 1;
        int rightIx = leftIx + 1;
        if (leftIx >= this.heapSize) {
            return -1;
        }
        LlapCacheableBuffer left = this.heap[leftIx];
        LlapCacheableBuffer right = null;
        if (rightIx < this.heapSize) {
            right = this.heap[rightIx];
        }
        double leftPri = this.getHeapifyPriority(left, time);
        double rightPri = this.getHeapifyPriority(right, time);
        if (comparePri >= 0.0 && comparePri <= leftPri && comparePri <= rightPri) {
            return -1;
        }
        if (leftPri <= rightPri) {
            this.heap[targetPos] = left;
            left.indexInHeap = targetPos;
            return leftIx;
        }
        this.heap[targetPos] = right;
        right.indexInHeap = targetPos;
        return rightIx;
    }

    private double getHeapifyPriority(LlapCacheableBuffer buf, long time) {
        if (buf == null) {
            return Double.MAX_VALUE;
        }
        if (buf.lastUpdate != time && time >= 0L) {
            buf.priority = this.expirePriority(time, buf.lastUpdate, buf.priority);
            buf.lastUpdate = time;
        }
        return buf.priority;
    }

    private void removeFromListAndUnlock(LlapCacheableBuffer buffer) {
        try {
            if (buffer.indexInHeap != -2) {
                return;
            }
            this.removeFromListUnderLock(buffer);
        }
        finally {
            this.listLock.unlock();
        }
    }

    private void removeFromListUnderLock(LlapCacheableBuffer buffer) {
        buffer.indexInHeap = -1;
        boolean isTail = buffer == this.listTail;
        boolean isHead = buffer == this.listHead;
        if (isTail != (buffer.next == null) || isHead != (buffer.prev == null)) {
            this.debugDumpListOnError(buffer);
            throw new AssertionError((Object)"LRFU list is corrupted.");
        }
        if (isTail) {
            this.listTail = buffer.prev;
        } else {
            buffer.next.prev = buffer.prev;
        }
        if (isHead) {
            this.listHead = buffer.next;
        } else {
            buffer.prev.next = buffer.next;
        }
    }

    private void removeFromListUnderLockNoStateUpdate(LlapCacheableBuffer from, LlapCacheableBuffer to) {
        boolean isToTail = to == this.listTail;
        boolean isFromHead = from == this.listHead;
        if (isToTail != (to.next == null) || isFromHead != (from.prev == null)) {
            this.debugDumpListOnError(from, to);
            throw new AssertionError((Object)"LRFU list is corrupted.");
        }
        if (isToTail) {
            this.listTail = from.prev;
        } else {
            to.next.prev = from.prev;
        }
        if (isFromHead) {
            this.listHead = to.next;
        } else {
            from.prev.next = to.next;
        }
    }

    private void debugDumpListOnError(LlapCacheableBuffer ... buffers) {
        StringBuilder listDump = new StringBuilder("Invalid list removal. List: ");
        try {
            LowLevelLrfuCachePolicy.dumpList(listDump, this.listHead, this.listTail);
            int i = 0;
            for (LlapCacheableBuffer buffer : buffers) {
                listDump.append("; list from the buffer #").append(i).append(" being removed: ");
                LowLevelLrfuCachePolicy.dumpList(listDump, buffer, null);
            }
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.error("Error dumping the lists on error", t);
        }
        LlapIoImpl.LOG.error(listDump.toString());
    }

    public String debugDumpHeap() {
        StringBuilder result = new StringBuilder("List: ");
        LowLevelLrfuCachePolicy.dumpList(result, this.listHead, this.listTail);
        result.append("\nHeap:");
        if (this.heapSize == 0) {
            result.append(" <empty>\n");
            return result.toString();
        }
        result.append("\n");
        int levels = 32 - Integer.numberOfLeadingZeros(this.heapSize);
        int ix = 0;
        int spacesCount = this.heap[0].toStringForCache().length() + 3;
        String full = StringUtils.repeat((String)" ", (int)spacesCount);
        String half = StringUtils.repeat((String)" ", (int)(spacesCount / 2));
        int maxWidth = 1 << levels - 1;
        for (int i = 0; i < levels; ++i) {
            int j;
            int width = 1 << i;
            int middleGap = (maxWidth - width) / width;
            for (j = 0; j < middleGap >>> 1; ++j) {
                result.append(full);
            }
            if ((middleGap & 1) == 1) {
                result.append(half);
            }
            for (j = 0; j < width && ix < this.heapSize; ++j, ++ix) {
                if (j != 0) {
                    for (int k = 0; k < middleGap; ++k) {
                        result.append(full);
                    }
                    if (middleGap == 0) {
                        result.append(" ");
                    }
                }
                if ((j & 1) == 0) {
                    result.append("(");
                }
                result.append(this.heap[ix].toStringForCache());
                if ((j & 1) != 1) continue;
                result.append(")");
            }
            result.append("\n");
        }
        return result.toString();
    }

    private static void dumpList(StringBuilder result, LlapCacheableBuffer listHeadLocal, LlapCacheableBuffer listTailLocal) {
        if (listHeadLocal == null) {
            result.append("<empty>");
            return;
        }
        LlapCacheableBuffer listItem = listHeadLocal;
        while (listItem.prev != null) {
            listItem = listItem.prev;
        }
        while (listItem != null) {
            result.append(listItem.toStringForCache());
            if (listItem == listTailLocal) {
                result.append("(tail)");
            }
            if (listItem == listHeadLocal) {
                result.append("(head)");
            }
            result.append(" -> ");
            listItem = listItem.next;
        }
    }

    @Override
    public void debugDumpShort(StringBuilder sb) {
        long[] metricData = this.metrics.getUsageStats();
        sb.append("\nLRFU eviction list: ").append(metricData[4]).append(" items");
        sb.append("\nLRFU eviction heap: ").append(this.heapSize).append(" items (of max ").append(this.maxHeapSize).append(")");
        sb.append("\nLRFU data on heap: ").append(LlapUtil.humanReadableByteCount((long)metricData[0]));
        sb.append("\nLRFU metadata on heap: ").append(LlapUtil.humanReadableByteCount((long)metricData[2]));
        sb.append("\nLRFU data on eviction list: ").append(LlapUtil.humanReadableByteCount((long)metricData[1]));
        sb.append("\nLRFU metadata on eviction list: ").append(LlapUtil.humanReadableByteCount((long)metricData[3]));
        sb.append("\nLRFU data locked: ").append(LlapUtil.humanReadableByteCount((long)metricData[5]));
        sb.append("\nLRFU metadata locked: ").append(LlapUtil.humanReadableByteCount((long)metricData[6]));
    }

    @Metrics(about="LRFU Cache Policy Metrics", context="cache")
    private class PolicyMetrics
    implements MetricsSource {
        public static final int DATAONHEAP = 0;
        public static final int DATAONLIST = 1;
        public static final int METAONHEAP = 2;
        public static final int METAONLIST = 3;
        public static final int LISTSIZE = 4;
        public static final int LOCKEDDATA = 5;
        public static final int LOCKEDMETA = 6;
        private final String session;

        PolicyMetrics(String session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long[] getUsageStats() {
            long dataOnHeap = 0L;
            long dataOnList = 0L;
            long metaOnHeap = 0L;
            long metaOnList = 0L;
            long listSize = 0L;
            long lockedData = 0L;
            long lockedMeta = 0L;
            LowLevelLrfuCachePolicy.this.heapLock.lock();
            try {
                for (int heapIdx = 0; heapIdx < LowLevelLrfuCachePolicy.this.heapSize; ++heapIdx) {
                    LlapCacheableBuffer buff = LowLevelLrfuCachePolicy.this.heap[heapIdx];
                    if (null == buff) continue;
                    if (buff instanceof MetadataCache.LlapMetadataBuffer) {
                        metaOnHeap += buff.getMemoryUsage();
                        if (!buff.isLocked()) continue;
                        lockedMeta += buff.getMemoryUsage();
                        continue;
                    }
                    dataOnHeap += buff.getMemoryUsage();
                    if (!buff.isLocked()) continue;
                    lockedData += buff.getMemoryUsage();
                }
            }
            finally {
                LowLevelLrfuCachePolicy.this.heapLock.unlock();
            }
            try {
                LowLevelLrfuCachePolicy.this.listLock.lock();
                LlapCacheableBuffer scan = LowLevelLrfuCachePolicy.this.listHead;
                while (null != scan) {
                    if (scan instanceof MetadataCache.LlapMetadataBuffer) {
                        metaOnList += scan.getMemoryUsage();
                        if (scan.isLocked()) {
                            lockedMeta += scan.getMemoryUsage();
                        }
                    } else {
                        dataOnList += scan.getMemoryUsage();
                        if (scan.isLocked()) {
                            lockedData += scan.getMemoryUsage();
                        }
                    }
                    ++listSize;
                    scan = scan.next;
                }
            }
            finally {
                LowLevelLrfuCachePolicy.this.listLock.unlock();
            }
            return new long[]{dataOnHeap, dataOnList, metaOnHeap, metaOnList, listSize, lockedData, lockedMeta};
        }

        public synchronized void getMetrics(MetricsCollector collector, boolean all) {
            long[] usageStats = this.getUsageStats();
            MetricsRecordBuilder mrb = collector.addRecord((MetricsInfo)PolicyInformation.PolicyMetrics).setContext("cache").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.session);
            mrb.addCounter((MetricsInfo)PolicyInformation.DataOnHeap, usageStats[0]).addCounter((MetricsInfo)PolicyInformation.DataOnList, usageStats[1]).addCounter((MetricsInfo)PolicyInformation.MetaOnHeap, usageStats[2]).addCounter((MetricsInfo)PolicyInformation.MetaOnList, usageStats[3]).addCounter((MetricsInfo)PolicyInformation.DataLocked, usageStats[5]).addCounter((MetricsInfo)PolicyInformation.MetaLocked, usageStats[6]).addCounter((MetricsInfo)PolicyInformation.HeapSize, LowLevelLrfuCachePolicy.this.heapSize).addCounter((MetricsInfo)PolicyInformation.HeapSizeMax, LowLevelLrfuCachePolicy.this.maxHeapSize).addCounter((MetricsInfo)PolicyInformation.ListSize, usageStats[4]).addCounter((MetricsInfo)PolicyInformation.TotalData, usageStats[0] + usageStats[1]).addCounter((MetricsInfo)PolicyInformation.TotalMeta, usageStats[2] + usageStats[3]);
        }
    }

    private static enum PolicyInformation implements MetricsInfo
    {
        PolicyMetrics("LRFU cache policy based metrics"),
        DataOnHeap("Amount of bytes used for data on min-heap"),
        DataOnList("Amount of bytes used for data on eviction short list"),
        MetaOnHeap("Amount of bytes used for meta data on min-heap"),
        MetaOnList("Amount of bytes used for meta data on eviction short list"),
        DataLocked("Amount of locked data in bytes (in use)"),
        MetaLocked("Amount of locked meta data in bytes (in use)"),
        HeapSize("Number of buffers on the min-heap"),
        HeapSizeMax("Capacity (number of buffers) of the min-heap"),
        ListSize("Number of buffers on the eviction short list"),
        TotalData("Total amount of bytes, used for data"),
        TotalMeta("Total amount of bytes, used for meta data");

        private final String description;

        private PolicyInformation(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }
}

