/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.FileCache;
import org.apache.hadoop.hive.llap.cache.FileCacheCleanupThread;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapIoDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheCounters;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hive.common.util.Ref;
import org.apache.orc.impl.RecordReaderUtils;

public class LowLevelCacheImpl
implements LowLevelCache,
BufferUsageManager,
LlapIoDebugDump {
    private static final int DEFAULT_CLEANUP_INTERVAL = 600;
    private final Allocator allocator;
    private final AtomicInteger newEvictions = new AtomicInteger(0);
    private Thread cleanupThread = null;
    private final ConcurrentHashMap<Object, FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>>> cache = new ConcurrentHashMap();
    private final LowLevelCachePolicy cachePolicy;
    private final long cleanupInterval;
    private final LlapDaemonCacheMetrics metrics;
    private final boolean doAssumeGranularBlocks;
    private static final Function<Void, ConcurrentSkipListMap<Long, LlapDataBuffer>> CACHE_CTOR = new Function<Void, ConcurrentSkipListMap<Long, LlapDataBuffer>>(){

        public ConcurrentSkipListMap<Long, LlapDataBuffer> apply(Void input) {
            return new ConcurrentSkipListMap<Long, LlapDataBuffer>();
        }
    };
    private static final ByteBuffer fakeBuf = ByteBuffer.wrap(new byte[1]);

    public LowLevelCacheImpl(LlapDaemonCacheMetrics metrics, LowLevelCachePolicy cachePolicy, Allocator allocator, boolean doAssumeGranularBlocks) {
        this(metrics, cachePolicy, allocator, doAssumeGranularBlocks, 600L);
    }

    @VisibleForTesting
    LowLevelCacheImpl(LlapDaemonCacheMetrics metrics, LowLevelCachePolicy cachePolicy, Allocator allocator, boolean doAssumeGranularBlocks, long cleanupInterval) {
        LlapIoImpl.LOG.info("Low level cache; cleanup interval {} sec", (Object)cleanupInterval);
        this.cachePolicy = cachePolicy;
        this.allocator = allocator;
        this.cleanupInterval = cleanupInterval;
        this.metrics = metrics;
        this.doAssumeGranularBlocks = doAssumeGranularBlocks;
    }

    public void startThreads() {
        if (this.cleanupInterval < 0L) {
            return;
        }
        this.cleanupThread = new CleanupThread(this.cache, this.newEvictions, this.cleanupInterval);
        this.cleanupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskRangeList getFileData(Object fileKey, DiskRangeList ranges, long baseOffset, DataCache.DiskRangeListFactory factory, LowLevelCacheCounters qfCounters, DataCache.BooleanRef gotAllData) {
        DiskRangeList current;
        if (ranges == null) {
            return null;
        }
        DiskRangeList prev = ranges.prev;
        FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>> subCache = this.cache.get(fileKey);
        if (subCache == null || !subCache.incRef()) {
            long totalMissed = ranges.getTotalLength();
            this.metrics.incrCacheRequestedBytes(totalMissed);
            if (qfCounters != null) {
                qfCounters.recordCacheMiss(totalMissed);
            }
            if (prev != null && gotAllData != null) {
                gotAllData.value = false;
            }
            return ranges;
        }
        try {
            if (prev == null) {
                prev = new DiskRangeList.MutateHelper(ranges);
            }
            if (gotAllData != null) {
                gotAllData.value = true;
            }
            DiskRangeList current2 = ranges;
            while (current2 != null) {
                this.metrics.incrCacheRequestedBytes(current2.getLength());
                DiskRangeList next = current2.next;
                this.getOverlappingRanges(baseOffset, current2, subCache.getCache(), factory, gotAllData);
                current2 = next;
            }
        }
        finally {
            subCache.decRef();
        }
        boolean isInvalid = false;
        if (qfCounters != null) {
            current = prev.next;
            long bytesHit = 0L;
            long bytesMissed = 0L;
            while (current != null) {
                if (current.hasData()) {
                    bytesHit += (long)current.getLength();
                } else {
                    if (gotAllData.value) {
                        isInvalid = true;
                    }
                    bytesMissed += (long)current.getLength();
                }
                current = current.next;
            }
            qfCounters.recordCacheHit(bytesHit);
            qfCounters.recordCacheMiss(bytesMissed);
        } else if (gotAllData != null && gotAllData.value) {
            current = prev.next;
            while (current != null) {
                if (!current.hasData()) {
                    isInvalid = true;
                    break;
                }
                current = current.next;
            }
        }
        if (isInvalid) {
            StringBuilder invalidMsg = new StringBuilder("Internal error - gotAllData=true but the resulting ranges are ").append(RecordReaderUtils.stringifyDiskRanges((DiskRangeList)prev.next));
            subCache = this.cache.get(fileKey);
            if (subCache != null && subCache.incRef()) {
                try {
                    invalidMsg.append("; cache ranges (not necessarily consistent) are ");
                    for (Map.Entry<Long, LlapDataBuffer> e : subCache.getCache().entrySet()) {
                        long start = e.getKey();
                        long end = start + (long)e.getValue().declaredCachedLength;
                        invalidMsg.append("[").append(start).append(", ").append(end).append("), ");
                    }
                }
                finally {
                    subCache.decRef();
                }
            } else {
                invalidMsg.append("; cache ranges can no longer be determined");
            }
            String s = invalidMsg.toString();
            LlapIoImpl.LOG.error(s);
            throw new RuntimeException(s);
        }
        return prev.next;
    }

    private void getOverlappingRanges(long baseOffset, DiskRangeList currentNotCached, ConcurrentSkipListMap<Long, LlapDataBuffer> cache, DataCache.DiskRangeListFactory factory, DataCache.BooleanRef gotAllData) {
        Long prevOffset;
        long absOffset = currentNotCached.getOffset() + baseOffset;
        if (!this.doAssumeGranularBlocks && (prevOffset = cache.floorKey(absOffset)) != null) {
            absOffset = prevOffset;
        }
        Iterator matches = cache.subMap((Object)absOffset, (Object)(currentNotCached.getEnd() + baseOffset)).entrySet().iterator();
        long cacheEnd = -1L;
        while (matches.hasNext()) {
            assert (currentNotCached != null);
            Map.Entry e = matches.next();
            LlapDataBuffer buffer = (LlapDataBuffer)e.getValue();
            long requestedLength = currentNotCached.getLength();
            if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                LlapIoImpl.LOCKING_LOGGER.trace("Locking {} during get", (Object)buffer);
            }
            if (!this.lockBuffer(buffer, true)) {
                matches.remove();
                if (gotAllData == null) continue;
                gotAllData.value = false;
                continue;
            }
            long cacheOffset = (Long)e.getKey();
            if (cacheEnd > cacheOffset) {
                throw new AssertionError((Object)("Cache has overlapping buffers: " + cacheEnd + ") and [" + cacheOffset + ", " + (cacheOffset + (long)buffer.declaredCachedLength) + ")"));
            }
            cacheEnd = cacheOffset + (long)buffer.declaredCachedLength;
            DiskRangeList currentCached = factory.createCacheChunk((MemoryBuffer)buffer, cacheOffset - baseOffset, cacheEnd - baseOffset);
            currentNotCached = this.addCachedBufferToIter(currentNotCached, currentCached, gotAllData);
            this.metrics.incrCacheHitBytes(Math.min(requestedLength, (long)currentCached.getLength()));
        }
        if (currentNotCached != null) {
            assert (!currentNotCached.hasData());
            if (gotAllData != null) {
                gotAllData.value = false;
            }
        }
    }

    private DiskRangeList addCachedBufferToIter(DiskRangeList currentNotCached, DiskRangeList currentCached, DataCache.BooleanRef gotAllData) {
        if (currentNotCached.getOffset() >= currentCached.getOffset()) {
            if (currentNotCached.getEnd() <= currentCached.getEnd()) {
                currentNotCached.replaceSelfWith(currentCached);
                return null;
            }
            currentNotCached.insertPartBefore(currentCached);
            return currentNotCached;
        }
        if (gotAllData != null) {
            gotAllData.value = false;
        }
        if (currentNotCached.getEnd() <= currentCached.getEnd()) {
            currentNotCached.insertPartAfter(currentCached);
            return null;
        }
        DiskRangeList tail = new DiskRangeList(currentCached.getEnd(), currentNotCached.getEnd());
        currentNotCached.insertPartAfter(currentCached);
        currentCached.insertAfter(tail);
        return tail;
    }

    private boolean lockBuffer(LlapDataBuffer buffer, boolean doNotifyPolicy) {
        int rc = buffer.incRef();
        if (rc > 0) {
            this.metrics.incrCacheNumLockedBuffers();
        }
        if (doNotifyPolicy && rc == 1) {
            this.cachePolicy.notifyLock(buffer);
        }
        return rc > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] putFileData(Object fileKey, DiskRange[] ranges, MemoryBuffer[] buffers, long baseOffset, LowLevelCache.Priority priority, LowLevelCacheCounters qfCounters, CacheTag tag) {
        long[] result = null;
        assert (buffers.length == ranges.length);
        FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>> subCache = FileCache.getOrAddFileSubCache(this.cache, fileKey, CACHE_CTOR);
        try {
            block3: for (int i = 0; i < ranges.length; ++i) {
                LlapDataBuffer buffer = (LlapDataBuffer)buffers[i];
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.LOCKING_LOGGER.trace("Locking {} at put time", (Object)buffer);
                }
                boolean canLock = this.lockBuffer(buffer, false);
                assert (canLock);
                long offset = ranges[i].getOffset() + baseOffset;
                assert (buffer.declaredCachedLength == -1);
                buffer.declaredCachedLength = ranges[i].getLength();
                buffer.setTag(tag);
                while (true) {
                    LlapDataBuffer oldVal;
                    if ((oldVal = subCache.getCache().putIfAbsent(offset, buffer)) == null) {
                        this.cachePolicy.cache(buffer, priority);
                        if (qfCounters == null) continue block3;
                        qfCounters.recordAllocBytes(buffer.byteBuffer.remaining(), buffer.allocSize);
                        continue block3;
                    }
                    if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.CACHE_LOGGER.trace("Trying to cache when the chunk is already cached for {}@{} (base {}); old {}, new {}", new Object[]{fileKey, offset, baseOffset, oldVal, buffer});
                    }
                    if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                        LlapIoImpl.LOCKING_LOGGER.trace("Locking {} due to cache collision", (Object)oldVal);
                    }
                    if (this.lockBuffer(oldVal, true)) {
                        if (oldVal.declaredCachedLength != buffer.declaredCachedLength) {
                            throw new RuntimeException("Found a block with different length at the same offset: " + oldVal.declaredCachedLength + " vs " + buffer.declaredCachedLength + " @" + offset + " (base " + baseOffset + ")");
                        }
                        if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                            LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} due to cache collision with {}", (Object)buffer, (Object)oldVal);
                        }
                        this.unlockBuffer(buffer, false);
                        buffers[i] = oldVal;
                        if (result == null) {
                            result = new long[LowLevelCacheImpl.align64(buffers.length) >>> 6];
                        }
                        int n = i >>> 6;
                        result[n] = result[n] | (long)(1 << (i & 0x3F));
                        continue block3;
                    }
                    subCache.getCache().remove(offset, oldVal);
                }
            }
        }
        finally {
            subCache.decRef();
        }
        return result;
    }

    private static int align64(int number) {
        return number + 63 & 0xFFFFFFC0;
    }

    @Override
    public void decRefBuffer(MemoryBuffer buffer) {
        this.unlockBuffer((LlapDataBuffer)buffer, true);
    }

    @Override
    public void decRefBuffers(List<MemoryBuffer> cacheBuffers) {
        for (MemoryBuffer b : cacheBuffers) {
            this.unlockBuffer((LlapDataBuffer)b, true);
        }
    }

    private void unlockBuffer(LlapDataBuffer buffer, boolean handleLastDecRef) {
        boolean isLastDecref;
        boolean bl = isLastDecref = buffer.decRef() == 0;
        if (handleLastDecRef && isLastDecref) {
            if (buffer.declaredCachedLength != -1) {
                this.cachePolicy.notifyUnlock(buffer);
            } else {
                if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                    LlapIoImpl.CACHE_LOGGER.trace("Deallocating {} that was not cached", (Object)buffer);
                }
                this.allocator.deallocate((MemoryBuffer)buffer);
            }
        }
        this.metrics.decrCacheNumLockedBuffers();
    }

    public static LlapDataBuffer allocateFake() {
        LlapDataBuffer fake = new LlapDataBuffer();
        fake.initialize(fakeBuf, 0, 1);
        return fake;
    }

    @Override
    public final void notifyEvicted(MemoryBuffer buffer) {
        this.newEvictions.incrementAndGet();
    }

    @Override
    public boolean incRefBuffer(MemoryBuffer buffer) {
        return this.lockBuffer((LlapDataBuffer)buffer, false);
    }

    @Override
    public Allocator getAllocator() {
        return this.allocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugDumpShort(StringBuilder sb) {
        sb.append("\nORC cache state ");
        int allLocked = 0;
        int allUnlocked = 0;
        int allEvicted = 0;
        int allMoving = 0;
        long totalUsedSpace = 0L;
        for (Map.Entry<Object, FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>>> e : this.cache.entrySet()) {
            if (!e.getValue().incRef()) continue;
            try {
                int fileLocked = 0;
                int fileUnlocked = 0;
                int fileEvicted = 0;
                int fileMoving = 0;
                long fileMemoryUsage = 0L;
                if (e.getValue().getCache().isEmpty()) continue;
                ArrayList<LlapDataBuffer> lockedBufs = null;
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    lockedBufs = new ArrayList<LlapDataBuffer>();
                }
                for (Map.Entry<Long, LlapDataBuffer> e2 : e.getValue().getCache().entrySet()) {
                    int newRc = e2.getValue().tryIncRef();
                    if (newRc < 0) {
                        if (newRc == -1) {
                            ++fileEvicted;
                            continue;
                        }
                        if (newRc != -2) continue;
                        ++fileMoving;
                        continue;
                    }
                    try {
                        if (newRc > 1) {
                            ++fileLocked;
                            if (lockedBufs == null) continue;
                            lockedBufs.add(e2.getValue());
                            continue;
                        }
                        ++fileUnlocked;
                    }
                    finally {
                        fileMemoryUsage += (long)e2.getValue().allocSize;
                        e2.getValue().decRef();
                    }
                }
                allLocked += fileLocked;
                allUnlocked += fileUnlocked;
                allEvicted += fileEvicted;
                allMoving += fileMoving;
                totalUsedSpace += fileMemoryUsage;
                sb.append("\n  file " + e.getKey() + ": " + fileLocked + " locked, " + fileUnlocked + " unlocked, " + fileEvicted + " evicted, " + fileMoving + " being moved," + fileMemoryUsage + " total used byte");
                if (fileLocked <= 0 || !LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) continue;
                LlapIoImpl.LOCKING_LOGGER.trace("locked-buffers: {}", lockedBufs);
            }
            finally {
                e.getValue().decRef();
            }
        }
        sb.append("\nORC cache summary: " + allLocked + " locked, " + allUnlocked + " unlocked, " + allEvicted + " evicted, " + allMoving + " being moved," + totalUsedSpace + "total used space");
    }

    private static final class CleanupThread
    extends FileCacheCleanupThread<ConcurrentSkipListMap<Long, LlapDataBuffer>> {
        public CleanupThread(ConcurrentHashMap<Object, FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>>> fileMap, AtomicInteger newEvictions, long cleanupInterval) {
            super("Llap low level cache cleanup thread", fileMap, newEvictions, cleanupInterval);
        }

        @Override
        protected int getCacheSize(FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>> fc) {
            return fc.getCache().size();
        }

        @Override
        public int cleanUpOneFileCache(FileCache<ConcurrentSkipListMap<Long, LlapDataBuffer>> fc, int leftToCheck, long endTime, Ref<Boolean> isPastEndTime) throws InterruptedException {
            Iterator<Map.Entry<Long, LlapDataBuffer>> subIter = fc.getCache().entrySet().iterator();
            while (subIter.hasNext()) {
                long time = -1L;
                isPastEndTime.value = (Boolean)isPastEndTime.value != false || (time = System.nanoTime()) >= endTime;
                Thread.sleep(leftToCheck <= 0 || (Boolean)isPastEndTime.value != false ? 1L : (endTime - time) / (1000000L * (long)leftToCheck));
                if (subIter.next().getValue().isInvalid()) {
                    subIter.remove();
                }
                --leftToCheck;
            }
            return leftToCheck;
        }
    }
}

