/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

public abstract class Retry<T> {
    public static final int MAX_RETRIES = 3;
    private int tries = 0;
    private Class retryExceptionType;

    public Retry(Class exceptionClassType) {
        this.retryExceptionType = exceptionClassType;
    }

    public abstract T execute() throws Exception;

    public T run() throws Exception {
        try {
            return this.execute();
        }
        catch (Exception e) {
            if (e.getClass().equals(this.retryExceptionType)) {
                ++this.tries;
                if (3 == this.tries) {
                    throw e;
                }
                return this.run();
            }
            throw e;
        }
    }
}

