/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;

public class FilterUtils {
    public static Database filterDbIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Database db) throws MetaException, NoSuchObjectException {
        Database filteredDb;
        if (isFilterEnabled && (filteredDb = filterHook.filterDatabase(db)) == null) {
            throw new NoSuchObjectException("DB " + db.getName() + " not found.");
        }
        return db;
    }

    public static List<String> filterDbNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<String> dbNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterDatabases(dbNames);
        }
        return dbNames;
    }

    public static List<String> filterTableNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String catName, String dbName, List<String> tableNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterTableNames(catName, dbName, tableNames);
        }
        return tableNames;
    }

    public static List<Table> filterTablesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<Table> tables) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterTables(tables);
        }
        return tables;
    }

    public static Table filterTableIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Table table) throws MetaException, NoSuchObjectException {
        Table filteredTable;
        if (isFilterEnabled && (filteredTable = filterHook.filterTable(table)) == null) {
            throw new NoSuchObjectException("Table " + table.getDbName() + "." + table.getTableName() + " not found.");
        }
        return table;
    }

    public static List<TableMeta> filterTableMetasIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String catName, String dbName, List<TableMeta> tableMetas) throws MetaException, NoSuchObjectException {
        if (tableMetas == null || tableMetas.isEmpty()) {
            return tableMetas;
        }
        if (isFilterEnabled) {
            return filterHook.filterTableMetas(catName, dbName, tableMetas);
        }
        return tableMetas;
    }

    public static Partition filterPartitionIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Partition p) throws MetaException, NoSuchObjectException {
        Partition filteredPartition;
        if (isFilterEnabled && (filteredPartition = filterHook.filterPartition(p)) == null) {
            throw new NoSuchObjectException("Partition in " + p.getCatName() + "#" + p.getDbName() + "." + p.getTableName() + " not found.");
        }
        return p;
    }

    public static List<Partition> filterPartitionsIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<Partition> partitions) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterPartitions(partitions);
        }
        return partitions;
    }

    public static List<String> filterPartitionNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String catName, String dbName, String tableName, List<String> partitionNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterPartitionNames(catName, dbName, tableName, partitionNames);
        }
        return partitionNames;
    }

    public static List<PartitionSpec> filterPartitionSpecsIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<PartitionSpec> partitionSpecs) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterPartitionSpecs(partitionSpecs);
        }
        return partitionSpecs;
    }

    public static Catalog filterCatalogIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, Catalog catalog) throws MetaException, NoSuchObjectException {
        Catalog filteredCatalog;
        if (isFilterEnabled && (filteredCatalog = filterHook.filterCatalog(catalog)) == null) {
            throw new NoSuchObjectException("Catalog " + catalog.getName() + " not found.");
        }
        return catalog;
    }

    public static List<String> filterCatalogNamesIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, List<String> catalogNames) throws MetaException {
        if (isFilterEnabled) {
            return filterHook.filterCatalogs(catalogNames);
        }
        return catalogNames;
    }

    public static void checkDbAndTableFilters(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String catName, String dbName, String tblName) throws NoSuchObjectException, MetaException {
        if (catName == null) {
            throw new NullPointerException("catName is null");
        }
        if (StringUtils.isBlank((CharSequence)catName)) {
            throw new NoSuchObjectException("catName is not valid");
        }
        if (dbName == null) {
            throw new NullPointerException("dbName is null");
        }
        if (StringUtils.isBlank((CharSequence)dbName)) {
            throw new NoSuchObjectException("dbName is not valid");
        }
        List<String> filteredDb = FilterUtils.filterDbNamesIfEnabled(isFilterEnabled, filterHook, Collections.singletonList(dbName));
        if (filteredDb.isEmpty()) {
            throw new NoSuchObjectException("Database " + dbName + " does not exist");
        }
        if (tblName == null) {
            throw new NullPointerException("tblName is null");
        }
        if (StringUtils.isBlank((CharSequence)tblName)) {
            throw new NoSuchObjectException("tblName is not valid");
        }
        List<String> filteredTable = FilterUtils.filterTableNamesIfEnabled(isFilterEnabled, filterHook, catName, dbName, Collections.singletonList(tblName));
        if (filteredTable.isEmpty()) {
            throw new NoSuchObjectException("Table " + tblName + " does not exist");
        }
    }

    public static List<ShowCompactResponseElement> filterCompactionsIfEnabled(boolean isFilterEnabled, MetaStoreFilterHook filterHook, String catName, List<ShowCompactResponseElement> compactions) throws MetaException {
        if (isFilterEnabled) {
            ArrayList<ShowCompactResponseElement> result = new ArrayList<ShowCompactResponseElement>(compactions.size());
            HashMap<String, List<String>> nonPartTables = new HashMap<String, List<String>>();
            HashMap<String, Map> partTables = new HashMap<String, Map>();
            for (ShowCompactResponseElement showCompactResponseElement : compactions) {
                if (showCompactResponseElement.getPartitionname() == null) {
                    nonPartTables.computeIfAbsent(showCompactResponseElement.getDbname(), k -> new ArrayList());
                    if (((List)nonPartTables.get(showCompactResponseElement.getDbname())).contains(showCompactResponseElement.getTablename())) continue;
                    ((List)nonPartTables.get(showCompactResponseElement.getDbname())).add(showCompactResponseElement.getTablename());
                    continue;
                }
                partTables.computeIfAbsent(showCompactResponseElement.getDbname(), k -> new HashMap());
                ((Map)partTables.get(showCompactResponseElement.getDbname())).computeIfAbsent(showCompactResponseElement.getTablename(), k -> new ArrayList());
                if (((List)((Map)partTables.get(showCompactResponseElement.getDbname())).get(showCompactResponseElement.getTablename())).contains(showCompactResponseElement.getPartitionname())) continue;
                ((List)((Map)partTables.get(showCompactResponseElement.getDbname())).get(showCompactResponseElement.getTablename())).add(showCompactResponseElement.getPartitionname());
            }
            for (Map.Entry entry : nonPartTables.entrySet()) {
                nonPartTables.put((String)entry.getKey(), filterHook.filterTableNames(catName, (String)entry.getKey(), (List)entry.getValue()));
            }
            for (Map.Entry entry : partTables.entrySet()) {
                for (Map.Entry tableName : ((Map)entry.getValue()).entrySet()) {
                    ((Map)entry.getValue()).put(tableName.getKey(), filterHook.filterPartitionNames(catName, (String)entry.getKey(), (String)tableName.getKey(), (List)tableName.getValue()));
                }
            }
            for (ShowCompactResponseElement showCompactResponseElement : compactions) {
                if (showCompactResponseElement.getPartitionname() == null) {
                    if (!((List)nonPartTables.get(showCompactResponseElement.getDbname())).contains(showCompactResponseElement.getTablename())) continue;
                    result.add(showCompactResponseElement);
                    continue;
                }
                if (!((List)((Map)partTables.get(showCompactResponseElement.getDbname())).get(showCompactResponseElement.getTablename())).contains(showCompactResponseElement.getPartitionname())) continue;
                result.add(showCompactResponseElement);
            }
            return result;
        }
        return compactions;
    }
}

