/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.repl;

import java.io.Serializable;
import java.util.regex.Pattern;

public class ReplScope
implements Serializable {
    private String dbName;
    private Pattern dbNamePattern;
    private String includedTableNames;
    private String excludedTableNames;
    private Pattern includedTableNamePattern;
    private Pattern excludedTableNamePattern;

    public ReplScope() {
    }

    public ReplScope(String dbName) {
        this.setDbName(dbName);
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
        this.dbNamePattern = dbName == null || "*".equals(dbName) ? null : Pattern.compile(dbName, 2);
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setIncludedTablePatterns(String includedTableNames) {
        this.includedTableNames = includedTableNames;
        this.includedTableNamePattern = this.compilePattern(includedTableNames);
    }

    public String getIncludedTableNames() {
        return this.includedTableNames;
    }

    public void setExcludedTablePatterns(String excludedTableNames) {
        this.excludedTableNames = excludedTableNames;
        this.excludedTableNamePattern = this.compilePattern(excludedTableNames);
    }

    public String getExcludedTableNames() {
        return this.excludedTableNames;
    }

    public boolean includeAllTables() {
        return this.includedTableNamePattern == null && this.excludedTableNamePattern == null;
    }

    public boolean includedInReplScope(String dbName, String tableName) {
        return this.dbIncludedInReplScope(dbName) && this.tableIncludedInReplScope(tableName);
    }

    public boolean dbIncludedInReplScope(String dbName) {
        return this.dbNamePattern == null || this.dbNamePattern.matcher(dbName).matches();
    }

    public boolean tableIncludedInReplScope(String tableName) {
        if (tableName == null) {
            return true;
        }
        return this.inTableIncludedList(tableName) && !this.inTableExcludedList(tableName);
    }

    private Pattern compilePattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern, 2);
    }

    private boolean inTableIncludedList(String tableName) {
        if (this.includedTableNamePattern == null) {
            return true;
        }
        return this.includedTableNamePattern.matcher(tableName).matches();
    }

    private boolean inTableExcludedList(String tableName) {
        if (this.excludedTableNamePattern == null) {
            return false;
        }
        return this.excludedTableNamePattern.matcher(tableName).matches();
    }
}

